<?php
/**
 * Functions.
 *
 * @package xts.
 */

if ( ! function_exists( 'xts_compress' ) ) {
	/**
	 * Encodes data to MIME base64 format.
	 *
	 * @param string $data data.
	 *
	 * @return string
	 */
	function xts_compress( $data ) {
		return base64_encode( $data );
	}
}

if ( ! function_exists( 'xts_decompress' ) ) {
	/**
	 * Decodes data encoded by MIME base64.
	 *
	 * @param string $data The encoded data.
	 * @param bool   $strict Returns false if input contains character from outside the base64.
	 *
	 * @return string
	 */
	function xts_decompress( $data, $strict = false ) {
		return base64_decode( $data, $strict );
	}
}
if ( ! function_exists( 'xts_get_content_file' ) ) {
	/**
	 * Reads entire file into a string.
	 *
	 * @param string $file_name Filename.
	 *
	 * @return false|string
	 */
	function xts_get_content_file( $file_name ) {
		return file_get_contents( $file_name );
	}
}

if ( ! function_exists( 'xts_add_boxes' ) ) {
	/**
	 * Adds a meta box to one or more screens.
	 *
	 * @param string                 $id            Meta box ID.
	 * @param string                 $title         Title of the meta box.
	 * @param callable               $callback      Function that fills the box with the desired content.
	 * @param string|array|WP_Screen $screen        The screen or screens on which to show the box
	 *                                              (such as a post type, 'link', or 'comment').
	 * @param string                 $context       The context within the screen where the box
	 *                                              should display.
	 * @param string                 $priority      Optional. The priority within the context where the box should show.
	 *                                              Accepts 'high', 'core', 'default', or 'low'. Default 'default'.
	 * @param array                  $callback_args Optional. Data that should be set as the $args property
	 *                                              of the box array. Default null.
	 */
	function xts_add_box( $id, $title, $callback, $screen = null, $context = 'advanced', $priority = 'default', $callback_args = null ) {
		add_meta_box( $id, $title, $callback, $screen, $context, $priority, $callback_args );
	}
}

if ( ! function_exists( 'xts_taxonomy_register_on_import' ) ) {
	/**
	 * Register taxonomy.
	 *
	 * @param array $attr Attribute.
	 */
	function xts_taxonomy_register_on_import( $attr ) {
		register_taxonomy(
			'pa_' . $attr['slug'],
			'product',
			array(
				'labels' => array(
					'name' => $attr['name'],
				),
			)
		);
	}
}

if ( ! function_exists( 'xts_is_pjax' ) ) {
	/**
	 * Is pjax request
	 *
	 * @since 1.0.0
	 * @return boolean
	 */
	function xts_is_pjax() {
		$request_headers = function_exists( 'getallheaders' ) ? getallheaders() : array();

		return isset( $_REQUEST['_pjax'] ) && ( ( isset( $request_headers['X-Requested-With'] ) && 'xmlhttprequest' === strtolower( $request_headers['X-Requested-With'] ) ) || ( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && 'xmlhttprequest' === strtolower( wp_unslash( $_SERVER['HTTP_X_REQUESTED_WITH'] ) ) ) ); // phpcs:ignore
	}
}
