/*!
 * Isotope PACKAGED v2.2.2
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * http://isotope.metafizzy.co
 * Copyright 2015 Metafizzy
 */

/**
 * Bridget makes jQuery widgets
 * v1.1.0
 * MIT license
 */

( function( window ) {



	// -------------------------- utils -------------------------- //

	var slice = Array.prototype.slice;

	function noop() {}

	// -------------------------- definition -------------------------- //

	function defineBridget( $ ) {

		// bail if no jQuery
		if ( !$ ) {
			return;
		}

		// -------------------------- addOptionMethod -------------------------- //

		/**
		 * adds option method -> $().plugin('option', {...})
		 * @param {Function} PluginClass - constructor class
		 */
		function addOptionMethod( PluginClass ) {
			// don't overwrite original option method
			if ( PluginClass.prototype.option ) {
				return;
			}

			// option setter
			PluginClass.prototype.option = function( opts ) {
				// bail out if not an object
				if ( !$.isPlainObject( opts ) ){
					return;
				}
				this.options = $.extend( true, this.options, opts );
			};
		}

		// -------------------------- plugin bridge -------------------------- //

		// helper function for logging errors
		// $.error breaks jQuery chaining
		var logError = typeof console === 'undefined' ? noop :
			function( message ) {
				console.error( message );
			};

		/**
		 * jQuery plugin bridge, access methods like $elem.plugin('method')
		 * @param {String} namespace - plugin name
		 * @param {Function} PluginClass - constructor class
		 */
		function bridge( namespace, PluginClass ) {
			// add to jQuery fn namespace
			$.fn[ namespace ] = function( options ) {
				if ( typeof options === 'string' ) {
					// call plugin method when first argument is a string
					// get arguments for method
					var args = slice.call( arguments, 1 );

					for ( var i=0, len = this.length; i < len; i++ ) {
						var elem = this[i];
						var instance = $.data( elem, namespace );
						if ( !instance ) {
							logError( "cannot call methods on " + namespace + " prior to initialization; " +
								"attempted to call '" + options + "'" );
							continue;
						}
						if ( !$.isFunction( instance[options] ) || options.charAt(0) === '_' ) {
							logError( "no such method '" + options + "' for " + namespace + " instance" );
							continue;
						}

						// trigger method with arguments
						var returnValue = instance[ options ].apply( instance, args );

						// break look and return first value if provided
						if ( returnValue !== undefined ) {
							return returnValue;
						}
					}
					// return this if no return value
					return this;
				} else {
					return this.each( function() {
						var instance = $.data( this, namespace );
						if ( instance ) {
							// apply options & init
							instance.option( options );
							instance._init();
						} else {
							// initialize new instance
							instance = new PluginClass( this, options );
							$.data( this, namespace, instance );
						}
					});
				}
			};

		}

		// -------------------------- bridget -------------------------- //

		/**
		 * converts a Prototypical class into a proper jQuery plugin
		 *   the class must have a ._init method
		 * @param {String} namespace - plugin name, used in $().pluginName
		 * @param {Function} PluginClass - constructor class
		 */
		$.bridget = function( namespace, PluginClass ) {
			addOptionMethod( PluginClass );
			bridge( namespace, PluginClass );
		};

		return $.bridget;

	}

	// transport
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'jquery-bridget/jquery.bridget',[ 'jquery' ], defineBridget );
	} else if ( typeof exports === 'object' ) {
		defineBridget( require('jquery') );
	} else {
		// get jquery from browser global
		defineBridget( window.jQuery );
	}

})( window );

/*!
 * eventie v1.0.6
 * event binding helper
 *   eventie.bind( elem, 'click', myFn )
 *   eventie.unbind( elem, 'click', myFn )
 * MIT license
 */

/*jshint browser: true, undef: true, unused: true */
/*global define: false, module: false */

( function( window ) {



	var docElem = document.documentElement;

	var bind = function() {};

	function getIEEvent( obj ) {
		var event = window.event;
		// add event.target
		event.target = event.target || event.srcElement || obj;
		return event;
	}

	if ( docElem.addEventListener ) {
		bind = function( obj, type, fn ) {
			obj.addEventListener( type, fn, false );
		};
	} else if ( docElem.attachEvent ) {
		bind = function( obj, type, fn ) {
			obj[ type + fn ] = fn.handleEvent ?
				function() {
					var event = getIEEvent( obj );
					fn.handleEvent.call( fn, event );
				} :
				function() {
					var event = getIEEvent( obj );
					fn.call( obj, event );
				};
			obj.attachEvent( "on" + type, obj[ type + fn ] );
		};
	}

	var unbind = function() {};

	if ( docElem.removeEventListener ) {
		unbind = function( obj, type, fn ) {
			obj.removeEventListener( type, fn, false );
		};
	} else if ( docElem.detachEvent ) {
		unbind = function( obj, type, fn ) {
			obj.detachEvent( "on" + type, obj[ type + fn ] );
			try {
				delete obj[ type + fn ];
			} catch ( err ) {
				// can't delete window object properties
				obj[ type + fn ] = undefined;
			}
		};
	}

	var eventie = {
		bind: bind,
		unbind: unbind
	};

	// ----- module definition ----- //

	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'eventie/eventie',eventie );
	} else if ( typeof exports === 'object' ) {
		// CommonJS
		module.exports = eventie;
	} else {
		// browser global
		window.eventie = eventie;
	}

})( window );

/*!
 * EventEmitter v4.2.11 - git.io/ee
 * Unlicense - http://unlicense.org/
 * Oliver Caldwell - http://oli.me.uk/
 * @preserve
 */

;(function () {
	'use strict';

	/**
	 * Class for managing events.
	 * Can be extended to provide event functionality in other classes.
	 *
	 * @class EventEmitter Manages event registering and emitting.
	 */
	function EventEmitter() {}

	// Shortcuts to improve speed and size
	var proto = EventEmitter.prototype;
	var exports = this;
	var originalGlobalValue = exports.EventEmitter;

	/**
	 * Finds the index of the listener for the event in its storage array.
	 *
	 * @param {Function[]} listeners Array of listeners to search through.
	 * @param {Function} listener Method to look for.
	 * @return {Number} Index of the specified listener, -1 if not found
	 * @api private
	 */
	function indexOfListener(listeners, listener) {
		var i = listeners.length;
		while (i--) {
			if (listeners[i].listener === listener) {
				return i;
			}
		}

		return -1;
	}

	/**
	 * Alias a method while keeping the context correct, to allow for overwriting of target method.
	 *
	 * @param {String} name The name of the target method.
	 * @return {Function} The aliased method
	 * @api private
	 */
	function alias(name) {
		return function aliasClosure() {
			return this[name].apply(this, arguments);
		};
	}

	/**
	 * Returns the listener array for the specified event.
	 * Will initialise the event object and listener arrays if required.
	 * Will return an object if you use a regex search. The object contains keys for each matched event. So /ba[rz]/ might return an object containing bar and baz. But only if you have either defined them with defineEvent or added some listeners to them.
	 * Each property in the object response is an array of listener functions.
	 *
	 * @param {String|RegExp} evt Name of the event to return the listeners from.
	 * @return {Function[]|Object} All listener functions for the event.
	 */
	proto.getListeners = function getListeners(evt) {
		var events = this._getEvents();
		var response;
		var key;

		// Return a concatenated array of all matching events if
		// the selector is a regular expression.
		if (evt instanceof RegExp) {
			response = {};
			for (key in events) {
				if (events.hasOwnProperty(key) && evt.test(key)) {
					response[key] = events[key];
				}
			}
		}
		else {
			response = events[evt] || (events[evt] = []);
		}

		return response;
	};

	/**
	 * Takes a list of listener objects and flattens it into a list of listener functions.
	 *
	 * @param {Object[]} listeners Raw listener objects.
	 * @return {Function[]} Just the listener functions.
	 */
	proto.flattenListeners = function flattenListeners(listeners) {
		var flatListeners = [];
		var i;

		for (i = 0; i < listeners.length; i += 1) {
			flatListeners.push(listeners[i].listener);
		}

		return flatListeners;
	};

	/**
	 * Fetches the requested listeners via getListeners but will always return the results inside an object. This is mainly for internal use but others may find it useful.
	 *
	 * @param {String|RegExp} evt Name of the event to return the listeners from.
	 * @return {Object} All listener functions for an event in an object.
	 */
	proto.getListenersAsObject = function getListenersAsObject(evt) {
		var listeners = this.getListeners(evt);
		var response;

		if (listeners instanceof Array) {
			response = {};
			response[evt] = listeners;
		}

		return response || listeners;
	};

	/**
	 * Adds a listener function to the specified event.
	 * The listener will not be added if it is a duplicate.
	 * If the listener returns true then it will be removed after it is called.
	 * If you pass a regular expression as the event name then the listener will be added to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to attach the listener to.
	 * @param {Function} listener Method to be called when the event is emitted. If the function returns true then it will be removed after calling.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addListener = function addListener(evt, listener) {
		var listeners = this.getListenersAsObject(evt);
		var listenerIsWrapped = typeof listener === 'object';
		var key;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key) && indexOfListener(listeners[key], listener) === -1) {
				listeners[key].push(listenerIsWrapped ? listener : {
					listener: listener,
					once: false
				});
			}
		}

		return this;
	};

	/**
	 * Alias of addListener
	 */
	proto.on = alias('addListener');

	/**
	 * Semi-alias of addListener. It will add a listener that will be
	 * automatically removed after its first execution.
	 *
	 * @param {String|RegExp} evt Name of the event to attach the listener to.
	 * @param {Function} listener Method to be called when the event is emitted. If the function returns true then it will be removed after calling.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addOnceListener = function addOnceListener(evt, listener) {
		return this.addListener(evt, {
			listener: listener,
			once: true
		});
	};

	/**
	 * Alias of addOnceListener.
	 */
	proto.once = alias('addOnceListener');

	/**
	 * Defines an event name. This is required if you want to use a regex to add a listener to multiple events at once. If you don't do this then how do you expect it to know what event to add to? Should it just add to every possible match for a regex? No. That is scary and bad.
	 * You need to tell it what event names should be matched by a regex.
	 *
	 * @param {String} evt Name of the event to create.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.defineEvent = function defineEvent(evt) {
		this.getListeners(evt);
		return this;
	};

	/**
	 * Uses defineEvent to define multiple events.
	 *
	 * @param {String[]} evts An array of event names to define.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.defineEvents = function defineEvents(evts) {
		for (var i = 0; i < evts.length; i += 1) {
			this.defineEvent(evts[i]);
		}
		return this;
	};

	/**
	 * Removes a listener function from the specified event.
	 * When passed a regular expression as the event name, it will remove the listener from all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to remove the listener from.
	 * @param {Function} listener Method to remove from the event.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeListener = function removeListener(evt, listener) {
		var listeners = this.getListenersAsObject(evt);
		var index;
		var key;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key)) {
				index = indexOfListener(listeners[key], listener);

				if (index !== -1) {
					listeners[key].splice(index, 1);
				}
			}
		}

		return this;
	};

	/**
	 * Alias of removeListener
	 */
	proto.off = alias('removeListener');

	/**
	 * Adds listeners in bulk using the manipulateListeners method.
	 * If you pass an object as the second argument you can add to multiple events at once. The object should contain key value pairs of events and listeners or listener arrays. You can also pass it an event name and an array of listeners to be added.
	 * You can also pass it a regular expression to add the array of listeners to all events that match it.
	 * Yeah, this function does quite a bit. That's probably a bad thing.
	 *
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to add to multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to add.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addListeners = function addListeners(evt, listeners) {
		// Pass through to manipulateListeners
		return this.manipulateListeners(false, evt, listeners);
	};

	/**
	 * Removes listeners in bulk using the manipulateListeners method.
	 * If you pass an object as the second argument you can remove from multiple events at once. The object should contain key value pairs of events and listeners or listener arrays.
	 * You can also pass it an event name and an array of listeners to be removed.
	 * You can also pass it a regular expression to remove the listeners from all events that match it.
	 *
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to remove from multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to remove.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeListeners = function removeListeners(evt, listeners) {
		// Pass through to manipulateListeners
		return this.manipulateListeners(true, evt, listeners);
	};

	/**
	 * Edits listeners in bulk. The addListeners and removeListeners methods both use this to do their job. You should really use those instead, this is a little lower level.
	 * The first argument will determine if the listeners are removed (true) or added (false).
	 * If you pass an object as the second argument you can add/remove from multiple events at once. The object should contain key value pairs of events and listeners or listener arrays.
	 * You can also pass it an event name and an array of listeners to be added/removed.
	 * You can also pass it a regular expression to manipulate the listeners of all events that match it.
	 *
	 * @param {Boolean} remove True if you want to remove listeners, false if you want to add.
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to add/remove from multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to add/remove.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.manipulateListeners = function manipulateListeners(remove, evt, listeners) {
		var i;
		var value;
		var single = remove ? this.removeListener : this.addListener;
		var multiple = remove ? this.removeListeners : this.addListeners;

		// If evt is an object then pass each of its properties to this method
		if (typeof evt === 'object' && !(evt instanceof RegExp)) {
			for (i in evt) {
				if (evt.hasOwnProperty(i) && (value = evt[i])) {
					// Pass the single listener straight through to the singular method
					if (typeof value === 'function') {
						single.call(this, i, value);
					}
					else {
						// Otherwise pass back to the multiple function
						multiple.call(this, i, value);
					}
				}
			}
		}
		else {
			// So evt must be a string
			// And listeners must be an array of listeners
			// Loop over it and pass each one to the multiple method
			i = listeners.length;
			while (i--) {
				single.call(this, evt, listeners[i]);
			}
		}

		return this;
	};

	/**
	 * Removes all listeners from a specified event.
	 * If you do not specify an event then all listeners will be removed.
	 * That means every event will be emptied.
	 * You can also pass a regex to remove all events that match it.
	 *
	 * @param {String|RegExp} [evt] Optional name of the event to remove all listeners for. Will remove from every event if not passed.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeEvent = function removeEvent(evt) {
		var type = typeof evt;
		var events = this._getEvents();
		var key;

		// Remove different things depending on the state of evt
		if (type === 'string') {
			// Remove all listeners for the specified event
			delete events[evt];
		}
		else if (evt instanceof RegExp) {
			// Remove all events matching the regex.
			for (key in events) {
				if (events.hasOwnProperty(key) && evt.test(key)) {
					delete events[key];
				}
			}
		}
		else {
			// Remove all listeners in all events
			delete this._events;
		}

		return this;
	};

	/**
	 * Alias of removeEvent.
	 *
	 * Added to mirror the node API.
	 */
	proto.removeAllListeners = alias('removeEvent');

	/**
	 * Emits an event of your choice.
	 * When emitted, every listener attached to that event will be executed.
	 * If you pass the optional argument array then those arguments will be passed to every listener upon execution.
	 * Because it uses `apply`, your array of arguments will be passed as if you wrote them out separately.
	 * So they will not arrive within the array on the other side, they will be separate.
	 * You can also pass a regular expression to emit to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to emit and execute listeners for.
	 * @param {Array} [args] Optional array of arguments to be passed to each listener.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.emitEvent = function emitEvent(evt, args) {
		var listeners = this.getListenersAsObject(evt);
		var listener;
		var i;
		var key;
		var response;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key)) {
				i = listeners[key].length;

				while (i--) {
					// If the listener returns true then it shall be removed from the event
					// The function is executed either with a basic call or an apply if there is an args array
					listener = listeners[key][i];

					if (listener.once === true) {
						this.removeListener(evt, listener.listener);
					}

					response = listener.listener.apply(this, args || []);

					if (response === this._getOnceReturnValue()) {
						this.removeListener(evt, listener.listener);
					}
				}
			}
		}

		return this;
	};

	/**
	 * Alias of emitEvent
	 */
	proto.trigger = alias('emitEvent');

	/**
	 * Subtly different from emitEvent in that it will pass its arguments on to the listeners, as opposed to taking a single array of arguments to pass on.
	 * As with emitEvent, you can pass a regex in place of the event name to emit to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to emit and execute listeners for.
	 * @param {...*} Optional additional arguments to be passed to each listener.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.emit = function emit(evt) {
		var args = Array.prototype.slice.call(arguments, 1);
		return this.emitEvent(evt, args);
	};

	/**
	 * Sets the current value to check against when executing listeners. If a
	 * listeners return value matches the one set here then it will be removed
	 * after execution. This value defaults to true.
	 *
	 * @param {*} value The new value to check for when executing listeners.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.setOnceReturnValue = function setOnceReturnValue(value) {
		this._onceReturnValue = value;
		return this;
	};

	/**
	 * Fetches the current value to check against when executing listeners. If
	 * the listeners return value matches this one then it should be removed
	 * automatically. It will return true by default.
	 *
	 * @return {*|Boolean} The current value to check for or the default, true.
	 * @api private
	 */
	proto._getOnceReturnValue = function _getOnceReturnValue() {
		if (this.hasOwnProperty('_onceReturnValue')) {
			return this._onceReturnValue;
		}
		else {
			return true;
		}
	};

	/**
	 * Fetches the events object and creates one if required.
	 *
	 * @return {Object} The events storage object.
	 * @api private
	 */
	proto._getEvents = function _getEvents() {
		return this._events || (this._events = {});
	};

	/**
	 * Reverts the global {@link EventEmitter} to its previous value and returns a reference to this version.
	 *
	 * @return {Function} Non conflicting EventEmitter class.
	 */
	EventEmitter.noConflict = function noConflict() {
		exports.EventEmitter = originalGlobalValue;
		return EventEmitter;
	};

	// Expose the class either via AMD, CommonJS or the global object
	if (typeof define === 'function' && define.amd) {
		define('eventEmitter/EventEmitter',[],function () {
			return EventEmitter;
		});
	}
	else if (typeof module === 'object' && module.exports){
		module.exports = EventEmitter;
	}
	else {
		exports.EventEmitter = EventEmitter;
	}
}.call(this));

/*!
 * getStyleProperty v1.0.4
 * original by kangax
 * http://perfectionkills.com/feature-testing-css-properties/
 * MIT license
 */

/*jshint browser: true, strict: true, undef: true */
/*global define: false, exports: false, module: false */

( function( window ) {



	var prefixes = 'Webkit Moz ms Ms O'.split(' ');
	var docElemStyle = document.documentElement.style;

	function getStyleProperty( propName ) {
		if ( !propName ) {
			return;
		}

		// test standard property first
		if ( typeof docElemStyle[ propName ] === 'string' ) {
			return propName;
		}

		// capitalize
		propName = propName.charAt(0).toUpperCase() + propName.slice(1);

		// test vendor specific properties
		var prefixed;
		for ( var i=0, len = prefixes.length; i < len; i++ ) {
			prefixed = prefixes[i] + propName;
			if ( typeof docElemStyle[ prefixed ] === 'string' ) {
				return prefixed;
			}
		}
	}

	// transport
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'get-style-property/get-style-property',[],function() {
			return getStyleProperty;
		});
	} else if ( typeof exports === 'object' ) {
		// CommonJS for Component
		module.exports = getStyleProperty;
	} else {
		// browser global
		window.getStyleProperty = getStyleProperty;
	}

})( window );

/*!
 * getSize v1.2.2
 * measure size of elements
 * MIT license
 */

/*jshint browser: true, strict: true, undef: true, unused: true */
/*global define: false, exports: false, require: false, module: false, console: false */

( function( window, undefined ) {



	// -------------------------- helpers -------------------------- //

	// get a number from a string, not a percentage
	function getStyleSize( value ) {
		var num = parseFloat( value );
		// not a percent like '100%', and a number
		var isValid = value.indexOf('%') === -1 && !isNaN( num );
		return isValid && num;
	}

	function noop() {}

	var logError = typeof console === 'undefined' ? noop :
		function( message ) {
			console.error( message );
		};

	// -------------------------- measurements -------------------------- //

	var measurements = [
		'paddingLeft',
		'paddingRight',
		'paddingTop',
		'paddingBottom',
		'marginLeft',
		'marginRight',
		'marginTop',
		'marginBottom',
		'borderLeftWidth',
		'borderRightWidth',
		'borderTopWidth',
		'borderBottomWidth'
	];

	function getZeroSize() {
		var size = {
			width: 0,
			height: 0,
			innerWidth: 0,
			innerHeight: 0,
			outerWidth: 0,
			outerHeight: 0
		};
		for ( var i=0, len = measurements.length; i < len; i++ ) {
			var measurement = measurements[i];
			size[ measurement ] = 0;
		}
		return size;
	}



	function defineGetSize( getStyleProperty ) {

		// -------------------------- setup -------------------------- //

		var isSetup = false;

		var getStyle, boxSizingProp, isBoxSizeOuter;

		/**
		 * setup vars and functions
		 * do it on initial getSize(), rather than on script load
		 * For Firefox bug https://bugzilla.mozilla.org/show_bug.cgi?id=548397
		 */
		function setup() {
			// setup once
			if ( isSetup ) {
				return;
			}
			isSetup = true;

			var getComputedStyle = window.getComputedStyle;
			getStyle = ( function() {
				var getStyleFn = getComputedStyle ?
					function( elem ) {
						return getComputedStyle( elem, null );
					} :
					function( elem ) {
						return elem.currentStyle;
					};

				return function getStyle( elem ) {
					var style = getStyleFn( elem );
					if ( !style ) {
						logError( 'Style returned ' + style +
							'. Are you running this code in a hidden iframe on Firefox? ' +
							'See http://bit.ly/getsizebug1' );
					}
					return style;
				};
			})();

			// -------------------------- box sizing -------------------------- //

			boxSizingProp = getStyleProperty('boxSizing');

			/**
			 * WebKit measures the outer-width on style.width on border-box elems
			 * IE & Firefox measures the inner-width
			 */
			if ( boxSizingProp ) {
				var div = document.createElement('div');
				div.style.width = '200px';
				div.style.padding = '1px 2px 3px 4px';
				div.style.borderStyle = 'solid';
				div.style.borderWidth = '1px 2px 3px 4px';
				div.style[ boxSizingProp ] = 'border-box';

				var body = document.body || document.documentElement;
				body.appendChild( div );
				var style = getStyle( div );

				isBoxSizeOuter = getStyleSize( style.width ) === 200;
				body.removeChild( div );
			}

		}

		// -------------------------- getSize -------------------------- //

		function getSize( elem ) {
			setup();

			// use querySeletor if elem is string
			if ( typeof elem === 'string' ) {
				elem = document.querySelector( elem );
			}

			// do not proceed on non-objects
			if ( !elem || typeof elem !== 'object' || !elem.nodeType ) {
				return;
			}

			var style = getStyle( elem );

			// if hidden, everything is 0
			if ( style.display === 'none' ) {
				return getZeroSize();
			}

			var size = {};
			size.width = elem.offsetWidth;
			size.height = elem.offsetHeight;

			var isBorderBox = size.isBorderBox = !!( boxSizingProp &&
				style[ boxSizingProp ] && style[ boxSizingProp ] === 'border-box' );

			// get all measurements
			for ( var i=0, len = measurements.length; i < len; i++ ) {
				var measurement = measurements[i];
				var value = style[ measurement ];
				value = mungeNonPixel( elem, value );
				var num = parseFloat( value );
				// any 'auto', 'medium' value will be 0
				size[ measurement ] = !isNaN( num ) ? num : 0;
			}

			var paddingWidth = size.paddingLeft + size.paddingRight;
			var paddingHeight = size.paddingTop + size.paddingBottom;
			var marginWidth = size.marginLeft + size.marginRight;
			var marginHeight = size.marginTop + size.marginBottom;
			var borderWidth = size.borderLeftWidth + size.borderRightWidth;
			var borderHeight = size.borderTopWidth + size.borderBottomWidth;

			var isBorderBoxSizeOuter = isBorderBox && isBoxSizeOuter;

			// overwrite width and height if we can get it from style
			var styleWidth = getStyleSize( style.width );
			if ( styleWidth !== false ) {
				size.width = styleWidth +
					// add padding and border unless it's already including it
					( isBorderBoxSizeOuter ? 0 : paddingWidth + borderWidth );
			}

			var styleHeight = getStyleSize( style.height );
			if ( styleHeight !== false ) {
				size.height = styleHeight +
					// add padding and border unless it's already including it
					( isBorderBoxSizeOuter ? 0 : paddingHeight + borderHeight );
			}

			size.innerWidth = size.width - ( paddingWidth + borderWidth );
			size.innerHeight = size.height - ( paddingHeight + borderHeight );

			size.outerWidth = size.width + marginWidth;
			size.outerHeight = size.height + marginHeight;

			return size;
		}

		// IE8 returns percent values, not pixels
		// taken from jQuery's curCSS
		function mungeNonPixel( elem, value ) {
			// IE8 and has percent value
			if ( window.getComputedStyle || value.indexOf('%') === -1 ) {
				return value;
			}
			var style = elem.style;
			// Remember the original values
			var left = style.left;
			var rs = elem.runtimeStyle;
			var rsLeft = rs && rs.left;

			// Put in the new values to get a computed value out
			if ( rsLeft ) {
				rs.left = elem.currentStyle.left;
			}
			style.left = value;
			value = style.pixelLeft;

			// Revert the changed values
			style.left = left;
			if ( rsLeft ) {
				rs.left = rsLeft;
			}

			return value;
		}

		return getSize;

	}

	// transport
	if ( typeof define === 'function' && define.amd ) {
		// AMD for RequireJS
		define( 'get-size/get-size',[ 'get-style-property/get-style-property' ], defineGetSize );
	} else if ( typeof exports === 'object' ) {
		// CommonJS for Component
		module.exports = defineGetSize( require('desandro-get-style-property') );
	} else {
		// browser global
		window.getSize = defineGetSize( window.getStyleProperty );
	}

})( window );

/*!
 * docReady v1.0.4
 * Cross browser DOMContentLoaded event emitter
 * MIT license
 */

/*jshint browser: true, strict: true, undef: true, unused: true*/
/*global define: false, require: false, module: false */

( function( window ) {



	var document = window.document;
	// collection of functions to be triggered on ready
	var queue = [];

	function docReady( fn ) {
		// throw out non-functions
		if ( typeof fn !== 'function' ) {
			return;
		}

		if ( docReady.isReady ) {
			// ready now, hit it
			fn();
		} else {
			// queue function when ready
			queue.push( fn );
		}
	}

	docReady.isReady = false;

	// triggered on various doc ready events
	function onReady( event ) {
		// bail if already triggered or IE8 document is not ready just yet
		var isIE8NotReady = event.type === 'readystatechange' && document.readyState !== 'complete';
		if ( docReady.isReady || isIE8NotReady ) {
			return;
		}

		trigger();
	}

	function trigger() {
		docReady.isReady = true;
		// process queue
		for ( var i=0, len = queue.length; i < len; i++ ) {
			var fn = queue[i];
			fn();
		}
	}

	function defineDocReady( eventie ) {
		// trigger ready if page is ready
		if ( document.readyState === 'complete' ) {
			trigger();
		} else {
			// listen for events
			eventie.bind( document, 'DOMContentLoaded', onReady );
			eventie.bind( document, 'readystatechange', onReady );
			eventie.bind( window, 'load', onReady );
		}

		return docReady;
	}

	// transport
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'doc-ready/doc-ready',[ 'eventie/eventie' ], defineDocReady );
	} else if ( typeof exports === 'object' ) {
		module.exports = defineDocReady( require('eventie') );
	} else {
		// browser global
		window.docReady = defineDocReady( window.eventie );
	}

})( window );

/**
 * matchesSelector v1.0.3
 * matchesSelector( element, '.selector' )
 * MIT license
 */

/*jshint browser: true, strict: true, undef: true, unused: true */
/*global define: false, module: false */

( function( ElemProto ) {

	'use strict';

	var matchesMethod = ( function() {
		// check for the standard method name first
		if ( ElemProto.matches ) {
			return 'matches';
		}
		// check un-prefixed
		if ( ElemProto.matchesSelector ) {
			return 'matchesSelector';
		}
		// check vendor prefixes
		var prefixes = [ 'webkit', 'moz', 'ms', 'o' ];

		for ( var i=0, len = prefixes.length; i < len; i++ ) {
			var prefix = prefixes[i];
			var method = prefix + 'MatchesSelector';
			if ( ElemProto[ method ] ) {
				return method;
			}
		}
	})();

	// ----- match ----- //

	function match( elem, selector ) {
		return elem[ matchesMethod ]( selector );
	}

	// ----- appendToFragment ----- //

	function checkParent( elem ) {
		// not needed if already has parent
		if ( elem.parentNode ) {
			return;
		}
		var fragment = document.createDocumentFragment();
		fragment.appendChild( elem );
	}

	// ----- query ----- //

	// fall back to using QSA
	// thx @jonathantneal https://gist.github.com/3062955
	function query( elem, selector ) {
		// append to fragment if no parent
		checkParent( elem );

		// match elem with all selected elems of parent
		var elems = elem.parentNode.querySelectorAll( selector );
		for ( var i=0, len = elems.length; i < len; i++ ) {
			// return true if match
			if ( elems[i] === elem ) {
				return true;
			}
		}
		// otherwise return false
		return false;
	}

	// ----- matchChild ----- //

	function matchChild( elem, selector ) {
		checkParent( elem );
		return match( elem, selector );
	}

	// ----- matchesSelector ----- //

	var matchesSelector;

	if ( matchesMethod ) {
		// IE9 supports matchesSelector, but doesn't work on orphaned elems
		// check for that
		var div = document.createElement('div');
		var supportsOrphans = match( div, 'div' );
		matchesSelector = supportsOrphans ? match : matchChild;
	} else {
		matchesSelector = query;
	}

	// transport
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'matches-selector/matches-selector',[],function() {
			return matchesSelector;
		});
	} else if ( typeof exports === 'object' ) {
		module.exports = matchesSelector;
	}
	else {
		// browser global
		window.matchesSelector = matchesSelector;
	}

})( Element.prototype );

/**
 * Fizzy UI utils v1.0.1
 * MIT license
 */

/*jshint browser: true, undef: true, unused: true, strict: true */

( function( window, factory ) {
	/*global define: false, module: false, require: false */
	'use strict';
	// universal module definition

	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'fizzy-ui-utils/utils',[
			'doc-ready/doc-ready',
			'matches-selector/matches-selector'
		], function( docReady, matchesSelector ) {
			return factory( window, docReady, matchesSelector );
		});
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			window,
			require('doc-ready'),
			require('desandro-matches-selector')
		);
	} else {
		// browser global
		window.fizzyUIUtils = factory(
			window,
			window.docReady,
			window.matchesSelector
		);
	}

}( window, function factory( window, docReady, matchesSelector ) {



	var utils = {};

	// ----- extend ----- //

	// extends objects
	utils.extend = function( a, b ) {
		for ( var prop in b ) {
			a[ prop ] = b[ prop ];
		}
		return a;
	};

	// ----- modulo ----- //

	utils.modulo = function( num, div ) {
		return ( ( num % div ) + div ) % div;
	};

	// ----- isArray ----- //

	var objToString = Object.prototype.toString;
	utils.isArray = function( obj ) {
		return objToString.call( obj ) == '[object Array]';
	};

	// ----- makeArray ----- //

	// turn element or nodeList into an array
	utils.makeArray = function( obj ) {
		var ary = [];
		if ( utils.isArray( obj ) ) {
			// use object if already an array
			ary = obj;
		} else if ( obj && typeof obj.length == 'number' ) {
			// convert nodeList to array
			for ( var i=0, len = obj.length; i < len; i++ ) {
				ary.push( obj[i] );
			}
		} else {
			// array of single index
			ary.push( obj );
		}
		return ary;
	};

	// ----- indexOf ----- //

	// index of helper cause IE8
	utils.indexOf = Array.prototype.indexOf ? function( ary, obj ) {
		return ary.indexOf( obj );
	} : function( ary, obj ) {
		for ( var i=0, len = ary.length; i < len; i++ ) {
			if ( ary[i] === obj ) {
				return i;
			}
		}
		return -1;
	};

	// ----- removeFrom ----- //

	utils.removeFrom = function( ary, obj ) {
		var index = utils.indexOf( ary, obj );
		if ( index != -1 ) {
			ary.splice( index, 1 );
		}
	};

	// ----- isElement ----- //

	// http://stackoverflow.com/a/384380/182183
	utils.isElement = typeof HTMLElement == 'object' ?
		function isElementDOM2( obj ) {
			return obj instanceof HTMLElement;
		} :
		function isElementQuirky( obj ) {
			return obj && typeof obj == 'object' && obj !== null &&
				obj.nodeType == 1 && typeof obj.nodeName == 'string';
		};

	// ----- setText ----- //

	utils.setText = ( function() {
		var setTextProperty;
		function setText( elem, text ) {
			// only check setTextProperty once
			setTextProperty = setTextProperty || ( document.documentElement.textContent !== undefined ? 'textContent' : 'innerText' );
			elem[ setTextProperty ] = text;
		}
		return setText;
	})();

	// ----- getParent ----- //

	utils.getParent = function( elem, selector ) {
		while ( elem != document.body ) {
			elem = elem.parentNode;
			if ( matchesSelector( elem, selector ) ) {
				return elem;
			}
		}
	};

	// ----- getQueryElement ----- //

	// use element as selector string
	utils.getQueryElement = function( elem ) {
		if ( typeof elem == 'string' ) {
			return document.querySelector( elem );
		}
		return elem;
	};

	// ----- handleEvent ----- //

	// enable .ontype to trigger from .addEventListener( elem, 'type' )
	utils.handleEvent = function( event ) {
		var method = 'on' + event.type;
		if ( this[ method ] ) {
			this[ method ]( event );
		}
	};

	// ----- filterFindElements ----- //

	utils.filterFindElements = function( elems, selector ) {
		// make array of elems
		elems = utils.makeArray( elems );
		var ffElems = [];

		for ( var i=0, len = elems.length; i < len; i++ ) {
			var elem = elems[i];
			// check that elem is an actual element
			if ( !utils.isElement( elem ) ) {
				continue;
			}
			// filter & find items if we have a selector
			if ( selector ) {
				// filter siblings
				if ( matchesSelector( elem, selector ) ) {
					ffElems.push( elem );
				}
				// find children
				var childElems = elem.querySelectorAll( selector );
				// concat childElems to filterFound array
				for ( var j=0, jLen = childElems.length; j < jLen; j++ ) {
					ffElems.push( childElems[j] );
				}
			} else {
				ffElems.push( elem );
			}
		}

		return ffElems;
	};

	// ----- debounceMethod ----- //

	utils.debounceMethod = function( _class, methodName, threshold ) {
		// original method
		var method = _class.prototype[ methodName ];
		var timeoutName = methodName + 'Timeout';

		_class.prototype[ methodName ] = function() {
			var timeout = this[ timeoutName ];
			if ( timeout ) {
				clearTimeout( timeout );
			}
			var args = arguments;

			var _this = this;
			this[ timeoutName ] = setTimeout( function() {
				method.apply( _this, args );
				delete _this[ timeoutName ];
			}, threshold || 100 );
		};
	};

	// ----- htmlInit ----- //

	// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
	utils.toDashed = function( str ) {
		return str.replace( /(.)([A-Z])/g, function( match, $1, $2 ) {
			return $1 + '-' + $2;
		}).toLowerCase();
	};

	var console = window.console;
	/**
	 * allow user to initialize classes via .js-namespace class
	 * htmlInit( Widget, 'widgetName' )
	 * options are parsed from data-namespace-option attribute
	 */
	utils.htmlInit = function( WidgetClass, namespace ) {
		docReady( function() {
			var dashedNamespace = utils.toDashed( namespace );
			var elems = document.querySelectorAll( '.js-' + dashedNamespace );
			var dataAttr = 'data-' + dashedNamespace + '-options';

			for ( var i=0, len = elems.length; i < len; i++ ) {
				var elem = elems[i];
				var attr = elem.getAttribute( dataAttr );
				var options;
				try {
					options = attr && JSON.parse( attr );
				} catch ( error ) {
					// log error, do not initialize
					if ( console ) {
						console.error( 'Error parsing ' + dataAttr + ' on ' +
							elem.nodeName.toLowerCase() + ( elem.id ? '#' + elem.id : '' ) + ': ' +
							error );
					}
					continue;
				}
				// initialize
				var instance = new WidgetClass( elem, options );
				// make available via $().data('layoutname')
				var jQuery = window.jQuery;
				if ( jQuery ) {
					jQuery.data( elem, namespace, instance );
				}
			}
		});
	};

	// -----  ----- //

	return utils;

}));

/**
 * Outlayer Item
 */

( function( window, factory ) {
	'use strict';
	// universal module definition
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'outlayer/item',[
				'eventEmitter/EventEmitter',
				'get-size/get-size',
				'get-style-property/get-style-property',
				'fizzy-ui-utils/utils'
			],
			function( EventEmitter, getSize, getStyleProperty, utils ) {
				return factory( window, EventEmitter, getSize, getStyleProperty, utils );
			}
		);
	} else if (typeof exports === 'object') {
		// CommonJS
		module.exports = factory(
			window,
			require('wolfy87-eventemitter'),
			require('get-size'),
			require('desandro-get-style-property'),
			require('fizzy-ui-utils')
		);
	} else {
		// browser global
		window.Outlayer = {};
		window.Outlayer.Item = factory(
			window,
			window.EventEmitter,
			window.getSize,
			window.getStyleProperty,
			window.fizzyUIUtils
		);
	}

}( window, function factory( window, EventEmitter, getSize, getStyleProperty, utils ) {
	'use strict';

	// ----- helpers ----- //

	var getComputedStyle = window.getComputedStyle;
	var getStyle = getComputedStyle ?
		function( elem ) {
			return getComputedStyle( elem, null );
		} :
		function( elem ) {
			return elem.currentStyle;
		};


	function isEmptyObj( obj ) {
		for ( var prop in obj ) {
			return false;
		}
		prop = null;
		return true;
	}

	// -------------------------- CSS3 support -------------------------- //

	var transitionProperty = getStyleProperty('transition');
	var transformProperty = getStyleProperty('transform');
	var supportsCSS3 = transitionProperty && transformProperty;
	var is3d = !!getStyleProperty('perspective');

	var transitionEndEvent = {
		WebkitTransition: 'webkitTransitionEnd',
		MozTransition: 'transitionend',
		OTransition: 'otransitionend',
		transition: 'transitionend'
	}[ transitionProperty ];

	// properties that could have vendor prefix
	var prefixableProperties = [
		'transform',
		'transition',
		'transitionDuration',
		'transitionProperty'
	];

	// cache all vendor properties
	var vendorProperties = ( function() {
		var cache = {};
		for ( var i=0, len = prefixableProperties.length; i < len; i++ ) {
			var prop = prefixableProperties[i];
			var supportedProp = getStyleProperty( prop );
			if ( supportedProp && supportedProp !== prop ) {
				cache[ prop ] = supportedProp;
			}
		}
		return cache;
	})();

	// -------------------------- Item -------------------------- //

	function Item( element, layout ) {
		if ( !element ) {
			return;
		}

		this.element = element;
		// parent layout class, i.e. Masonry, Isotope, or Packery
		this.layout = layout;
		this.position = {
			x: 0,
			y: 0
		};

		this._create();
	}

	// inherit EventEmitter
	utils.extend( Item.prototype, EventEmitter.prototype );

	Item.prototype._create = function() {
		// transition objects
		this._transn = {
			ingProperties: {},
			clean: {},
			onEnd: {}
		};

		this.css({
			position: 'absolute'
		});
	};

	// trigger specified handler for event type
	Item.prototype.handleEvent = function( event ) {
		var method = 'on' + event.type;
		if ( this[ method ] ) {
			this[ method ]( event );
		}
	};

	Item.prototype.getSize = function() {
		this.size = getSize( this.element );
	};

	/**
	 * apply CSS styles to element
	 * @param {Object} style
	 */
	Item.prototype.css = function( style ) {
		var elemStyle = this.element.style;

		for ( var prop in style ) {
			// use vendor property if available
			var supportedProp = vendorProperties[ prop ] || prop;
			elemStyle[ supportedProp ] = style[ prop ];
		}
	};

	// measure position, and sets it
	Item.prototype.getPosition = function() {
		var style = getStyle( this.element );
		var layoutOptions = this.layout.options;
		var isOriginLeft = layoutOptions.isOriginLeft;
		var isOriginTop = layoutOptions.isOriginTop;
		var xValue = style[ isOriginLeft ? 'left' : 'right' ];
		var yValue = style[ isOriginTop ? 'top' : 'bottom' ];
		// convert percent to pixels
		var layoutSize = this.layout.size;
		var x = xValue.indexOf('%') != -1 ?
			( parseFloat( xValue ) / 100 ) * layoutSize.width : parseInt( xValue, 10 );
		var y = yValue.indexOf('%') != -1 ?
			( parseFloat( yValue ) / 100 ) * layoutSize.height : parseInt( yValue, 10 );

		// clean up 'auto' or other non-integer values
		x = isNaN( x ) ? 0 : x;
		y = isNaN( y ) ? 0 : y;
		// remove padding from measurement
		x -= isOriginLeft ? layoutSize.paddingLeft : layoutSize.paddingRight;
		y -= isOriginTop ? layoutSize.paddingTop : layoutSize.paddingBottom;

		this.position.x = x;
		this.position.y = y;
	};

	// set settled position, apply padding
	Item.prototype.layoutPosition = function() {
		var layoutSize = this.layout.size;
		var layoutOptions = this.layout.options;
		var style = {};

		// x
		var xPadding = layoutOptions.isOriginLeft ? 'paddingLeft' : 'paddingRight';
		var xProperty = layoutOptions.isOriginLeft ? 'left' : 'right';
		var xResetProperty = layoutOptions.isOriginLeft ? 'right' : 'left';

		var x = this.position.x + layoutSize[ xPadding ];
		// set in percentage or pixels
		style[ xProperty ] = this.getXValue( x );
		// reset other property
		style[ xResetProperty ] = '';

		// y
		var yPadding = layoutOptions.isOriginTop ? 'paddingTop' : 'paddingBottom';
		var yProperty = layoutOptions.isOriginTop ? 'top' : 'bottom';
		var yResetProperty = layoutOptions.isOriginTop ? 'bottom' : 'top';

		var y = this.position.y + layoutSize[ yPadding ];
		// set in percentage or pixels
		style[ yProperty ] = this.getYValue( y );
		// reset other property
		style[ yResetProperty ] = '';

		this.css( style );
		this.emitEvent( 'layout', [ this ] );
	};

	Item.prototype.getXValue = function( x ) {
		var layoutOptions = this.layout.options;
		return layoutOptions.percentPosition && !layoutOptions.isHorizontal ?
			( ( x / this.layout.size.width ) * 100 ) + '%' : x + 'px';
	};

	Item.prototype.getYValue = function( y ) {
		var layoutOptions = this.layout.options;
		return layoutOptions.percentPosition && layoutOptions.isHorizontal ?
			( ( y / this.layout.size.height ) * 100 ) + '%' : y + 'px';
	};


	Item.prototype._transitionTo = function( x, y ) {
		this.getPosition();
		// get current x & y from top/left
		var curX = this.position.x;
		var curY = this.position.y;

		var compareX = parseInt( x, 10 );
		var compareY = parseInt( y, 10 );
		var didNotMove = compareX === this.position.x && compareY === this.position.y;

		// save end position
		this.setPosition( x, y );

		// if did not move and not transitioning, just go to layout
		if ( didNotMove && !this.isTransitioning ) {
			this.layoutPosition();
			return;
		}

		var transX = x - curX;
		var transY = y - curY;
		var transitionStyle = {};
		transitionStyle.transform = this.getTranslate( transX, transY );

		this.transition({
			to: transitionStyle,
			onTransitionEnd: {
				transform: this.layoutPosition
			},
			isCleaning: true
		});
	};

	Item.prototype.getTranslate = function( x, y ) {
		// flip cooridinates if origin on right or bottom
		var layoutOptions = this.layout.options;
		x = layoutOptions.isOriginLeft ? x : -x;
		y = layoutOptions.isOriginTop ? y : -y;

		if ( is3d ) {
			return 'translate3d(' + x + 'px, ' + y + 'px, 0)';
		}

		return 'translate(' + x + 'px, ' + y + 'px)';
	};

	// non transition + transform support
	Item.prototype.goTo = function( x, y ) {
		this.setPosition( x, y );
		this.layoutPosition();
	};

	// use transition and transforms if supported
	Item.prototype.moveTo = supportsCSS3 ?
		Item.prototype._transitionTo : Item.prototype.goTo;

	Item.prototype.setPosition = function( x, y ) {
		this.position.x = parseInt( x, 10 );
		this.position.y = parseInt( y, 10 );
	};

	// ----- transition ----- //

	/**
	 * @param {Object} style - CSS
	 * @param {Function} onTransitionEnd
	 */

	// non transition, just trigger callback
	Item.prototype._nonTransition = function( args ) {
		this.css( args.to );
		if ( args.isCleaning ) {
			this._removeStyles( args.to );
		}
		for ( var prop in args.onTransitionEnd ) {
			args.onTransitionEnd[ prop ].call( this );
		}
	};

	/**
	 * proper transition
	 * @param {Object} args - arguments
	 *   @param {Object} to - style to transition to
	 *   @param {Object} from - style to start transition from
	 *   @param {Boolean} isCleaning - removes transition styles after transition
	 *   @param {Function} onTransitionEnd - callback
	 */
	Item.prototype._transition = function( args ) {
		// redirect to nonTransition if no transition duration
		if ( !parseFloat( this.layout.options.transitionDuration ) ) {
			this._nonTransition( args );
			return;
		}

		var _transition = this._transn;
		// keep track of onTransitionEnd callback by css property
		for ( var prop in args.onTransitionEnd ) {
			_transition.onEnd[ prop ] = args.onTransitionEnd[ prop ];
		}
		// keep track of properties that are transitioning
		for ( prop in args.to ) {
			_transition.ingProperties[ prop ] = true;
			// keep track of properties to clean up when transition is done
			if ( args.isCleaning ) {
				_transition.clean[ prop ] = true;
			}
		}

		// set from styles
		if ( args.from ) {
			this.css( args.from );
			// force redraw. http://blog.alexmaccaw.com/css-transitions
			var h = this.element.offsetHeight;
			// hack for JSHint to hush about unused var
			h = null;
		}
		// enable transition
		this.enableTransition( args.to );
		// set styles that are transitioning
		this.css( args.to );

		this.isTransitioning = true;

	};

	// dash before all cap letters, including first for
	// WebkitTransform => -webkit-transform
	function toDashedAll( str ) {
		return str.replace( /([A-Z])/g, function( $1 ) {
			return '-' + $1.toLowerCase();
		});
	}

	var transitionProps = 'opacity,' +
		toDashedAll( vendorProperties.transform || 'transform' );

	Item.prototype.enableTransition = function(/* style */) {
		// HACK changing transitionProperty during a transition
		// will cause transition to jump
		if ( this.isTransitioning ) {
			return;
		}

		// make `transition: foo, bar, baz` from style object
		// HACK un-comment this when enableTransition can work
		// while a transition is happening
		// var transitionValues = [];
		// for ( var prop in style ) {
		//   // dash-ify camelCased properties like WebkitTransition
		//   prop = vendorProperties[ prop ] || prop;
		//   transitionValues.push( toDashedAll( prop ) );
		// }
		// enable transition styles
		this.css({
			transitionProperty: transitionProps,
			transitionDuration: this.layout.options.transitionDuration
		});
		// listen for transition end event
		this.element.addEventListener( transitionEndEvent, this, false );
	};

	Item.prototype.transition = Item.prototype[ transitionProperty ? '_transition' : '_nonTransition' ];

	// ----- events ----- //

	Item.prototype.onwebkitTransitionEnd = function( event ) {
		this.ontransitionend( event );
	};

	Item.prototype.onotransitionend = function( event ) {
		this.ontransitionend( event );
	};

	// properties that I munge to make my life easier
	var dashedVendorProperties = {
		'-webkit-transform': 'transform',
		'-moz-transform': 'transform',
		'-o-transform': 'transform'
	};

	Item.prototype.ontransitionend = function( event ) {
		// disregard bubbled events from children
		if ( event.target !== this.element ) {
			return;
		}
		var _transition = this._transn;
		// get property name of transitioned property, convert to prefix-free
		var propertyName = dashedVendorProperties[ event.propertyName ] || event.propertyName;

		// remove property that has completed transitioning
		delete _transition.ingProperties[ propertyName ];
		// check if any properties are still transitioning
		if ( isEmptyObj( _transition.ingProperties ) ) {
			// all properties have completed transitioning
			this.disableTransition();
		}
		// clean style
		if ( propertyName in _transition.clean ) {
			// clean up style
			this.element.style[ event.propertyName ] = '';
			delete _transition.clean[ propertyName ];
		}
		// trigger onTransitionEnd callback
		if ( propertyName in _transition.onEnd ) {
			var onTransitionEnd = _transition.onEnd[ propertyName ];
			onTransitionEnd.call( this );
			delete _transition.onEnd[ propertyName ];
		}

		this.emitEvent( 'transitionEnd', [ this ] );
	};

	Item.prototype.disableTransition = function() {
		this.removeTransitionStyles();
		this.element.removeEventListener( transitionEndEvent, this, false );
		this.isTransitioning = false;
	};

	/**
	 * removes style property from element
	 * @param {Object} style
	 **/
	Item.prototype._removeStyles = function( style ) {
		// clean up transition styles
		var cleanStyle = {};
		for ( var prop in style ) {
			cleanStyle[ prop ] = '';
		}
		this.css( cleanStyle );
	};

	var cleanTransitionStyle = {
		transitionProperty: '',
		transitionDuration: ''
	};

	Item.prototype.removeTransitionStyles = function() {
		// remove transition
		this.css( cleanTransitionStyle );
	};

	// ----- show/hide/remove ----- //

	// remove element from DOM
	Item.prototype.removeElem = function() {
		this.element.parentNode.removeChild( this.element );
		// remove display: none
		this.css({ display: '' });
		this.emitEvent( 'remove', [ this ] );
	};

	Item.prototype.remove = function() {
		// just remove element if no transition support or no transition
		if ( !transitionProperty || !parseFloat( this.layout.options.transitionDuration ) ) {
			this.removeElem();
			return;
		}

		// start transition
		var _this = this;
		this.once( 'transitionEnd', function() {
			_this.removeElem();
		});
		this.hide();
	};

	Item.prototype.reveal = function() {
		delete this.isHidden;
		// remove display: none
		this.css({ display: '' });

		var options = this.layout.options;

		var onTransitionEnd = {};
		var transitionEndProperty = this.getHideRevealTransitionEndProperty('visibleStyle');
		onTransitionEnd[ transitionEndProperty ] = this.onRevealTransitionEnd;

		this.transition({
			from: options.hiddenStyle,
			to: options.visibleStyle,
			isCleaning: true,
			onTransitionEnd: onTransitionEnd
		});
	};

	Item.prototype.onRevealTransitionEnd = function() {
		// check if still visible
		// during transition, item may have been hidden
		if ( !this.isHidden ) {
			this.emitEvent('reveal');
		}
	};

	/**
	 * get style property use for hide/reveal transition end
	 * @param {String} styleProperty - hiddenStyle/visibleStyle
	 * @returns {String}
	 */
	Item.prototype.getHideRevealTransitionEndProperty = function( styleProperty ) {
		var optionStyle = this.layout.options[ styleProperty ];
		// use opacity
		if ( optionStyle.opacity ) {
			return 'opacity';
		}
		// get first property
		for ( var prop in optionStyle ) {
			return prop;
		}
	};

	Item.prototype.hide = function() {
		// set flag
		this.isHidden = true;
		// remove display: none
		this.css({ display: '' });

		var options = this.layout.options;

		var onTransitionEnd = {};
		var transitionEndProperty = this.getHideRevealTransitionEndProperty('hiddenStyle');
		onTransitionEnd[ transitionEndProperty ] = this.onHideTransitionEnd;

		this.transition({
			from: options.visibleStyle,
			to: options.hiddenStyle,
			// keep hidden stuff hidden
			isCleaning: true,
			onTransitionEnd: onTransitionEnd
		});
	};

	Item.prototype.onHideTransitionEnd = function() {
		// check if still hidden
		// during transition, item may have been un-hidden
		if ( this.isHidden ) {
			this.css({ display: 'none' });
			this.emitEvent('hide');
		}
	};

	Item.prototype.destroy = function() {
		this.css({
			position: '',
			left: '',
			right: '',
			top: '',
			bottom: '',
			transition: '',
			transform: ''
		});
	};

	return Item;

}));

/*!
 * Outlayer v1.4.2
 * the brains and guts of a layout library
 * MIT license
 */

( function( window, factory ) {
	'use strict';
	// universal module definition

	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'outlayer/outlayer',[
				'eventie/eventie',
				'eventEmitter/EventEmitter',
				'get-size/get-size',
				'fizzy-ui-utils/utils',
				'./item'
			],
			function( eventie, EventEmitter, getSize, utils, Item ) {
				return factory( window, eventie, EventEmitter, getSize, utils, Item);
			}
		);
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			window,
			require('eventie'),
			require('wolfy87-eventemitter'),
			require('get-size'),
			require('fizzy-ui-utils'),
			require('./item')
		);
	} else {
		// browser global
		window.Outlayer = factory(
			window,
			window.eventie,
			window.EventEmitter,
			window.getSize,
			window.fizzyUIUtils,
			window.Outlayer.Item
		);
	}

}( window, function factory( window, eventie, EventEmitter, getSize, utils, Item ) {
	'use strict';

	// ----- vars ----- //

	var console = window.console;
	var jQuery = window.jQuery;
	var noop = function() {};

	// -------------------------- Outlayer -------------------------- //

	// globally unique identifiers
	var GUID = 0;
	// internal store of all Outlayer intances
	var instances = {};


	/**
	 * @param {Element, String} element
	 * @param {Object} options
	 * @constructor
	 */
	function Outlayer( element, options ) {
		var queryElement = utils.getQueryElement( element );
		if ( !queryElement ) {
			if ( console ) {
				console.error( 'Bad element for ' + this.constructor.namespace +
					': ' + ( queryElement || element ) );
			}
			return;
		}
		this.element = queryElement;
		// add jQuery
		if ( jQuery ) {
			this.$element = jQuery( this.element );
		}

		// options
		this.options = utils.extend( {}, this.constructor.defaults );
		this.option( options );

		// add id for Outlayer.getFromElement
		var id = ++GUID;
		this.element.outlayerGUID = id; // expando
		instances[ id ] = this; // associate via id

		// kick it off
		this._create();

		if ( this.options.isInitLayout ) {
			this.layout();
		}
	}

	// settings are for internal use only
	Outlayer.namespace = 'outlayer';
	Outlayer.Item = Item;

	// default options
	Outlayer.defaults = {
		containerStyle: {
			position: 'relative'
		},
		isInitLayout: true,
		isOriginLeft: true,
		isOriginTop: true,
		isResizeBound: true,
		isResizingContainer: true,
		// item options
		transitionDuration: '0.4s',
		hiddenStyle: {
			opacity: 0,
			transform: 'scale(0.001)'
		},
		visibleStyle: {
			opacity: 1,
			transform: 'scale(1)'
		}
	};

	// inherit EventEmitter
	utils.extend( Outlayer.prototype, EventEmitter.prototype );

	/**
	 * set options
	 * @param {Object} opts
	 */
	Outlayer.prototype.option = function( opts ) {
		utils.extend( this.options, opts );
	};

	Outlayer.prototype._create = function() {
		// get items from children
		this.reloadItems();
		// elements that affect layout, but are not laid out
		this.stamps = [];
		this.stamp( this.options.stamp );
		// set container style
		utils.extend( this.element.style, this.options.containerStyle );

		// bind resize method
		if ( this.options.isResizeBound ) {
			this.bindResize();
		}
	};

	// goes through all children again and gets bricks in proper order
	Outlayer.prototype.reloadItems = function() {
		// collection of item elements
		this.items = this._itemize( this.element.children );
	};


	/**
	 * turn elements into Outlayer.Items to be used in layout
	 * @param {Array or NodeList or HTMLElement} elems
	 * @returns {Array} items - collection of new Outlayer Items
	 */
	Outlayer.prototype._itemize = function( elems ) {

		var itemElems = this._filterFindItemElements( elems );
		var Item = this.constructor.Item;

		// create new Outlayer Items for collection
		var items = [];
		for ( var i=0, len = itemElems.length; i < len; i++ ) {
			var elem = itemElems[i];
			var item = new Item( elem, this );
			items.push( item );
		}

		return items;
	};

	/**
	 * get item elements to be used in layout
	 * @param {Array or NodeList or HTMLElement} elems
	 * @returns {Array} items - item elements
	 */
	Outlayer.prototype._filterFindItemElements = function( elems ) {
		return utils.filterFindElements( elems, this.options.itemSelector );
	};

	/**
	 * getter method for getting item elements
	 * @returns {Array} elems - collection of item elements
	 */
	Outlayer.prototype.getItemElements = function() {
		var elems = [];
		for ( var i=0, len = this.items.length; i < len; i++ ) {
			elems.push( this.items[i].element );
		}
		return elems;
	};

	// ----- init & layout ----- //

	/**
	 * lays out all items
	 */
	Outlayer.prototype.layout = function() {
		this._resetLayout();
		this._manageStamps();

		// don't animate first layout
		var isInstant = this.options.isLayoutInstant !== undefined ?
			this.options.isLayoutInstant : !this._isLayoutInited;
		this.layoutItems( this.items, isInstant );

		// flag for initalized
		this._isLayoutInited = true;
	};

	// _init is alias for layout
	Outlayer.prototype._init = Outlayer.prototype.layout;

	/**
	 * logic before any new layout
	 */
	Outlayer.prototype._resetLayout = function() {
		this.getSize();
	};


	Outlayer.prototype.getSize = function() {
		this.size = getSize( this.element );
	};

	/**
	 * get measurement from option, for columnWidth, rowHeight, gutter
	 * if option is String -> get element from selector string, & get size of element
	 * if option is Element -> get size of element
	 * else use option as a number
	 *
	 * @param {String} measurement
	 * @param {String} size - width or height
	 * @private
	 */
	Outlayer.prototype._getMeasurement = function( measurement, size ) {
		var option = this.options[ measurement ];
		var elem;
		if ( !option ) {
			// default to 0
			this[ measurement ] = 0;
		} else {
			// use option as an element
			if ( typeof option === 'string' ) {
				elem = this.element.querySelector( option );
			} else if ( utils.isElement( option ) ) {
				elem = option;
			}
			// use size of element, if element
			this[ measurement ] = elem ? getSize( elem )[ size ] : option;
		}
	};

	/**
	 * layout a collection of item elements
	 * @api public
	 */
	Outlayer.prototype.layoutItems = function( items, isInstant ) {
		items = this._getItemsForLayout( items );

		this._layoutItems( items, isInstant );

		this._postLayout();
	};

	/**
	 * get the items to be laid out
	 * you may want to skip over some items
	 * @param {Array} items
	 * @returns {Array} items
	 */
	Outlayer.prototype._getItemsForLayout = function( items ) {
		var layoutItems = [];
		for ( var i=0, len = items.length; i < len; i++ ) {
			var item = items[i];
			if ( !item.isIgnored ) {
				layoutItems.push( item );
			}
		}
		return layoutItems;
	};

	/**
	 * layout items
	 * @param {Array} items
	 * @param {Boolean} isInstant
	 */
	Outlayer.prototype._layoutItems = function( items, isInstant ) {
		this._emitCompleteOnItems( 'layout', items );

		if ( !items || !items.length ) {
			// no items, emit event with empty array
			return;
		}

		var queue = [];

		for ( var i=0, len = items.length; i < len; i++ ) {
			var item = items[i];
			// get x/y object from method
			var position = this._getItemLayoutPosition( item );
			// enqueue
			position.item = item;
			position.isInstant = isInstant || item.isLayoutInstant;
			queue.push( position );
		}

		this._processLayoutQueue( queue );
	};

	/**
	 * get item layout position
	 * @param {Outlayer.Item} item
	 * @returns {Object} x and y position
	 */
	Outlayer.prototype._getItemLayoutPosition = function( /* item */ ) {
		return {
			x: 0,
			y: 0
		};
	};

	/**
	 * iterate over array and position each item
	 * Reason being - separating this logic prevents 'layout invalidation'
	 * thx @paul_irish
	 * @param {Array} queue
	 */
	Outlayer.prototype._processLayoutQueue = function( queue ) {
		for ( var i=0, len = queue.length; i < len; i++ ) {
			var obj = queue[i];
			this._positionItem( obj.item, obj.x, obj.y, obj.isInstant );
		}
	};

	/**
	 * Sets position of item in DOM
	 * @param {Outlayer.Item} item
	 * @param {Number} x - horizontal position
	 * @param {Number} y - vertical position
	 * @param {Boolean} isInstant - disables transitions
	 */
	Outlayer.prototype._positionItem = function( item, x, y, isInstant ) {
		if ( isInstant ) {
			// if not transition, just set CSS
			item.goTo( x, y );
		} else {
			item.moveTo( x, y );
		}
	};

	/**
	 * Any logic you want to do after each layout,
	 * i.e. size the container
	 */
	Outlayer.prototype._postLayout = function() {
		this.resizeContainer();
	};

	Outlayer.prototype.resizeContainer = function() {
		if ( !this.options.isResizingContainer ) {
			return;
		}
		var size = this._getContainerSize();
		if ( size ) {
			this._setContainerMeasure( size.width, true );
			this._setContainerMeasure( size.height, false );
		}
	};

	/**
	 * Sets width or height of container if returned
	 * @returns {Object} size
	 *   @param {Number} width
	 *   @param {Number} height
	 */
	Outlayer.prototype._getContainerSize = noop;

	/**
	 * @param {Number} measure - size of width or height
	 * @param {Boolean} isWidth
	 */
	Outlayer.prototype._setContainerMeasure = function( measure, isWidth ) {
		if ( measure === undefined ) {
			return;
		}

		var elemSize = this.size;
		// add padding and border width if border box
		if ( elemSize.isBorderBox ) {
			measure += isWidth ? elemSize.paddingLeft + elemSize.paddingRight +
				elemSize.borderLeftWidth + elemSize.borderRightWidth :
				elemSize.paddingBottom + elemSize.paddingTop +
				elemSize.borderTopWidth + elemSize.borderBottomWidth;
		}

		measure = Math.max( measure, 0 );
		this.element.style[ isWidth ? 'width' : 'height' ] = measure + 'px';
	};

	/**
	 * emit eventComplete on a collection of items events
	 * @param {String} eventName
	 * @param {Array} items - Outlayer.Items
	 */
	Outlayer.prototype._emitCompleteOnItems = function( eventName, items ) {
		var _this = this;
		function onComplete() {
			_this.dispatchEvent( eventName + 'Complete', null, [ items ] );
		}

		var count = items.length;
		if ( !items || !count ) {
			onComplete();
			return;
		}

		var doneCount = 0;
		function tick() {
			doneCount++;
			if ( doneCount === count ) {
				onComplete();
			}
		}

		// bind callback
		for ( var i=0, len = items.length; i < len; i++ ) {
			var item = items[i];
			item.once( eventName, tick );
		}
	};

	/**
	 * emits events via eventEmitter and jQuery events
	 * @param {String} type - name of event
	 * @param {Event} event - original event
	 * @param {Array} args - extra arguments
	 */
	Outlayer.prototype.dispatchEvent = function( type, event, args ) {
		// add original event to arguments
		var emitArgs = event ? [ event ].concat( args ) : args;
		this.emitEvent( type, emitArgs );

		if ( jQuery ) {
			// set this.$element
			this.$element = this.$element || jQuery( this.element );
			if ( event ) {
				// create jQuery event
				var $event = jQuery.Event( event );
				$event.type = type;
				this.$element.trigger( $event, args );
			} else {
				// just trigger with type if no event available
				this.$element.trigger( type, args );
			}
		}
	};

	// -------------------------- ignore & stamps -------------------------- //


	/**
	 * keep item in collection, but do not lay it out
	 * ignored items do not get skipped in layout
	 * @param {Element} elem
	 */
	Outlayer.prototype.ignore = function( elem ) {
		var item = this.getItem( elem );
		if ( item ) {
			item.isIgnored = true;
		}
	};

	/**
	 * return item to layout collection
	 * @param {Element} elem
	 */
	Outlayer.prototype.unignore = function( elem ) {
		var item = this.getItem( elem );
		if ( item ) {
			delete item.isIgnored;
		}
	};

	/**
	 * adds elements to stamps
	 * @param {NodeList, Array, Element, or String} elems
	 */
	Outlayer.prototype.stamp = function( elems ) {
		elems = this._find( elems );
		if ( !elems ) {
			return;
		}

		this.stamps = this.stamps.concat( elems );
		// ignore
		for ( var i=0, len = elems.length; i < len; i++ ) {
			var elem = elems[i];
			this.ignore( elem );
		}
	};

	/**
	 * removes elements to stamps
	 * @param {NodeList, Array, or Element} elems
	 */
	Outlayer.prototype.unstamp = function( elems ) {
		elems = this._find( elems );
		if ( !elems ){
			return;
		}

		for ( var i=0, len = elems.length; i < len; i++ ) {
			var elem = elems[i];
			// filter out removed stamp elements
			utils.removeFrom( this.stamps, elem );
			this.unignore( elem );
		}

	};

	/**
	 * finds child elements
	 * @param {NodeList, Array, Element, or String} elems
	 * @returns {Array} elems
	 */
	Outlayer.prototype._find = function( elems ) {
		if ( !elems ) {
			return;
		}
		// if string, use argument as selector string
		if ( typeof elems === 'string' ) {
			elems = this.element.querySelectorAll( elems );
		}
		elems = utils.makeArray( elems );
		return elems;
	};

	Outlayer.prototype._manageStamps = function() {
		if ( !this.stamps || !this.stamps.length ) {
			return;
		}

		this._getBoundingRect();

		for ( var i=0, len = this.stamps.length; i < len; i++ ) {
			var stamp = this.stamps[i];
			this._manageStamp( stamp );
		}
	};

	// update boundingLeft / Top
	Outlayer.prototype._getBoundingRect = function() {
		// get bounding rect for container element
		var boundingRect = this.element.getBoundingClientRect();
		var size = this.size;
		this._boundingRect = {
			left: boundingRect.left + size.paddingLeft + size.borderLeftWidth,
			top: boundingRect.top + size.paddingTop + size.borderTopWidth,
			right: boundingRect.right - ( size.paddingRight + size.borderRightWidth ),
			bottom: boundingRect.bottom - ( size.paddingBottom + size.borderBottomWidth )
		};
	};

	/**
	 * @param {Element} stamp
	 **/
	Outlayer.prototype._manageStamp = noop;

	/**
	 * get x/y position of element relative to container element
	 * @param {Element} elem
	 * @returns {Object} offset - has left, top, right, bottom
	 */
	Outlayer.prototype._getElementOffset = function( elem ) {
		var boundingRect = elem.getBoundingClientRect();
		var thisRect = this._boundingRect;
		var size = getSize( elem );
		var offset = {
			left: boundingRect.left - thisRect.left - size.marginLeft,
			top: boundingRect.top - thisRect.top - size.marginTop,
			right: thisRect.right - boundingRect.right - size.marginRight,
			bottom: thisRect.bottom - boundingRect.bottom - size.marginBottom
		};
		return offset;
	};

	// -------------------------- resize -------------------------- //

	// enable event handlers for listeners
	// i.e. resize -> onresize
	Outlayer.prototype.handleEvent = function( event ) {
		var method = 'on' + event.type;
		if ( this[ method ] ) {
			this[ method ]( event );
		}
	};

	/**
	 * Bind layout to window resizing
	 */
	Outlayer.prototype.bindResize = function() {
		// bind just one listener
		if ( this.isResizeBound ) {
			return;
		}
		eventie.bind( window, 'resize', this );
		this.isResizeBound = true;
	};

	/**
	 * Unbind layout to window resizing
	 */
	Outlayer.prototype.unbindResize = function() {
		if ( this.isResizeBound ) {
			eventie.unbind( window, 'resize', this );
		}
		this.isResizeBound = false;
	};

	// original debounce by John Hann
	// http://unscriptable.com/index.php/2009/03/20/debouncing-javascript-methods/

	// this fires every resize
	Outlayer.prototype.onresize = function() {
		if ( this.resizeTimeout ) {
			clearTimeout( this.resizeTimeout );
		}

		var _this = this;
		function delayed() {
			_this.resize();
			delete _this.resizeTimeout;
		}

		this.resizeTimeout = setTimeout( delayed, 100 );
	};

	// debounced, layout on resize
	Outlayer.prototype.resize = function() {
		// don't trigger if size did not change
		// or if resize was unbound. See #9
		if ( !this.isResizeBound || !this.needsResizeLayout() ) {
			return;
		}

		this.layout();
	};

	/**
	 * check if layout is needed post layout
	 * @returns Boolean
	 */
	Outlayer.prototype.needsResizeLayout = function() {
		var size = getSize( this.element );
		// check that this.size and size are there
		// IE8 triggers resize on body size change, so they might not be
		var hasSizes = this.size && size;
		return hasSizes && size.innerWidth !== this.size.innerWidth;
	};

	// -------------------------- methods -------------------------- //

	/**
	 * add items to Outlayer instance
	 * @param {Array or NodeList or Element} elems
	 * @returns {Array} items - Outlayer.Items
	 **/
	Outlayer.prototype.addItems = function( elems ) {
		var items = this._itemize( elems );
		// add items to collection
		if ( items.length ) {
			this.items = this.items.concat( items );
		}
		return items;
	};

	/**
	 * Layout newly-appended item elements
	 * @param {Array or NodeList or Element} elems
	 */
	Outlayer.prototype.appended = function( elems ) {
		var items = this.addItems( elems );
		if ( !items.length ) {
			return;
		}
		// layout and reveal just the new items
		this.layoutItems( items, true );
		this.reveal( items );
	};

	/**
	 * Layout prepended elements
	 * @param {Array or NodeList or Element} elems
	 */
	Outlayer.prototype.prepended = function( elems ) {
		var items = this._itemize( elems );
		if ( !items.length ) {
			return;
		}
		// add items to beginning of collection
		var previousItems = this.items.slice(0);
		this.items = items.concat( previousItems );
		// start new layout
		this._resetLayout();
		this._manageStamps();
		// layout new stuff without transition
		this.layoutItems( items, true );
		this.reveal( items );
		// layout previous items
		this.layoutItems( previousItems );
	};

	/**
	 * reveal a collection of items
	 * @param {Array of Outlayer.Items} items
	 */
	Outlayer.prototype.reveal = function( items ) {
		this._emitCompleteOnItems( 'reveal', items );

		var len = items && items.length;
		for ( var i=0; len && i < len; i++ ) {
			var item = items[i];
			item.reveal();
		}
	};

	/**
	 * hide a collection of items
	 * @param {Array of Outlayer.Items} items
	 */
	Outlayer.prototype.hide = function( items ) {
		this._emitCompleteOnItems( 'hide', items );

		var len = items && items.length;
		for ( var i=0; len && i < len; i++ ) {
			var item = items[i];
			item.hide();
		}
	};

	/**
	 * reveal item elements
	 * @param {Array}, {Element}, {NodeList} items
	 */
	Outlayer.prototype.revealItemElements = function( elems ) {
		var items = this.getItems( elems );
		this.reveal( items );
	};

	/**
	 * hide item elements
	 * @param {Array}, {Element}, {NodeList} items
	 */
	Outlayer.prototype.hideItemElements = function( elems ) {
		var items = this.getItems( elems );
		this.hide( items );
	};

	/**
	 * get Outlayer.Item, given an Element
	 * @param {Element} elem
	 * @param {Function} callback
	 * @returns {Outlayer.Item} item
	 */
	Outlayer.prototype.getItem = function( elem ) {
		// loop through items to get the one that matches
		for ( var i=0, len = this.items.length; i < len; i++ ) {
			var item = this.items[i];
			if ( item.element === elem ) {
				// return item
				return item;
			}
		}
	};

	/**
	 * get collection of Outlayer.Items, given Elements
	 * @param {Array} elems
	 * @returns {Array} items - Outlayer.Items
	 */
	Outlayer.prototype.getItems = function( elems ) {
		elems = utils.makeArray( elems );
		var items = [];
		for ( var i=0, len = elems.length; i < len; i++ ) {
			var elem = elems[i];
			var item = this.getItem( elem );
			if ( item ) {
				items.push( item );
			}
		}

		return items;
	};

	/**
	 * remove element(s) from instance and DOM
	 * @param {Array or NodeList or Element} elems
	 */
	Outlayer.prototype.remove = function( elems ) {
		var removeItems = this.getItems( elems );

		this._emitCompleteOnItems( 'remove', removeItems );

		// bail if no items to remove
		if ( !removeItems || !removeItems.length ) {
			return;
		}

		for ( var i=0, len = removeItems.length; i < len; i++ ) {
			var item = removeItems[i];
			item.remove();
			// remove item from collection
			utils.removeFrom( this.items, item );
		}
	};

	// ----- destroy ----- //

	// remove and disable Outlayer instance
	Outlayer.prototype.destroy = function() {
		// clean up dynamic styles
		var style = this.element.style;
		style.height = '';
		style.position = '';
		style.width = '';
		// destroy items
		for ( var i=0, len = this.items.length; i < len; i++ ) {
			var item = this.items[i];
			item.destroy();
		}

		this.unbindResize();

		var id = this.element.outlayerGUID;
		delete instances[ id ]; // remove reference to instance by id
		delete this.element.outlayerGUID;
		// remove data for jQuery
		if ( jQuery ) {
			jQuery.removeData( this.element, this.constructor.namespace );
		}

	};

	// -------------------------- data -------------------------- //

	/**
	 * get Outlayer instance from element
	 * @param {Element} elem
	 * @returns {Outlayer}
	 */
	Outlayer.data = function( elem ) {
		elem = utils.getQueryElement( elem );
		var id = elem && elem.outlayerGUID;
		return id && instances[ id ];
	};


	// -------------------------- create Outlayer class -------------------------- //

	/**
	 * create a layout class
	 * @param {String} namespace
	 */
	Outlayer.create = function( namespace, options ) {
		// sub-class Outlayer
		function Layout() {
			Outlayer.apply( this, arguments );
		}
		// inherit Outlayer prototype, use Object.create if there
		if ( Object.create ) {
			Layout.prototype = Object.create( Outlayer.prototype );
		} else {
			utils.extend( Layout.prototype, Outlayer.prototype );
		}
		// set contructor, used for namespace and Item
		Layout.prototype.constructor = Layout;

		Layout.defaults = utils.extend( {}, Outlayer.defaults );
		// apply new options
		utils.extend( Layout.defaults, options );
		// keep prototype.settings for backwards compatibility (Packery v1.2.0)
		Layout.prototype.settings = {};

		Layout.namespace = namespace;

		Layout.data = Outlayer.data;

		// sub-class Item
		Layout.Item = function LayoutItem() {
			Item.apply( this, arguments );
		};

		Layout.Item.prototype = new Item();

		// -------------------------- declarative -------------------------- //

		utils.htmlInit( Layout, namespace );

		// -------------------------- jQuery bridge -------------------------- //

		// make into jQuery plugin
		if ( jQuery && jQuery.bridget ) {
			jQuery.bridget( namespace, Layout );
		}

		return Layout;
	};

	// ----- fin ----- //

	// back in global
	Outlayer.Item = Item;

	return Outlayer;

}));


/**
 * Isotope Item
 **/

( function( window, factory ) {
	'use strict';
	// universal module definition
	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'isotope/js/item',[
				'outlayer/outlayer'
			],
			factory );
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			require('outlayer')
		);
	} else {
		// browser global
		window.Isotope = window.Isotope || {};
		window.Isotope.Item = factory(
			window.Outlayer
		);
	}

}( window, function factory( Outlayer ) {
	'use strict';

	// -------------------------- Item -------------------------- //

	// sub-class Outlayer Item
	function Item() {
		Outlayer.Item.apply( this, arguments );
	}

	Item.prototype = new Outlayer.Item();

	Item.prototype._create = function() {
		// assign id, used for original-order sorting
		this.id = this.layout.itemGUID++;
		Outlayer.Item.prototype._create.call( this );
		this.sortData = {};
	};

	Item.prototype.updateSortData = function() {
		if ( this.isIgnored ) {
			return;
		}
		// default sorters
		this.sortData.id = this.id;
		// for backward compatibility
		this.sortData['original-order'] = this.id;
		this.sortData.random = Math.random();
		// go thru getSortData obj and apply the sorters
		var getSortData = this.layout.options.getSortData;
		var sorters = this.layout._sorters;
		for ( var key in getSortData ) {
			var sorter = sorters[ key ];
			this.sortData[ key ] = sorter( this.element, this );
		}
	};

	var _destroy = Item.prototype.destroy;
	Item.prototype.destroy = function() {
		// call super
		_destroy.apply( this, arguments );
		// reset display, #741
		this.css({
			display: ''
		});
	};

	return Item;

}));

/**
 * Isotope LayoutMode
 */

( function( window, factory ) {
	'use strict';
	// universal module definition

	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'isotope/js/layout-mode',[
				'get-size/get-size',
				'outlayer/outlayer'
			],
			factory );
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			require('get-size'),
			require('outlayer')
		);
	} else {
		// browser global
		window.Isotope = window.Isotope || {};
		window.Isotope.LayoutMode = factory(
			window.getSize,
			window.Outlayer
		);
	}

}( window, function factory( getSize, Outlayer ) {
	'use strict';

	// layout mode class
	function LayoutMode( isotope ) {
		this.isotope = isotope;
		// link properties
		if ( isotope ) {
			this.options = isotope.options[ this.namespace ];
			this.element = isotope.element;
			this.items = isotope.filteredItems;
			this.size = isotope.size;
		}
	}

	/**
	 * some methods should just defer to default Outlayer method
	 * and reference the Isotope instance as `this`
	 **/
	( function() {
		var facadeMethods = [
			'_resetLayout',
			'_getItemLayoutPosition',
			'_manageStamp',
			'_getContainerSize',
			'_getElementOffset',
			'needsResizeLayout'
		];

		for ( var i=0, len = facadeMethods.length; i < len; i++ ) {
			var methodName = facadeMethods[i];
			LayoutMode.prototype[ methodName ] = getOutlayerMethod( methodName );
		}

		function getOutlayerMethod( methodName ) {
			return function() {
				return Outlayer.prototype[ methodName ].apply( this.isotope, arguments );
			};
		}
	})();

	// -----  ----- //

	// for horizontal layout modes, check vertical size
	LayoutMode.prototype.needsVerticalResizeLayout = function() {
		// don't trigger if size did not change
		var size = getSize( this.isotope.element );
		// check that this.size and size are there
		// IE8 triggers resize on body size change, so they might not be
		var hasSizes = this.isotope.size && size;
		return hasSizes && size.innerHeight != this.isotope.size.innerHeight;
	};

	// ----- measurements ----- //

	LayoutMode.prototype._getMeasurement = function() {
		this.isotope._getMeasurement.apply( this, arguments );
	};

	LayoutMode.prototype.getColumnWidth = function() {
		this.getSegmentSize( 'column', 'Width' );
	};

	LayoutMode.prototype.getRowHeight = function() {
		this.getSegmentSize( 'row', 'Height' );
	};

	/**
	 * get columnWidth or rowHeight
	 * segment: 'column' or 'row'
	 * size 'Width' or 'Height'
	 **/
	LayoutMode.prototype.getSegmentSize = function( segment, size ) {
		var segmentName = segment + size;
		var outerSize = 'outer' + size;
		// columnWidth / outerWidth // rowHeight / outerHeight
		this._getMeasurement( segmentName, outerSize );
		// got rowHeight or columnWidth, we can chill
		if ( this[ segmentName ] ) {
			return;
		}
		// fall back to item of first element
		var firstItemSize = this.getFirstItemSize();
		this[ segmentName ] = firstItemSize && firstItemSize[ outerSize ] ||
			// or size of container
			this.isotope.size[ 'inner' + size ];
	};

	LayoutMode.prototype.getFirstItemSize = function() {
		var firstItem = this.isotope.filteredItems[0];
		return firstItem && firstItem.element && getSize( firstItem.element );
	};

	// ----- methods that should reference isotope ----- //

	LayoutMode.prototype.layout = function() {
		this.isotope.layout.apply( this.isotope, arguments );
	};

	LayoutMode.prototype.getSize = function() {
		this.isotope.getSize();
		this.size = this.isotope.size;
	};

	// -------------------------- create -------------------------- //

	LayoutMode.modes = {};

	LayoutMode.create = function( namespace, options ) {

		function Mode() {
			LayoutMode.apply( this, arguments );
		}

		Mode.prototype = new LayoutMode();

		// default options
		if ( options ) {
			Mode.options = options;
		}

		Mode.prototype.namespace = namespace;
		// register in Isotope
		LayoutMode.modes[ namespace ] = Mode;

		return Mode;
	};

	return LayoutMode;

}));

/*!
 * Masonry v3.3.1
 * Cascading grid layout library
 * http://masonry.desandro.com
 * MIT License
 * by David DeSandro
 */

( function( window, factory ) {
	'use strict';
	// universal module definition
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( 'masonry/masonry',[
				'outlayer/outlayer',
				'get-size/get-size',
				'fizzy-ui-utils/utils'
			],
			factory );
	} else if ( typeof exports === 'object' ) {
		// CommonJS
		module.exports = factory(
			require('outlayer'),
			require('get-size'),
			require('fizzy-ui-utils')
		);
	} else {
		// browser global
		window.Masonry = factory(
			window.Outlayer,
			window.getSize,
			window.fizzyUIUtils
		);
	}

}( window, function factory( Outlayer, getSize, utils ) {



	// -------------------------- masonryDefinition -------------------------- //

	// create an Outlayer layout class
	var Masonry = Outlayer.create('masonry');

	Masonry.prototype._resetLayout = function() {
		this.getSize();
		this._getMeasurement( 'columnWidth', 'outerWidth' );
		this._getMeasurement( 'gutter', 'outerWidth' );
		this.measureColumns();

		// reset column Y
		var i = this.cols;
		this.colYs = [];
		while (i--) {
			this.colYs.push( 0 );
		}

		this.maxY = 0;
	};

	Masonry.prototype.measureColumns = function() {
		this.getContainerWidth();
		// if columnWidth is 0, default to outerWidth of first item
		if ( !this.columnWidth ) {
			var firstItem = this.items[0];
			var firstItemElem = firstItem && firstItem.element;
			// columnWidth fall back to item of first element
			this.columnWidth = firstItemElem && getSize( firstItemElem ).outerWidth ||
				// if first elem has no width, default to size of container
				this.containerWidth;
		}

		var columnWidth = this.columnWidth += this.gutter;

		// calculate columns
		var containerWidth = this.containerWidth + this.gutter;
		var cols = containerWidth / columnWidth;
		// fix rounding errors, typically with gutters
		var excess = columnWidth - containerWidth % columnWidth;
		// if overshoot is less than a pixel, round up, otherwise floor it
		var mathMethod = excess && excess < 1 ? 'round' : 'floor';
		cols = Math[ mathMethod ]( cols );
		this.cols = Math.max( cols, 1 );
	};

	Masonry.prototype.getContainerWidth = function() {
		// container is parent if fit width
		var container = this.options.isFitWidth ? this.element.parentNode : this.element;
		// check that this.size and size are there
		// IE8 triggers resize on body size change, so they might not be
		var size = getSize( container );
		this.containerWidth = size && size.innerWidth;
	};

	Masonry.prototype._getItemLayoutPosition = function( item ) {
		item.getSize();
		// how many columns does this brick span
		var remainder = item.size.outerWidth % this.columnWidth;
		var mathMethod = remainder && remainder < 1 ? 'round' : 'ceil';
		// round if off by 1 pixel, otherwise use ceil
		var colSpan = Math[ mathMethod ]( item.size.outerWidth / this.columnWidth );
		colSpan = Math.min( colSpan, this.cols );

		var colGroup = this._getColGroup( colSpan );
		// get the minimum Y value from the columns
		var minimumY = Math.min.apply( Math, colGroup );
		var shortColIndex = utils.indexOf( colGroup, minimumY );

		// position the brick
		var position = {
			x: this.columnWidth * shortColIndex,
			y: minimumY
		};

		// apply setHeight to necessary columns
		var setHeight = minimumY + item.size.outerHeight;
		var setSpan = this.cols + 1 - colGroup.length;
		for ( var i = 0; i < setSpan; i++ ) {
			this.colYs[ shortColIndex + i ] = setHeight;
		}

		return position;
	};

	/**
	 * @param {Number} colSpan - number of columns the element spans
	 * @returns {Array} colGroup
	 */
	Masonry.prototype._getColGroup = function( colSpan ) {
		if ( colSpan < 2 ) {
			// if brick spans only one column, use all the column Ys
			return this.colYs;
		}

		var colGroup = [];
		// how many different places could this brick fit horizontally
		var groupCount = this.cols + 1 - colSpan;
		// for each group potential horizontal position
		for ( var i = 0; i < groupCount; i++ ) {
			// make an array of colY values for that one group
			var groupColYs = this.colYs.slice( i, i + colSpan );
			// and get the max value of the array
			colGroup[i] = Math.max.apply( Math, groupColYs );
		}
		return colGroup;
	};

	Masonry.prototype._manageStamp = function( stamp ) {
		var stampSize = getSize( stamp );
		var offset = this._getElementOffset( stamp );
		// get the columns that this stamp affects
		var firstX = this.options.isOriginLeft ? offset.left : offset.right;
		var lastX = firstX + stampSize.outerWidth;
		var firstCol = Math.floor( firstX / this.columnWidth );
		firstCol = Math.max( 0, firstCol );
		var lastCol = Math.floor( lastX / this.columnWidth );
		// lastCol should not go over if multiple of columnWidth #425
		lastCol -= lastX % this.columnWidth ? 0 : 1;
		lastCol = Math.min( this.cols - 1, lastCol );
		// set colYs to bottom of the stamp
		var stampMaxY = ( this.options.isOriginTop ? offset.top : offset.bottom ) +
			stampSize.outerHeight;
		for ( var i = firstCol; i <= lastCol; i++ ) {
			this.colYs[i] = Math.max( stampMaxY, this.colYs[i] );
		}
	};

	Masonry.prototype._getContainerSize = function() {
		this.maxY = Math.max.apply( Math, this.colYs );
		var size = {
			height: this.maxY
		};

		if ( this.options.isFitWidth ) {
			size.width = this._getContainerFitWidth();
		}

		return size;
	};

	Masonry.prototype._getContainerFitWidth = function() {
		var unusedCols = 0;
		// count unused columns
		var i = this.cols;
		while ( --i ) {
			if ( this.colYs[i] !== 0 ) {
				break;
			}
			unusedCols++;
		}
		// fit container to columns that have been used
		return ( this.cols - unusedCols ) * this.columnWidth - this.gutter;
	};

	Masonry.prototype.needsResizeLayout = function() {
		var previousWidth = this.containerWidth;
		this.getContainerWidth();
		return previousWidth !== this.containerWidth;
	};

	return Masonry;

}));

/*!
 * Masonry layout mode
 * sub-classes Masonry
 * http://masonry.desandro.com
 */

( function( window, factory ) {
	'use strict';
	// universal module definition
	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'isotope/js/layout-modes/masonry',[
				'../layout-mode',
				'masonry/masonry'
			],
			factory );
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			require('../layout-mode'),
			require('masonry-layout')
		);
	} else {
		// browser global
		factory(
			window.Isotope.LayoutMode,
			window.Masonry
		);
	}

}( window, function factory( LayoutMode, Masonry ) {
	'use strict';

	// -------------------------- helpers -------------------------- //

	// extend objects
	function extend( a, b ) {
		for ( var prop in b ) {
			a[ prop ] = b[ prop ];
		}
		return a;
	}

	// -------------------------- masonryDefinition -------------------------- //

	// create an Outlayer layout class
	var MasonryMode = LayoutMode.create('masonry');

	// save on to these methods
	var _getElementOffset = MasonryMode.prototype._getElementOffset;
	var layout = MasonryMode.prototype.layout;
	var _getMeasurement = MasonryMode.prototype._getMeasurement;

	// sub-class Masonry
	extend( MasonryMode.prototype, Masonry.prototype );

	// set back, as it was overwritten by Masonry
	MasonryMode.prototype._getElementOffset = _getElementOffset;
	MasonryMode.prototype.layout = layout;
	MasonryMode.prototype._getMeasurement = _getMeasurement;

	var measureColumns = MasonryMode.prototype.measureColumns;
	MasonryMode.prototype.measureColumns = function() {
		// set items, used if measuring first item
		this.items = this.isotope.filteredItems;
		measureColumns.call( this );
	};

	// HACK copy over isOriginLeft/Top options
	var _manageStamp = MasonryMode.prototype._manageStamp;
	MasonryMode.prototype._manageStamp = function() {
		this.options.isOriginLeft = this.isotope.options.isOriginLeft;
		this.options.isOriginTop = this.isotope.options.isOriginTop;
		_manageStamp.apply( this, arguments );
	};

	return MasonryMode;

}));

/**
 * fitRows layout mode
 */

( function( window, factory ) {
	'use strict';
	// universal module definition
	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'isotope/js/layout-modes/fit-rows',[
				'../layout-mode'
			],
			factory );
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			require('../layout-mode')
		);
	} else {
		// browser global
		factory(
			window.Isotope.LayoutMode
		);
	}

}( window, function factory( LayoutMode ) {
	'use strict';

	var FitRows = LayoutMode.create('fitRows');

	FitRows.prototype._resetLayout = function() {
		this.x = 0;
		this.y = 0;
		this.maxY = 0;
		this._getMeasurement( 'gutter', 'outerWidth' );
	};

	FitRows.prototype._getItemLayoutPosition = function( item ) {
		item.getSize();

		var itemWidth = item.size.outerWidth + this.gutter;
		// if this element cannot fit in the current row
		var containerWidth = this.isotope.size.innerWidth + this.gutter;
		if ( this.x !== 0 && itemWidth + this.x > containerWidth ) {
			this.x = 0;
			this.y = this.maxY;
		}

		var position = {
			x: this.x,
			y: this.y
		};

		this.maxY = Math.max( this.maxY, this.y + item.size.outerHeight );
		this.x += itemWidth;

		return position;
	};

	FitRows.prototype._getContainerSize = function() {
		return { height: this.maxY };
	};

	return FitRows;

}));

/**
 * vertical layout mode
 */

( function( window, factory ) {
	'use strict';
	// universal module definition
	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( 'isotope/js/layout-modes/vertical',[
				'../layout-mode'
			],
			factory );
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			require('../layout-mode')
		);
	} else {
		// browser global
		factory(
			window.Isotope.LayoutMode
		);
	}

}( window, function factory( LayoutMode ) {
	'use strict';

	var Vertical = LayoutMode.create( 'vertical', {
		horizontalAlignment: 0
	});

	Vertical.prototype._resetLayout = function() {
		this.y = 0;
	};

	Vertical.prototype._getItemLayoutPosition = function( item ) {
		item.getSize();
		var x = ( this.isotope.size.innerWidth - item.size.outerWidth ) *
			this.options.horizontalAlignment;
		var y = this.y;
		this.y += item.size.outerHeight;
		return { x: x, y: y };
	};

	Vertical.prototype._getContainerSize = function() {
		return { height: this.y };
	};

	return Vertical;

}));

/*!
 * Isotope v2.2.2
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * http://isotope.metafizzy.co
 * Copyright 2015 Metafizzy
 */

( function( window, factory ) {
	'use strict';
	// universal module definition

	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define( [
				'outlayer/outlayer',
				'get-size/get-size',
				'matches-selector/matches-selector',
				'fizzy-ui-utils/utils',
				'isotope/js/item',
				'isotope/js/layout-mode',
				// include default layout modes
				'isotope/js/layout-modes/masonry',
				'isotope/js/layout-modes/fit-rows',
				'isotope/js/layout-modes/vertical'
			],
			function( Outlayer, getSize, matchesSelector, utils, Item, LayoutMode ) {
				return factory( window, Outlayer, getSize, matchesSelector, utils, Item, LayoutMode );
			});
	} else if ( typeof exports == 'object' ) {
		// CommonJS
		module.exports = factory(
			window,
			require('outlayer'),
			require('get-size'),
			require('desandro-matches-selector'),
			require('fizzy-ui-utils'),
			require('./item'),
			require('./layout-mode'),
			// include default layout modes
			require('./layout-modes/masonry'),
			require('./layout-modes/fit-rows'),
			require('./layout-modes/vertical')
		);
	} else {
		// browser global
		window.Isotope = factory(
			window,
			window.Outlayer,
			window.getSize,
			window.matchesSelector,
			window.fizzyUIUtils,
			window.Isotope.Item,
			window.Isotope.LayoutMode
		);
	}

}( window, function factory( window, Outlayer, getSize, matchesSelector, utils,
	Item, LayoutMode ) {



	// -------------------------- vars -------------------------- //

	var jQuery = window.jQuery;

	// -------------------------- helpers -------------------------- //

	var trim = String.prototype.trim ?
		function( str ) {
			return str.trim();
		} :
		function( str ) {
			return str.replace( /^\s+|\s+$/g, '' );
		};

	var docElem = document.documentElement;

	var getText = docElem.textContent ?
		function( elem ) {
			return elem.textContent;
		} :
		function( elem ) {
			return elem.innerText;
		};

	// -------------------------- isotopeDefinition -------------------------- //

	// create an Outlayer layout class
	var Isotope = Outlayer.create( 'isotope', {
		layoutMode: "masonry",
		isJQueryFiltering: true,
		sortAscending: true
	});

	Isotope.Item = Item;
	Isotope.LayoutMode = LayoutMode;

	Isotope.prototype._create = function() {
		this.itemGUID = 0;
		// functions that sort items
		this._sorters = {};
		this._getSorters();
		// call super
		Outlayer.prototype._create.call( this );

		// create layout modes
		this.modes = {};
		// start filteredItems with all items
		this.filteredItems = this.items;
		// keep of track of sortBys
		this.sortHistory = [ 'original-order' ];
		// create from registered layout modes
		for ( var name in LayoutMode.modes ) {
			this._initLayoutMode( name );
		}
	};

	Isotope.prototype.reloadItems = function() {
		// reset item ID counter
		this.itemGUID = 0;
		// call super
		Outlayer.prototype.reloadItems.call( this );
	};

	Isotope.prototype._itemize = function() {
		var items = Outlayer.prototype._itemize.apply( this, arguments );
		// assign ID for original-order
		for ( var i=0, len = items.length; i < len; i++ ) {
			var item = items[i];
			item.id = this.itemGUID++;
		}
		this._updateItemsSortData( items );
		return items;
	};


	// -------------------------- layout -------------------------- //

	Isotope.prototype._initLayoutMode = function( name ) {
		var Mode = LayoutMode.modes[ name ];
		// set mode options
		// HACK extend initial options, back-fill in default options
		var initialOpts = this.options[ name ] || {};
		this.options[ name ] = Mode.options ?
			utils.extend( Mode.options, initialOpts ) : initialOpts;
		// init layout mode instance
		this.modes[ name ] = new Mode( this );
	};


	Isotope.prototype.layout = function() {
		// if first time doing layout, do all magic
		if ( !this._isLayoutInited && this.options.isInitLayout ) {
			this.arrange();
			return;
		}
		this._layout();
	};

	// private method to be used in layout() & magic()
	Isotope.prototype._layout = function() {
		// don't animate first layout
		var isInstant = this._getIsInstant();
		// layout flow
		this._resetLayout();
		this._manageStamps();
		this.layoutItems( this.filteredItems, isInstant );

		// flag for initalized
		this._isLayoutInited = true;
	};

	// filter + sort + layout
	Isotope.prototype.arrange = function( opts ) {
		// set any options pass
		this.option( opts );
		this._getIsInstant();
		// filter, sort, and layout

		// filter
		var filtered = this._filter( this.items );
		this.filteredItems = filtered.matches;

		var _this = this;
		function hideReveal() {
			_this.reveal( filtered.needReveal );
			_this.hide( filtered.needHide );
		}

		this._bindArrangeComplete();

		if ( this._isInstant ) {
			this._noTransition( hideReveal );
		} else {
			hideReveal();
		}

		this._sort();
		this._layout();
	};
	// alias to _init for main plugin method
	Isotope.prototype._init = Isotope.prototype.arrange;

	// HACK
	// Don't animate/transition first layout
	// Or don't animate/transition other layouts
	Isotope.prototype._getIsInstant = function() {
		var isInstant = this.options.isLayoutInstant !== undefined ?
			this.options.isLayoutInstant : !this._isLayoutInited;
		this._isInstant = isInstant;
		return isInstant;
	};

	// listen for layoutComplete, hideComplete and revealComplete
	// to trigger arrangeComplete
	Isotope.prototype._bindArrangeComplete = function() {
		// listen for 3 events to trigger arrangeComplete
		var isLayoutComplete, isHideComplete, isRevealComplete;
		var _this = this;
		function arrangeParallelCallback() {
			if ( isLayoutComplete && isHideComplete && isRevealComplete ) {
				_this.dispatchEvent( 'arrangeComplete', null, [ _this.filteredItems ] );
			}
		}
		this.once( 'layoutComplete', function() {
			isLayoutComplete = true;
			arrangeParallelCallback();
		});
		this.once( 'hideComplete', function() {
			isHideComplete = true;
			arrangeParallelCallback();
		});
		this.once( 'revealComplete', function() {
			isRevealComplete = true;
			arrangeParallelCallback();
		});
	};

	// -------------------------- filter -------------------------- //

	Isotope.prototype._filter = function( items ) {
		var filter = this.options.filter;
		filter = filter || '*';
		var matches = [];
		var hiddenMatched = [];
		var visibleUnmatched = [];

		var test = this._getFilterTest( filter );

		// test each item
		for ( var i=0, len = items.length; i < len; i++ ) {
			var item = items[i];
			if ( item.isIgnored ) {
				continue;
			}
			// add item to either matched or unmatched group
			var isMatched = test( item );
			// item.isFilterMatched = isMatched;
			// add to matches if its a match
			if ( isMatched ) {
				matches.push( item );
			}
			// add to additional group if item needs to be hidden or revealed
			if ( isMatched && item.isHidden ) {
				hiddenMatched.push( item );
			} else if ( !isMatched && !item.isHidden ) {
				visibleUnmatched.push( item );
			}
		}

		// return collections of items to be manipulated
		return {
			matches: matches,
			needReveal: hiddenMatched,
			needHide: visibleUnmatched
		};
	};

	// get a jQuery, function, or a matchesSelector test given the filter
	Isotope.prototype._getFilterTest = function( filter ) {
		if ( jQuery && this.options.isJQueryFiltering ) {
			// use jQuery
			return function( item ) {
				return jQuery( item.element ).is( filter );
			};
		}
		if ( typeof filter == 'function' ) {
			// use filter as function
			return function( item ) {
				return filter( item.element );
			};
		}
		// default, use filter as selector string
		return function( item ) {
			return matchesSelector( item.element, filter );
		};
	};

	// -------------------------- sorting -------------------------- //

	/**
	 * @params {Array} elems
	 * @public
	 */
	Isotope.prototype.updateSortData = function( elems ) {
		// get items
		var items;
		if ( elems ) {
			elems = utils.makeArray( elems );
			items = this.getItems( elems );
		} else {
			// update all items if no elems provided
			items = this.items;
		}

		this._getSorters();
		this._updateItemsSortData( items );
	};

	Isotope.prototype._getSorters = function() {
		var getSortData = this.options.getSortData;
		for ( var key in getSortData ) {
			var sorter = getSortData[ key ];
			this._sorters[ key ] = mungeSorter( sorter );
		}
	};

	/**
	 * @params {Array} items - of Isotope.Items
	 * @private
	 */
	Isotope.prototype._updateItemsSortData = function( items ) {
		// do not update if no items
		var len = items && items.length;

		for ( var i=0; len && i < len; i++ ) {
			var item = items[i];
			item.updateSortData();
		}
	};

	// ----- munge sorter ----- //

	// encapsulate this, as we just need mungeSorter
	// other functions in here are just for munging
	var mungeSorter = ( function() {
		// add a magic layer to sorters for convienent shorthands
		// `.foo-bar` will use the text of .foo-bar querySelector
		// `[foo-bar]` will use attribute
		// you can also add parser
		// `.foo-bar parseInt` will parse that as a number
		function mungeSorter( sorter ) {
			// if not a string, return function or whatever it is
			if ( typeof sorter != 'string' ) {
				return sorter;
			}
			// parse the sorter string
			var args = trim( sorter ).split(' ');
			var query = args[0];
			// check if query looks like [an-attribute]
			var attrMatch = query.match( /^\[(.+)\]$/ );
			var attr = attrMatch && attrMatch[1];
			var getValue = getValueGetter( attr, query );
			// use second argument as a parser
			var parser = Isotope.sortDataParsers[ args[1] ];
			// parse the value, if there was a parser
			sorter = parser ? function( elem ) {
					return elem && parser( getValue( elem ) );
				} :
				// otherwise just return value
				function( elem ) {
					return elem && getValue( elem );
				};

			return sorter;
		}

		// get an attribute getter, or get text of the querySelector
		function getValueGetter( attr, query ) {
			var getValue;
			// if query looks like [foo-bar], get attribute
			if ( attr ) {
				getValue = function( elem ) {
					return elem.getAttribute( attr );
				};
			} else {
				// otherwise, assume its a querySelector, and get its text
				getValue = function( elem ) {
					var child = elem.querySelector( query );
					return child && getText( child );
				};
			}
			return getValue;
		}

		return mungeSorter;
	})();

	// parsers used in getSortData shortcut strings
	Isotope.sortDataParsers = {
		'parseInt': function( val ) {
			return parseInt( val, 10 );
		},
		'parseFloat': function( val ) {
			return parseFloat( val );
		}
	};

	// ----- sort method ----- //

	// sort filteredItem order
	Isotope.prototype._sort = function() {
		var sortByOpt = this.options.sortBy;
		if ( !sortByOpt ) {
			return;
		}
		// concat all sortBy and sortHistory
		var sortBys = [].concat.apply( sortByOpt, this.sortHistory );
		// sort magic
		var itemSorter = getItemSorter( sortBys, this.options.sortAscending );
		this.filteredItems.sort( itemSorter );
		// keep track of sortBy History
		if ( sortByOpt != this.sortHistory[0] ) {
			// add to front, oldest goes in last
			this.sortHistory.unshift( sortByOpt );
		}
	};

	// returns a function used for sorting
	function getItemSorter( sortBys, sortAsc ) {
		return function sorter( itemA, itemB ) {
			// cycle through all sortKeys
			for ( var i = 0, len = sortBys.length; i < len; i++ ) {
				var sortBy = sortBys[i];
				var a = itemA.sortData[ sortBy ];
				var b = itemB.sortData[ sortBy ];
				if ( a > b || a < b ) {
					// if sortAsc is an object, use the value given the sortBy key
					var isAscending = sortAsc[ sortBy ] !== undefined ? sortAsc[ sortBy ] : sortAsc;
					var direction = isAscending ? 1 : -1;
					return ( a > b ? 1 : -1 ) * direction;
				}
			}
			return 0;
		};
	}

	// -------------------------- methods -------------------------- //

	// get layout mode
	Isotope.prototype._mode = function() {
		var layoutMode = this.options.layoutMode;
		var mode = this.modes[ layoutMode ];
		if ( !mode ) {
			// TODO console.error
			throw new Error( 'No layout mode: ' + layoutMode );
		}
		// HACK sync mode's options
		// any options set after init for layout mode need to be synced
		mode.options = this.options[ layoutMode ];
		return mode;
	};

	Isotope.prototype._resetLayout = function() {
		// trigger original reset layout
		Outlayer.prototype._resetLayout.call( this );
		this._mode()._resetLayout();
	};

	Isotope.prototype._getItemLayoutPosition = function( item  ) {
		return this._mode()._getItemLayoutPosition( item );
	};

	Isotope.prototype._manageStamp = function( stamp ) {
		this._mode()._manageStamp( stamp );
	};

	Isotope.prototype._getContainerSize = function() {
		return this._mode()._getContainerSize();
	};

	Isotope.prototype.needsResizeLayout = function() {
		return this._mode().needsResizeLayout();
	};

	// -------------------------- adding & removing -------------------------- //

	// HEADS UP overwrites default Outlayer appended
	Isotope.prototype.appended = function( elems ) {
		var items = this.addItems( elems );
		if ( !items.length ) {
			return;
		}
		// filter, layout, reveal new items
		var filteredItems = this._filterRevealAdded( items );
		// add to filteredItems
		this.filteredItems = this.filteredItems.concat( filteredItems );
	};

	// HEADS UP overwrites default Outlayer prepended
	Isotope.prototype.prepended = function( elems ) {
		var items = this._itemize( elems );
		if ( !items.length ) {
			return;
		}
		// start new layout
		this._resetLayout();
		this._manageStamps();
		// filter, layout, reveal new items
		var filteredItems = this._filterRevealAdded( items );
		// layout previous items
		this.layoutItems( this.filteredItems );
		// add to items and filteredItems
		this.filteredItems = filteredItems.concat( this.filteredItems );
		this.items = items.concat( this.items );
	};

	Isotope.prototype._filterRevealAdded = function( items ) {
		var filtered = this._filter( items );
		this.hide( filtered.needHide );
		// reveal all new items
		this.reveal( filtered.matches );
		// layout new items, no transition
		this.layoutItems( filtered.matches, true );
		return filtered.matches;
	};

	/**
	 * Filter, sort, and layout newly-appended item elements
	 * @param {Array or NodeList or Element} elems
	 */
	Isotope.prototype.insert = function( elems ) {
		var items = this.addItems( elems );
		if ( !items.length ) {
			return;
		}
		// append item elements
		var i, item;
		var len = items.length;
		for ( i=0; i < len; i++ ) {
			item = items[i];
			this.element.appendChild( item.element );
		}
		// filter new stuff
		var filteredInsertItems = this._filter( items ).matches;
		// set flag
		for ( i=0; i < len; i++ ) {
			items[i].isLayoutInstant = true;
		}
		this.arrange();
		// reset flag
		for ( i=0; i < len; i++ ) {
			delete items[i].isLayoutInstant;
		}
		this.reveal( filteredInsertItems );
	};

	var _remove = Isotope.prototype.remove;
	Isotope.prototype.remove = function( elems ) {
		elems = utils.makeArray( elems );
		var removeItems = this.getItems( elems );
		// do regular thing
		_remove.call( this, elems );
		// bail if no items to remove
		var len = removeItems && removeItems.length;
		if ( !len ) {
			return;
		}
		// remove elems from filteredItems
		for ( var i=0; i < len; i++ ) {
			var item = removeItems[i];
			// remove item from collection
			utils.removeFrom( this.filteredItems, item );
		}
	};

	Isotope.prototype.shuffle = function() {
		// update random sortData
		for ( var i=0, len = this.items.length; i < len; i++ ) {
			var item = this.items[i];
			item.sortData.random = Math.random();
		}
		this.options.sortBy = 'random';
		this._sort();
		this._layout();
	};

	/**
	 * trigger fn without transition
	 * kind of hacky to have this in the first place
	 * @param {Function} fn
	 * @returns ret
	 * @private
	 */
	Isotope.prototype._noTransition = function( fn ) {
		// save transitionDuration before disabling
		var transitionDuration = this.options.transitionDuration;
		// disable transition
		this.options.transitionDuration = 0;
		// do it
		var returnValue = fn.call( this );
		// re-enable transition for reveal
		this.options.transitionDuration = transitionDuration;
		return returnValue;
	};

	// ----- helper methods ----- //

	/**
	 * getter method for getting filtered item elements
	 * @returns {Array} elems - collection of item elements
	 */
	Isotope.prototype.getFilteredItemElements = function() {
		var elems = [];
		for ( var i=0, len = this.filteredItems.length; i < len; i++ ) {
			elems.push( this.filteredItems[i].element );
		}
		return elems;
	};

	// -----  ----- //

	return Isotope;

}));


/*!
 * Packery layout mode PACKAGED v1.1.1
 * sub-classes Packery
 * http://packery.metafizzy.co
 */

!function (a) { function b(a) { return new RegExp("(^|\\s+)" + a + "(\\s+|$)") } function c(a, b) { var c = d(a, b) ? f : e; c(a, b) } var d, e, f; "classList" in document.documentElement ? (d = function (a, b) { return a.classList.contains(b) }, e = function (a, b) { a.classList.add(b) }, f = function (a, b) { a.classList.remove(b) }) : (d = function (a, c) { return b(c).test(a.className) }, e = function (a, b) { d(a, b) || (a.className = a.className + " " + b) }, f = function (a, c) { a.className = a.className.replace(b(c), " ") }); var g = { hasClass: d, addClass: e, removeClass: f, toggleClass: c, has: d, add: e, remove: f, toggle: c }; "function" == typeof define && define.amd ? define("classie/classie", g) : "object" == typeof exports ? module.exports = g : a.classie = g }(window), function (a) { function b() { function a(b) { for (var c in a.defaults) this[c] = a.defaults[c]; for (c in b) this[c] = b[c] } return c.Rect = a, a.defaults = { x: 0, y: 0, width: 0, height: 0 }, a.prototype.contains = function (a) { var b = a.width || 0, c = a.height || 0; return this.x <= a.x && this.y <= a.y && this.x + this.width >= a.x + b && this.y + this.height >= a.y + c }, a.prototype.overlaps = function (a) { var b = this.x + this.width, c = this.y + this.height, d = a.x + a.width, e = a.y + a.height; return this.x < d && b > a.x && this.y < e && c > a.y }, a.prototype.getMaximalFreeRects = function (b) { if (!this.overlaps(b)) return !1; var c, d = [], e = this.x + this.width, f = this.y + this.height, g = b.x + b.width, h = b.y + b.height; return this.y < b.y && (c = new a({ x: this.x, y: this.y, width: this.width, height: b.y - this.y }), d.push(c)), e > g && (c = new a({ x: g, y: this.y, width: e - g, height: this.height }), d.push(c)), f > h && (c = new a({ x: this.x, y: h, width: this.width, height: f - h }), d.push(c)), this.x < b.x && (c = new a({ x: this.x, y: this.y, width: b.x - this.x, height: this.height }), d.push(c)), d }, a.prototype.canFit = function (a) { return this.width >= a.width && this.height >= a.height }, a } var c = a.Packery = function () { }; "function" == typeof define && define.amd ? define("packery/js/rect", b) : "object" == typeof exports ? module.exports = b() : (a.Packery = a.Packery || {}, a.Packery.Rect = b()) }(window), function (a) { function b(a) { function b(a, b, c) { this.width = a || 0, this.height = b || 0, this.sortDirection = c || "downwardLeftToRight", this.reset() } b.prototype.reset = function () { this.spaces = [], this.newSpaces = []; var b = new a({ x: 0, y: 0, width: this.width, height: this.height }); this.spaces.push(b), this.sorter = c[this.sortDirection] || c.downwardLeftToRight }, b.prototype.pack = function (a) { for (var b = 0, c = this.spaces.length; c > b; b++) { var d = this.spaces[b]; if (d.canFit(a)) { this.placeInSpace(a, d); break } } }, b.prototype.placeInSpace = function (a, b) { a.x = b.x, a.y = b.y, this.placed(a) }, b.prototype.placed = function (a) { for (var b = [], c = 0, d = this.spaces.length; d > c; c++) { var e = this.spaces[c], f = e.getMaximalFreeRects(a); f ? b.push.apply(b, f) : b.push(e) } this.spaces = b, this.mergeSortSpaces() }, b.prototype.mergeSortSpaces = function () { b.mergeRects(this.spaces), this.spaces.sort(this.sorter) }, b.prototype.addSpace = function (a) { this.spaces.push(a), this.mergeSortSpaces() }, b.mergeRects = function (a) { for (var b = 0, c = a.length; c > b; b++) { var d = a[b]; if (d) { var e = a.slice(0); e.splice(b, 1); for (var f = 0, g = 0, h = e.length; h > g; g++) { var i = e[g], j = b > g ? 0 : 1; d.contains(i) && (a.splice(g + j - f, 1), f++) } } } return a }; var c = { downwardLeftToRight: function (a, b) { return a.y - b.y || a.x - b.x }, rightwardTopToBottom: function (a, b) { return a.x - b.x || a.y - b.y } }; return b } if ("function" == typeof define && define.amd) define("packery/js/packer", ["./rect"], b); else if ("object" == typeof exports) module.exports = b(require("./rect")); else { var c = a.Packery = a.Packery || {}; c.Packer = b(c.Rect) } }(window), function (a) { function b(a, b, c) { var d = a("transform"), e = function () { b.Item.apply(this, arguments) }; e.prototype = new b.Item; var f = e.prototype._create; return e.prototype._create = function () { f.call(this), this.rect = new c, this.placeRect = new c }, e.prototype.dragStart = function () { this.getPosition(), this.removeTransitionStyles(), this.isTransitioning && d && (this.element.style[d] = "none"), this.getSize(), this.isPlacing = !0, this.needsPositioning = !1, this.positionPlaceRect(this.position.x, this.position.y), this.isTransitioning = !1, this.didDrag = !1 }, e.prototype.dragMove = function (a, b) { this.didDrag = !0; var c = this.layout.size; a -= c.paddingLeft, b -= c.paddingTop, this.positionPlaceRect(a, b) }, e.prototype.dragStop = function () { this.getPosition(); var a = this.position.x !== this.placeRect.x, b = this.position.y !== this.placeRect.y; this.needsPositioning = a || b, this.didDrag = !1 }, e.prototype.positionPlaceRect = function (a, b, c) { this.placeRect.x = this.getPlaceRectCoord(a, !0), this.placeRect.y = this.getPlaceRectCoord(b, !1, c) }, e.prototype.getPlaceRectCoord = function (a, b, c) { var d = b ? "Width" : "Height", e = this.size["outer" + d], f = this.layout[b ? "columnWidth" : "rowHeight"], g = this.layout.size["inner" + d]; b || (g = Math.max(g, this.layout.maxY), this.layout.rowHeight || (g -= this.layout.gutter)); var h; if (f) { f += this.layout.gutter, g += b ? this.layout.gutter : 0, a = Math.round(a / f); var i; i = this.layout.options.isHorizontal ? b ? "ceil" : "floor" : b ? "floor" : "ceil"; var j = Math[i](g / f); j -= Math.ceil(e / f), h = j } else h = g - e; return a = c ? a : Math.min(a, h), a *= f || 1, Math.max(0, a) }, e.prototype.copyPlaceRectPosition = function () { this.rect.x = this.placeRect.x, this.rect.y = this.placeRect.y }, e.prototype.removeElem = function () { this.element.parentNode.removeChild(this.element), this.layout.packer.addSpace(this.rect), this.emitEvent("remove", [this]) }, e } "function" == typeof define && define.amd ? define("packery/js/item", ["get-style-property/get-style-property", "outlayer/outlayer", "./rect"], b) : "object" == typeof exports ? module.exports = b(require("desandro-get-style-property"), require("outlayer"), require("./rect")) : a.Packery.Item = b(a.getStyleProperty, a.Outlayer, a.Packery.Rect) }(window), function (a) { function b(a, b, c, d, e, f) { function g(a, b) { return a.position.y - b.position.y || a.position.x - b.position.x } function h(a, b) { return a.position.x - b.position.x || a.position.y - b.position.y } d.prototype.canFit = function (a) { return this.width >= a.width - 1 && this.height >= a.height - 1 }; var i = c.create("packery"); return i.Item = f, i.prototype._create = function () { c.prototype._create.call(this), this.packer = new e, this.stamp(this.options.stamped); var a = this; this.handleDraggabilly = { dragStart: function (b) { a.itemDragStart(b.element) }, dragMove: function (b) { a.itemDragMove(b.element, b.position.x, b.position.y) }, dragEnd: function (b) { a.itemDragEnd(b.element) } }, this.handleUIDraggable = { start: function (b) { a.itemDragStart(b.currentTarget) }, drag: function (b, c) { a.itemDragMove(b.currentTarget, c.position.left, c.position.top) }, stop: function (b) { a.itemDragEnd(b.currentTarget) } } }, i.prototype._resetLayout = function () { this.getSize(), this._getMeasurements(); var a = this.packer; this.options.isHorizontal ? (a.width = Number.POSITIVE_INFINITY, a.height = this.size.innerHeight + this.gutter, a.sortDirection = "rightwardTopToBottom") : (a.width = this.size.innerWidth + this.gutter, a.height = Number.POSITIVE_INFINITY, a.sortDirection = "downwardLeftToRight"), a.reset(), this.maxY = 0, this.maxX = 0 }, i.prototype._getMeasurements = function () { this._getMeasurement("columnWidth", "width"), this._getMeasurement("rowHeight", "height"), this._getMeasurement("gutter", "width") }, i.prototype._getItemLayoutPosition = function (a) { return this._packItem(a), a.rect }, i.prototype._packItem = function (a) { this._setRectSize(a.element, a.rect), this.packer.pack(a.rect), this._setMaxXY(a.rect) }, i.prototype._setMaxXY = function (a) { this.maxX = Math.max(a.x + a.width, this.maxX), this.maxY = Math.max(a.y + a.height, this.maxY) }, i.prototype._setRectSize = function (a, c) { var d = b(a), e = d.outerWidth, f = d.outerHeight; (e || f) && (e = this._applyGridGutter(e, this.columnWidth), f = this._applyGridGutter(f, this.rowHeight)), c.width = Math.min(e, this.packer.width), c.height = Math.min(f, this.packer.height) }, i.prototype._applyGridGutter = function (a, b) { if (!b) return a + this.gutter; b += this.gutter; var c = a % b, d = c && 1 > c ? "round" : "ceil"; return a = Math[d](a / b) * b }, i.prototype._getContainerSize = function () { return this.options.isHorizontal ? { width: this.maxX - this.gutter } : { height: this.maxY - this.gutter } }, i.prototype._manageStamp = function (a) { var b, c = this.getItem(a); if (c && c.isPlacing) b = c.placeRect; else { var e = this._getElementOffset(a); b = new d({ x: this.options.isOriginLeft ? e.left : e.right, y: this.options.isOriginTop ? e.top : e.bottom }) } this._setRectSize(a, b), this.packer.placed(b), this._setMaxXY(b) }, i.prototype.sortItemsByPosition = function () { var a = this.options.isHorizontal ? h : g; this.items.sort(a) }, i.prototype.fit = function (a, b, c) { var d = this.getItem(a); d && (this._getMeasurements(), this.stamp(d.element), d.getSize(), d.isPlacing = !0, b = void 0 === b ? d.rect.x : b, c = void 0 === c ? d.rect.y : c, d.positionPlaceRect(b, c, !0), this._bindFitEvents(d), d.moveTo(d.placeRect.x, d.placeRect.y), this.layout(), this.unstamp(d.element), this.sortItemsByPosition(), d.isPlacing = !1, d.copyPlaceRectPosition()) }, i.prototype._bindFitEvents = function (a) { function b() { d++ , 2 === d && c.emitEvent("fitComplete", [c, a]) } var c = this, d = 0; a.on("layout", function () { return b(), !0 }), this.on("layoutComplete", function () { return b(), !0 }) }, i.prototype.resize = function () { var a = b(this.element), c = this.size && a, d = this.options.isHorizontal ? "innerHeight" : "innerWidth"; c && a[d] === this.size[d] || this.layout() }, i.prototype.itemDragStart = function (a) { this.stamp(a); var b = this.getItem(a); b && b.dragStart() }, i.prototype.itemDragMove = function (a, b, c) { function d() { f.layout(), delete f.dragTimeout } var e = this.getItem(a); e && e.dragMove(b, c); var f = this; this.clearDragTimeout(), this.dragTimeout = setTimeout(d, 40) }, i.prototype.clearDragTimeout = function () { this.dragTimeout && clearTimeout(this.dragTimeout) }, i.prototype.itemDragEnd = function (b) { var c, d = this.getItem(b); if (d && (c = d.didDrag, d.dragStop()), !d || !c && !d.needsPositioning) return void this.unstamp(b); a.add(d.element, "is-positioning-post-drag"); var e = this._getDragEndLayoutComplete(b, d); d.needsPositioning ? (d.on("layout", e), d.moveTo(d.placeRect.x, d.placeRect.y)) : d && d.copyPlaceRectPosition(), this.clearDragTimeout(), this.on("layoutComplete", e), this.layout() }, i.prototype._getDragEndLayoutComplete = function (b, c) { var d = c && c.needsPositioning, e = 0, f = d ? 2 : 1, g = this; return function () { return e++ , e !== f ? !0 : (c && (a.remove(c.element, "is-positioning-post-drag"), c.isPlacing = !1, c.copyPlaceRectPosition()), g.unstamp(b), g.sortItemsByPosition(), d && g.emitEvent("dragItemPositioned", [g, c]), !0) } }, i.prototype.bindDraggabillyEvents = function (a) { a.on("dragStart", this.handleDraggabilly.dragStart), a.on("dragMove", this.handleDraggabilly.dragMove), a.on("dragEnd", this.handleDraggabilly.dragEnd) }, i.prototype.bindUIDraggableEvents = function (a) { a.on("dragstart", this.handleUIDraggable.start).on("drag", this.handleUIDraggable.drag).on("dragstop", this.handleUIDraggable.stop) }, i.Rect = d, i.Packer = e, i } "function" == typeof define && define.amd ? define("packery/js/packery", ["classie/classie", "get-size/get-size", "outlayer/outlayer", "./rect", "./packer", "./item"], b) : "object" == typeof exports ? module.exports = b(require("desandro-classie"), require("get-size"), require("outlayer"), require("./rect"), require("./packer"), require("./item")) : a.Packery = b(a.classie, a.getSize, a.Outlayer, a.Packery.Rect, a.Packery.Packer, a.Packery.Item) }(window), function (a) { function b(a, b) { for (var c in b) a[c] = b[c]; return a } function c(a, c, d) { var e = a.create("packery"), f = e.prototype._getElementOffset, g = e.prototype._getMeasurement; b(e.prototype, c.prototype), e.prototype._getElementOffset = f, e.prototype._getMeasurement = g; var h = e.prototype._resetLayout; e.prototype._resetLayout = function () { this.packer = this.packer || new c.Packer, h.apply(this, arguments) }; var i = e.prototype._getItemLayoutPosition; e.prototype._getItemLayoutPosition = function (a) { return a.rect = a.rect || new c.Rect, i.call(this, a) }; var j = e.prototype._manageStamp; return e.prototype._manageStamp = function () { this.options.isOriginLeft = this.isotope.options.isOriginLeft, this.options.isOriginTop = this.isotope.options.isOriginTop, j.apply(this, arguments) }, e.prototype.needsResizeLayout = function () { var a = d(this.element), b = this.size && a, c = this.options.isHorizontal ? "innerHeight" : "innerWidth"; return b && a[c] !== this.size[c] }, e } "function" == typeof define && define.amd ? define(["isotope/js/layout-mode", "packery/js/packery", "get-size/get-size"], c) : "object" == typeof exports ? module.exports = c(require("isotope-layout/js/layout-mode"), require("packery"), require("get-size")) : c(a.Isotope.LayoutMode, a.Packery, a.getSize) }(window);
