<?php

use \UtillzCore\Inc\Src\Listing_Type\Action;

defined('ABSPATH') || exit;

global $ulz_submission;

$action_fields = Action::get_action_fields( $ulz_submission->listing_type );

?>

<div class="ulz-submission-steps">

    <form>
        <input type="hidden" name="type" value="<?php echo esc_attr( $ulz_submission->id ); ?>">
    </form>

    <?php

        if( $ulz_submission->listing_type->has_plans() ) {
            $ulz_submission->component->render([
                'type' => 'select-plan'
            ]);
        }

        $field_collected_ids = [];

        foreach( $ulz_submission->tabs as $index => $tab ) {
            if( isset( $tab['content'] ) ) {

                $fields = [];

                foreach( $tab['content'] as $content ) {
                    if( ! in_array( $content->fields->key, $field_collected_ids ) ) {
                        $fields[] = $content;
                        $field_collected_ids[] = $content->fields->key;
                    }
                }

                $ulz_submission->component->render([
                    'type' => 'fields',
                    'group' => $index,
                    'title' => $tab['title'],
                    'fields' => $fields,
                ]);

            }
        }

        $actions = $ulz_submission->listing_type->get_action();

        if( $action_fields->allow_pricing ) {
            $ulz_submission->component->render([
                'type' => 'pricing'
            ]);
        }

        $ulz_submission->component->render([
            'type' => 'publish'
        ]);

        $ulz_submission->component->render([
            'type' => 'success'
        ]);

    ?>

</div>
