<?php

defined('ABSPATH') || exit;

global $ulz_listing;

$review_submission = $ulz_listing->type->get('ulz_review_submission');
if( empty( $review_submission ) ) {
    $review_submission = 'everyone';
}

?>

<div class="ulz-reviews-stats-summary">
    <div class="ulz-reviews-stats-text">
            <?php echo sprintf( _n( '<strong>%s review</strong>', '<strong>%s reviews</strong>', $ulz_listing->reviews->count, 'utillz-core' ), $ulz_listing->reviews->count ); ?>
            <?php if( $ulz_listing->reviews->average ): ?>
                <span class="ulz-reviews-stat-num">
                    <i class="fas fa-star"></i>
                    <strong><?php echo number_format( floatval( $ulz_listing->reviews->average ), 2 ); ?></strong>
                </span>
            <?php endif; ?>
    </div>
    <?php if( $review_submission == 'everyone' ): ?>
        <div class="">
            <a href="#" class="ulz-button ulz-button-accent" data-modal="<?php echo is_user_logged_in() ? 'review-submit' : 'signin'; ?>" data-params="<?php echo get_the_ID(); ?>">
                <span><?php esc_html_e( 'Submit a Review', 'utillz-core' ); ?></span>
            </a>
        </div>
    <?php endif; ?>
</div>

<?php if( $ulz_listing->type->get('ulz_enable_review_ratings') && $ulz_listing->reviews->count ): ?>

    <div class="ulz-reviews-stats">
        <div class="ulz-grid">
            <?php $ratings = Ucore()->jsoning( 'ulz_review_ratings', $ulz_listing->type->id ); ?>
            <?php foreach( $ratings as $key => $rating ): ?>
                <?php
                    $rating_average = round( floatval( Ucore()->get( sprintf( 'ulz_review_rating_average_%s', $rating->fields->key ) ) ), 2 );
                ?>
                <div class="ulz-col-6 ulz-col-sm-12">
                    <div class="ulz-reviews-stat">
                        <div class="ulz-grid">
                            <div class="ulz-col-6 ulz-col-ulz-6">
                                <?php echo esc_attr( $rating->fields->name ); ?>
                            </div>
                            <div class="ulz-col-6 ulz-col-ulz-6">
                                <div class="ulz-reviews-stat-bar">
                                    <div class="ulz-reviews-progress ulz-flex ulz-flex-column ulz-justify-center">
                                        <div class="ulz-progress">
                                            <div class="ulz-progress-bar"
                                                role="progressbar"
                                                aria-valuenow="<?php echo round( 20 * $rating_average ); ?>"
                                                aria-valuemin="0"
                                                aria-valuemax="100"
                                                style="width:<?php echo round( 20 * $rating_average ); ?>%">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ulz-reviews-num">
                                        <?php if( $rating_average ): ?>
                                            <strong><?php echo number_format( $rating_average, 1 ); ?></strong>
                                        <?php else: ?>
                                            &nbsp;
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>
