<?php

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;

defined('ABSPATH') || exit;

global $ulz_listing;

$request = Request::instance();
$ulz_listing = new Listing( $request->get('listing_id') );

if( ! $ulz_listing->type->get('ulz_allow_pricing') ) {
    return;
}

$pricing = $ulz_listing->get_pricing(
    $request->get('addons')
);

?>

<table>
    <tbody>
        <tr>
            <td><?php esc_html_e('Price', 'utillz-core'); ?></td>
            <td><?php echo Ucore()->format_price( $pricing->base ); ?></td>
        </tr>
        <?php if( $pricing->service_fee ): ?>
            <tr>
                <td><?php esc_html_e('Service fee', 'utillz-core'); ?></td>
                <td><?php echo Ucore()->format_price( $pricing->service_fee ); ?></td>
            </tr>
        <?php endif; ?>
        <?php if( $pricing->extras ): ?>
            <?php foreach( $pricing->extras as $extra ): ?>
                <tr>
                    <td><?php echo esc_html( $extra->name ); ?></td>
                    <td><?php echo Ucore()->format_price( $extra->price ); ?></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        <?php if( $pricing->addons ): ?>
            <?php foreach( $pricing->addons as $addon ): ?>
                <tr>
                    <td><?php echo esc_html( $addon->name ); ?></td>
                    <td><?php echo Ucore()->format_price( $addon->price ); ?></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        <?php $payment_processing_percentage = (int) $ulz_listing->type->get('ulz_payment_processing_percentage'); ?>
        <?php if( $pricing->payment_processing == 'percentage' && $payment_processing_percentage > 0 ): ?>
            <tr>
                <td><?php echo esc_html( $pricing->payment_processing_name ); ?></td>
                <td><?php echo (int) $payment_processing_percentage; ?>%</td>
            </tr>
        <?php else: ?>
            <tr>
                <td><?php echo esc_html( $pricing->payment_processing_name ); ?></td>
                <td>&nbsp;</td>
            </tr>
        <?php endif; ?>
        <tr>
            <td><strong><?php esc_html_e('Total', 'utillz-core'); ?></strong></td>
            <td><strong><?php echo Ucore()->format_price( $pricing->total ); ?></strong></td>
        </tr>
        <tr>
            <td><strong><?php esc_html_e('Due now', 'utillz-core'); ?></strong></td>
            <td><strong><?php echo Ucore()->format_price( $pricing->processing ); ?></strong></td>
        </tr>
    </tbody>
</table>
