<?php

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;

$request = Request::instance();
$listing = new Listing( $request->get('listing_id') );
$promotions = $listing->type->get_wc_promotions();

?>

<div class="ulz-modal-container ulz-scrollbar">
    <div class="ulz-packages ulz-no-select">
        <?php if( $listing->id && $listing->type ): ?>
            <?php $promotions = $listing->type->get_wc_promotions(); ?>
            <input type="hidden" id="promote-listing-id" value="<?php echo $listing->id; ?>">
            <?php wp_nonce_field( 'utillz_promote_listing_nonce', 'utillz_promote_listing' ); ?>
            <?php if( $promotions ): ?>
                <?php global $ulz_package; ?>
                <?php foreach( $promotions as $ulz_package ): ?>
                    <?php Ucore()->the_template('modals/promote/row') ?>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="ulz--empty ulz-text-center ulz-weight-600"><?php esc_html_e( 'No packages were found.', 'utillz-core' ); ?></p>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if( $promotions ): ?>
    <div class="ulz-modal-footer ulz--top-border ulz-text-center">
        <a href="#" class="ulz-button ulz-button-accent ulz-modal-button" data-action="promote-listing">
            <span><?php esc_html_e( 'Continue', 'utillz-core' ); ?></span>
            <span class="fas fa-arrow-right ulz-ml-1"></span>
            <?php Ucore()->preloader(); ?>
        </a>
    </div>
<?php endif; ?>
