<?php

use \UtillzCore\Inc\Src\Form\Component as Form;

$form = new Form( Form::Storage_Field );

?>

<div class="ulz-modal ulz-modal-payout" data-id="payout">
    <?php Ucore()->the_template('modals/close'); ?>
    <div class="ulz-modal-heading ulz--border">
        <h4 class="ulz--title"><?php esc_html_e( 'Request a payout', 'utillz-core' ); ?></h4>
    </div>
    <div class="ulz-modal-content">
        <div class="ulz-modal-append">
            <div class="ulz-modal-container ulz-scrollbar">

                <span class="ulz--icon ulz-none">
                    <div class="ulz-text-center">
                        <i class="fas fa-check"></i>
                        <p><?php esc_html_e( 'Your payout request was sent', 'utillz-core' ); ?></p>
                    </div>
                </span>

                <form class="ulz-form">
                    <div class="ulz-grid">
                        <?php

                            $form->render([
                                'type' => 'text',
                                'id' => 'amount',
                                'name' => esc_html__('Amount', 'utillz-core'),
                                'placeholder' => '0.00'
                            ]);

                            $payout_methods = get_option('ulz_payout_methods');

                            $options = [];
                            if( is_array( $payout_methods ) ) {
                                if( in_array( 'paypal', $payout_methods ) ) {
                                    $options['paypal'] = esc_html__('PayPal', 'utillz-core');
                                }
                                if( in_array( 'bank_transfer', $payout_methods ) ) {
                                    $options['bank_transfer'] = esc_html__('Bank Transfer', 'utillz-core');
                                }
                            }

                            $form->render([
                                'type' => 'select',
                                'id' => 'method',
                                'name' => esc_html__('Method', 'utillz-core'),
                                'options' => $options,
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'paypal_email',
                                'name' => esc_html__( 'PayPal Email', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'paypal',
                                ],
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'bank_account_name',
                                'name' => esc_html__( 'Account Name', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'bank_transfer',
                                ],
                                'col' => 6
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'bank_account_number',
                                'name' => esc_html__( 'Account Number', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'bank_transfer',
                                ],
                                'col' => 6
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'bank_iban',
                                'name' => esc_html__( 'Bank IBAN', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'bank_transfer',
                                ],
                                'col' => 6
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'bank_bic',
                                'name' => esc_html__( 'BIC / Swift', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'bank_transfer',
                                ],
                                'col' => 6
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'bank_name',
                                'name' => esc_html__( 'Bank Name', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'bank_transfer',
                                ],
                                'col' => 6
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'bank_routing_number',
                                'name' => esc_html__( 'Routing Number', 'utillz-core' ),
                                'dependency' => [
                                    'id' => 'method',
                                    'compare' => '=',
                                    'value' => 'bank_transfer',
                                ],
                                'col' => 6
                            ]);

                        ?>
                    </div>
                </form>
            </div>
            <div class="ulz-modal-footer ulz--top-border ulz-text-center">
                <a href="#" class="ulz-button ulz-button-accent ulz-modal-button" data-action="payout">
                    <span><?php esc_html_e( 'Send Request', 'utillz-core' ); ?></span>
                    <span class="fas fa-arrow-right ulz-ml-1"></span>
                    <?php Ucore()->preloader(); ?>
                </a>
            </div>
        </div>
        <?php Ucore()->preloader(); ?>
    </div>
</div>
