<?php

defined('ABSPATH') || exit;

global $ulz_explore;

echo '<ul class="ulz-dynamic ulz-none" data-dynamic="markers">';
    // if( $ulz_explore->type ) {
        while( $ulz_explore->query()->posts->have_posts() ) { $ulz_explore->query()->posts->the_post();

            $listing_type_id = Ucore()->get( 'ulz_listing_type' );

            $address = '';
            $attr = [];

            $attr['data-id'] = get_the_ID();

            $location = Ucore()->get( 'ulz_location', null, false );
            if( isset( $location[0] ) ) { $address = esc_attr( $location[0] ); }
            if( isset( $location[1] ) ) { $attr['data-lat'] = esc_attr( $location[1] ); }
            if( isset( $location[2] ) ) { $attr['data-lng'] = esc_attr( $location[2] ); }

            if( $location ) {

                $class = [];
                $type = Ucore()->get( 'ulz_marker_type', $listing_type_id );
                $enable_favorite = Ucore()->get( 'ulz_display_listing_favorite', $listing_type_id );
                $is_favorite = ( $ulz_explore->user->id && $ulz_explore->user->is_favorite( get_the_ID() ) );

                if( $enable_favorite && $is_favorite ) {
                    $class[] = 'ulz--is-fav';
                }

                echo '<li ' . Ucore()->attrs( $attr ) . '>';

                    if( $type == 'field' ) {

                        $field = Ucore()->get( 'ulz_marker_field', $listing_type_id );
                        $format = Ucore()->get( 'ulz_marker_field_format', $listing_type_id );
                        $value = Ucore()->get( $field );
                        if( empty( $value ) ) {
                            $value = esc_html__( 'No data', 'utillz-core' );
                        }else{
                            $value = $format ? sprintf( $format, $value ) : $value;
                        }

                        echo '<div class="ulz-marker ulz-marker-field ' . implode( ' ', $class ) . '" data-id="' . get_the_ID() . '">';
                        echo apply_filters( 'ulz_marker_field_output', esc_attr( $value ) );
                        if( $enable_favorite ) {
                            echo '<span class="ulz--fav"><i class="fas fa-heart"></i></span>';
                        }
                        echo '</div>';

                    }
                    elseif( $type == 'icon' ) {

                        $icon = Ucore()->get( 'ulz_icon', $listing_type_id );

                        if( $icon ) {
                            echo '<div class="ulz-marker ulz-marker-icon ' . implode( ' ', $class ) . '" data-id="' . get_the_ID() . '">';
                            echo '<i class="' . esc_attr( $icon ) . '"></i>';
                            if( $enable_favorite ) {
                                echo '<span class="ulz--fav"><i class="fas fa-heart"></i></span>';
                            }
                            echo '</div>';
                        }

                    }
                    elseif( $type == 'image' ) {

                        $image_attrs = Ucore()->jsoning( 'ulz_marker_image', $listing_type_id );
                        $image_width = Ucore()->get( 'ulz_marker_image_size', $listing_type_id );

                        if( isset( $image_attrs[0] ) && isset( $image_attrs[0]->id ) ) {

                            $image = Ucore()->get_image( $image_attrs[0]->id );

                            if( $image ) {
                                echo '<div class="ulz-marker ulz-marker-image ' . implode( ' ', $class ) . '" data-id="' . get_the_ID() . '">';
                                echo '<img src="' . esc_url( $image ) . '" alt="" width="' . (int) $image_width . '">';
                                if( $enable_favorite ) {
                                    echo '<span class="ulz--fav"><i class="fas fa-heart"></i></span>';
                                }
                                echo '</div>';
                            }



                        }

                    }

                echo '</li>';
            }

        }
    // }
echo '</ul>';
wp_reset_postdata();
