<?php

defined('ABSPATH') || exit;

global $ulz_explore;

?>

<div class="ulz-dynamic" data-dynamic="map">


    <label class="ulz-geo-sync">
        <div class="ulz-checkbox ulz-no-select">
            <input type="checkbox" name="ulz_geo_sync" value="1" checked="checked">
            <span class="ulz--toggle ulz-transition"></span>
            <span class="ulz--text ulz--collect"><?php esc_html_e('Search as I move the map', 'utillz-core'); ?></span>
        </div>
    </label>

    <?php if( get_option('ulz_google_api_key') ): ?>
        <div class="ulz-explore-map" id="ulz-explore-map"></div>
        <div class="ulz-map-zoom">
            <a href="#" class="ulz--zoom-in" data-action="explore-map-zoom-in"><i class="fas fa-plus"></i></a>
            <a href="#" class="ulz--zoom-out" data-action="explore-map-zoom-out"><i class="fas fa-minus"></i></a>
        </div>
        <?php do_action('utillz/after_map'); ?>
    <?php else: ?>
        <div class="ulz-explore-map ulz--no-map">
            <strong><?php esc_html_e( 'Map can\'t be displayed, please add Google Map Api Key', 'utillz-core' ); ?></strong>
        </div>
    <?php endif; ?>

    <?php Ucore()->the_template('explore/map/markers'); ?>
    <?php Ucore()->the_template('explore/map/infoboxes'); ?>

    <span class="ulz-map-overlay"></span>

    <?php Ucore()->preloader(); ?>

</div>
