<?php

defined('ABSPATH') || exit;

global $ulz_listing;

$ulz_listing = new \UtillzCore\Inc\Src\Listing\Listing();
$cover_type = $ulz_listing->type->get('ulz_listing_cover_type');

?>

<div class="ulz-listing<?php $ulz_listing->the_classes(); ?>" <?php $ulz_listing->the_attrs(); ?>>

    <?php if( $cover_type == 'image' || $cover_type == 'slider' ): ?>
        <div class="ulz-listing-cover">
            <div class="ulz-listing-cover-inner">

                <?php Ucore()->the_template('explore/listing/gallery'); ?>

                <?php Ucore()->the_template('explore/listing/priority'); ?>

                <?php Ucore()->the_template('explore/listing/badges'); ?>

            </div>
        </div>
    <?php elseif( $cover_type == 'author' ): ?>

        <?php Ucore()->the_template('explore/listing/author'); ?>

    <?php endif; ?>

    <?php if( ! $ulz_listing->type->get('ulz_hide_listing_details') ): ?>
        <a class="ulz-listing-content" href="<?php the_permalink(); ?>" <?php Ucore()->set_explore_open(); ?>>

            <?php Ucore()->the_template('explore/listing/heading'); ?>

            <?php if( $cover_type == 'author' ): ?>
                <?php Ucore()->the_template('explore/listing/priority'); ?>
            <?php endif; ?>

            <?php Ucore()->the_template('explore/listing/details-content'); ?>

            <?php Ucore()->the_template('explore/listing/details-bottom'); ?>

        </a>
    <?php endif; ?>

</div>
