<?php

defined('ABSPATH') || exit;

global $ulz_listing;

?>

<div class="ulz--heading">
    <div class="ulz--primary">
        <div class="ulz-title">
            <h4>
                <?php echo do_shortcode( $ulz_listing->get( $ulz_listing->type->get('ulz_display_listing_title') ) ); ?>
            </h4>
        </div>
        <?php if( $tagline_field = $ulz_listing->type->get('ulz_display_listing_tagline') ): ?>
            <?php if( $tagline = $ulz_listing->get( $tagline_field ) ): ?>
                <div class="ulz-listing-tagline">
                    <?php echo do_shortcode( wpautop( wp_trim_words( wp_strip_all_tags( $tagline ), apply_filters('utillz/listing/box/tagline-words', 15) ) ) ); ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    <?php if( $ulz_listing->type->get('ulz_display_listing_review') && $ulz_listing->reviews->average ): ?>
        <div class="ulz--review">
            <div class="ulz-listing-review">
                <i class="fas fa-star"></i>
                <span><?php echo number_format( $ulz_listing->reviews->average, 2 ); ?></span>
            </div>
        </div>
    <?php endif; ?>
</div>
