<?php

defined('ABSPATH') || exit;

global $ulz_explore, $ulz_search_form_id, $ulz_search_form_id_more;

$ulz_search_form_id = $ulz_explore->type ? $ulz_explore->type->get('ulz_search_form') : get_option('ulz_global_search_form');
$ulz_search_form_id_more = $ulz_explore->type ? $ulz_explore->type->get('ulz_search_form_more') : get_option('ulz_global_search_form_more');

?>

<div class="ulz-dynamic" data-dynamic="filters">
    <div class="ulz-search">

        <?php if( $ulz_search_form_id ): ?>

            <?php do_action( 'utillz/explore/filters/before', $ulz_search_form_id ); ?>

            <?php $filters = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $ulz_search_form_id ) ); ?>

            <?php if( $filters ): ?>
                <div class="ulz-search-filter ulz-search-filter--inline" data-form-id="<?php echo (int) $ulz_search_form_id; ?>">

                    <div class="ulz--content">
                        <div class="ulz-search-filter-inner">

                            <?php if( current_user_can('manage_options') && ! get_option('ulz_hide_edit_search_form') ): ?>
                                <div class="ulz-mb-2">
                                    <a href="<?php echo esc_url( get_edit_post_link( $ulz_search_form_id ) ); ?>" class="ulz-no-decoration ulz-text-right" target="_blank">
                                        <?php esc_html_e( 'Edit search form', 'utillz-core' ); ?>
                                        <i class="fas fa-external-link-alt ulz-ml-1"></i>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <div class="ulz-form">
                                <div class="ulz-grid">

                                    <?php

                                        // hidden listing type slug
                                        $ulz_explore->component->render([
                                            'type' => 'hidden',
                                            'id' => 'type',
                                        ]);

                                        // listing type filters
                                        if( ! empty( $filters ) ) {
                                            $ulz_explore->component->tabs( $filters );
                                        }

                                    ?>

                                </div>
                            </div>
                        </div>

                        <div class="ulz-search-footer">
                            <div class="ulz-filters-footer ulz-flex ulz-justify-space ulz-mb-2">

                                <?php if( $ulz_search_form_id_more ): ?>
                                    <?php $filters_more = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $ulz_search_form_id_more ) ); ?>
                                    <?php if( $filters_more ): ?>

                                        <div>
                                            <?php $active_filters = $ulz_explore->component->count_active_filters( $ulz_search_form_id_more ); ?>
                                            <a href="#" class="ulz-more-filters" data-modal="filters" data-params=''>
                                                <i class="material-icons ulz-mr-1">tune</i>
                                                <?php esc_html_e( 'More filters', 'utillz-core' ); ?>
                                                <?php if( $active_filters ): ?>
                                                    <span class="ulz--active"><?php echo (int) $active_filters; ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </div>

                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php
                                    $args = [];
                                    if( $ulz_explore->type ) {
                                        $args['type'] = $ulz_explore->type->get('ulz_slug');
                                    }
                                ?>

                                <div>
                                    <a href="<?php echo esc_url( Ucore()->get_explore_page_url( $args, false ) ); ?>" class="ulz-search-clear ulz-action-dynamic-explore">
                                        <?php esc_html_e( 'Clear', 'utillz-core' ); ?>
                                    </a>
                                </div>

                            </div>

                            <div class="ulz--submit">
                                <a href="#" class="ulz-button ulz-block ulz-action-filter">
                                    <span><?php esc_html_e( 'Search', 'utillz-core' ); ?></span>
                                    <?php Ucore()->preloader(); ?>
                                </a>
                            </div>

                        </div>
                    </div>


                </div>
            <?php else: ?>
                <p><?php esc_html_e( 'There are no search filter. Edit your search form and add some using the modules', 'utillz-core' ); ?></p>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <?php Ucore()->the_template('modals/filters/content'); ?>

</div>
