<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Wallet;
use \UtillzCore\Inc\Src\Request\Request;

$payouts = Wallet::get_all_payouts();
$request = Request::instance();
$page = $request->has('onpage') ? $request->get('onpage') : 1;

?>

<div class="ulz-meta-container ulz-container-left">
    <h1><?php esc_html_e( 'Payouts', 'utillz-core' ); ?></h1>
</div>

<?php if( $payouts->max_num_pages > 1 ): ?>
    <div class="ulz-outer">
        <div class="ulz-paging">
            <?php

                echo Ucore()->pagination([
                    'base' => add_query_arg([ 'onpage' => '%#%' ], 'edit.php?post_type=ulz_listing_type&page=ulz_payouts'),
                    'format' => '?onpage=%#%',
                    'current' => $page,
                    'total' => $payouts->max_num_pages,
                ]);

            ?>
        </div>
    </div>
<?php endif; ?>

<div class="wrap">

    <table class="wp-list-table widefat striped">
        <thead>
            <tr>
                <th><strong><?php esc_html_e( 'ID', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Status', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'User', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Amount', 'utillz-core' ); ?></strong></th>
			    <th><strong><?php esc_html_e( 'Method', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Address', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Actions', 'utillz-core' ); ?></strong></th>
            </tr>
        </thead>

        <tbody>

            <?php if( $payouts->results ): ?>

                <?php foreach( $payouts->results as $payout ): ?>

                    <?php

                    // dd( $payout );

                    $id = (int) $payout->id;
                    $user_id = (int) $payout->user_id;
					$userdata = get_userdata( $user_id );
                	$amount = Ucore()->format_price( $payout->amount );
                	$status = $payout->status;
					$method	= $payout->payment_method;
					$address = '';

                    if( ! isset( $address->paypal_email ) && ! isset( $address->bank_account_name ) ) {
                        return;
                    }

                    $address_html = '';

                    $actions = [];

                    if( in_array( $status, [ 'pending' ], true ) && current_user_can( 'manage_options' ) ) {
                        $actions['approve'] = [
                            'action' => 'approve',
                            'name' => esc_html__( 'Approve', 'utillz-core' ),
                            'url' => wp_nonce_url( add_query_arg([ 'action' => 'approve', 'id' => $id ] ), "utillz_payout{$id}" ),
                            'icon' => 'fas fa-check',
                        ];
                    }

                    if( in_array( $status, [ 'pending' ], true ) && current_user_can( 'manage_options' ) ) {
                        $actions['decline'] = [
                            'action' => 'decline',
                            'name' => esc_html__( 'Decline', 'utillz-core' ),
                            'url' => wp_nonce_url( add_query_arg([ 'action' => 'decline', 'id' => $id ] ), "utillz_payout{$id}" ),
                            'icon' => 'fas fa-times',
                        ];
                    }

                    switch( $method ) {
                        case 'paypal':
                            $address_html .= '<div><strong>' . esc_html__( 'Email', 'utillz-core' ) . '</strong>: ' . $address->paypal_email . '</div>';
                            break;
                        case 'bank_transfer':
                            $address_html .= '<div><strong>' . esc_html__( 'Account name', 'utillz-core' ) . '</strong>: ' . $address->bank_account_name . '</div>';
                            $address_html .= '<div><strong>' . esc_html__( 'Account number', 'utillz-core' ) . '</strong>: ' . $address->bank_account_number . '</div>';
                            $address_html .= '<div><strong>' . esc_html__( 'IBAN', 'utillz-core' ) . '</strong>: ' . $address->bank_iban . '</div>';
                            $address_html .= '<div><strong>' . esc_html__( 'BIC / Swift', 'utillz-core' ) . '</strong>: ' . $address->bank_bic . '</div>';
                            $address_html .= '<div><strong>' . esc_html__( 'Bank name', 'utillz-core' ) . '</strong>: ' . $address->bank_name . '</div>';
                            $address_html .= '<div><strong>' . esc_html__( 'Routing number', 'utillz-core' ) . '</strong>: ' . $address->bank_routing_number . '</div>';
                            break;
                    }

                ?>

                <tr>
                    <td>#<?php echo $id; ?></td>
                    <td>
                        <div class="ulz-post-status ulz-status-<?php echo $payout->status; ?>">
                            <span>
                                <?php
                                    switch( $payout->status ) {
                                        case 'pending': esc_html_e( 'Pending', 'utillz-core' ); break;
                                        case 'approved': esc_html_e( 'Approved', 'utillz-core' ); break;
                                        case 'declined': esc_html_e( 'Declined', 'utillz-core' ); break;
                                    }
                                ?>
                            </span>
                        </div>
                    </td>
                    <td><a href="<?php echo esc_url( get_edit_user_link( $userdata->ID ) ); ?>"><?php echo $userdata->display_name; ?></td>
                    <td><?php echo $amount; ?></td>
					<td>
                        <?php
                            switch( $method ) {
                                case 'paypal': esc_html_e( 'PayPal', 'utillz-core' ); break;
                                case 'bank_transfer': esc_html_e( 'Bank transfer', 'utillz-core' ); break;
                            }
                        ?>
                    </td>
					<td><?php echo $address_html; ?></td>
					<td>
                        <div class="ulz-actions">
                            <?php
                                if( $actions ) {
                                    foreach( $actions as $action ) {
                                        if ( is_array( $action ) ) {
                                            printf(
                                                '<a class="button button-icon tips icon-%1$s" href="%2$s" data-tip="%3$s"><i class="%4$s"></i></a>',
                                                esc_attr( $action['action'] ),
                                                esc_url( $action['url'] ),
                                                esc_attr( $action['name'] ),
                                                esc_html( $action['icon'] )
                                            );
                                        }else{
                                            echo wp_kses_post( str_replace( 'class="', 'class="button ', $action ) );
                                        }
                                    }
                                }else{
                                    echo '&dash;';
                                }
                            ?>
                        </div>
                    </td>
                </tr>

            <?php endforeach; ?>

            <?php else: ?>

                <tr>
                    <td class="center" colspan="6"><?php esc_html_e( 'There is no withrawal requests', 'utillz-core' ); ?></td>
                </tr>

            <?php endif; ?>

        </tbody>
        <tfoot>
            <tr>
                <th><strong><?php esc_html_e( 'ID', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Status', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'User', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Amount', 'utillz-core' ); ?></strong></th>
			    <th><strong><?php esc_html_e( 'Method', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Address', 'utillz-core' ); ?></strong></th>
                <th><strong><?php esc_html_e( 'Actions', 'utillz-core' ); ?></strong></th>
            </tr>
        </tfoot>
    </table>
</div>
