<?php

defined('ABSPATH') || exit;

$panel = \UtillzCore\Inc\Src\Admin\Panel::instance();
$panel->form->set( $panel->form::Storage_Meta );

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">
        <div class="ulz-form ulz-grid">
            <?php

                $listing_type_field = $panel->form->create([
                    'type' => 'select',
                    'id' => 'ulz_listing_type',
                    'name' => esc_html__( 'Listing type', 'utillz-core' ),
                    'return_ids' => true,
                    'options' => 'listing-types'
                ]);

                $listing_type = new \UtillzCore\Inc\Src\Listing_Type\Listing_Type( $listing_type_field->props->value );
                $actions = $listing_type->get_action();

                echo $listing_type_field->get();

                if( $listing_type_field->props->value ) {

                    $panel->form->render([
                        'type' => 'tab',
                        'name' => esc_html__( 'General', 'utillz-core' )
                    ]);

                    $items = Ucore()->jsoning( 'ulz_fields', Ucore()->get('ulz_listing_type') );

                    if( $items ) {
                        foreach( $items as $item ) {
                            if( isset( $item->fields->is_admin_page ) && $item->fields->is_admin_page ) {

                                $field = $panel->form->create( $item );

                                if( ! Ucore()->is_error( $field ) ) {
                                    if( $field->id == 'post_title' ) {
                                        $field->props->disabled = true;
                                    }
                                    echo $field->get();
                                }else{
                                    echo $field->get_error();
                                }
                            }
                        }
                    }else{
                        echo '<div class="ulz-form-group ulz-col-12"><div class="ulz-notice ulz-notice-alert">' . esc_html__('No listing fields were found. Please create some by going to Listing Types > ( edit the listing type ) > Listing > Fields', 'utillz-core') . '</div></div>';
                    }

                    /*
                     * pricing
                     *
                     */
                    $action_fields = \UtillzCore\Inc\Src\Listing_Type\Action::get_action_fields( $listing_type );

                    if( $action_fields->allow_pricing ) {

                        $panel->form->render([
                            'type' => 'tab',
                            'name' => esc_html__( 'Pricing', 'utillz-core' )
                        ]);

                        $panel->form->render([
                            'type' => 'number',
                            'id' => 'ulz_price',
                            'name' => esc_html__('Base price', 'utillz-core'),
                            'min' => 0,
                            'step' => 0.01,
                            'required' => boolval( ! $action_fields->allow_not_required_price ),
                        ]);

                        if( $action_fields->allow_extra_pricing ) {

                            $panel->form->render([
                                'type' => 'repeater',
                                'id' => 'ulz_extra_pricing',
                                'name' => esc_html__('Add extra service pricing', 'utillz-core'),
                                'button' => [
                                    'label' => esc_html__('Add service', 'utillz-core')
                                ],
                                'templates' => [

                                    /*
                                     * service
                                     *
                                     */
                                    'service' => [
                                        'name' => esc_html__('Service', 'utillz-core'),
                                        'heading' => 'name',
                                        'fields' => [

                                            'name' => [
                                                'type' => 'text',
                                                'name' => esc_html__('Service name', 'utillz-core'),
                                                'placeholder' => esc_html__('Enter service name', 'utillz-core'),
                                                'col' => 4,
                                            ],
                                            'type' => [
                                                'type' => 'select',
                                                'name' => esc_html__('Service type', 'utillz-core'),
                                                'options' => [
                                                    'single_fee' => esc_html__('Single fee', 'utillz-core'),
                                                ],
                                                'allow_empty' => false,
                                                'col' => 4,
                                            ],
                                            'price' => [
                                                'type' => 'number',
                                                'name' => esc_html__('Service price', 'utillz-core'),
                                                'min' => 0,
                                                'step' => 0.01,
                                                'col' => 4,
                                            ],

                                        ]
                                    ],

                                ]
                            ]);

                        }

                        if( $action_fields->allow_addons ) {

                            $panel->form->render([
                                'type' => 'repeater',
                                'id' => 'ulz_addons',
                                'name' => esc_html__('Add addons', 'utillz-core'),
                                'button' => [
                                    'label' => esc_html__('Add addon', 'utillz-core')
                                ],
                                'templates' => [

                                    /*
                                     * addon
                                     *
                                     */
                                    'addon' => [
                                        'name' => esc_html__('Addon', 'utillz-core'),
                                        'heading' => 'name',
                                        'fields' => [

                                            'name' => [
                                                'type' => 'text',
                                                'name' => esc_html__('Addon name', 'utillz-core'),
                                                'placeholder' => esc_html__('Enter addon name', 'utillz-core'),
                                                'col' => 6,
                                            ],
                                            'price' => [
                                                'type' => 'number',
                                                'name' => esc_html__('Addon price', 'utillz-core'),
                                                'min' => 0,
                                                'step' => 0.01,
                                                'col' => 6,
                                            ],
                                            'key' => [
                                                'type' => 'auto-key',
                                                'name' => esc_html__('Addon Id', 'utillz-core'),
                                            ],

                                        ]
                                    ],

                                ]
                            ]);

                        }

                    }

                }

            ?>

            <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                <button type="submit" class="ulz-button ulz--large">
                    <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                </button>
            </div>

        </div>
    </div>
</div>
