<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Listing\Conversation;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Admin\Panel;

global $post;

$panel = Panel::instance();
$panel->form->set( $panel->form::Storage_Meta );

$listing_id = Ucore()->get('ulz_listing_id');
$listing = new Listing( $listing_id );
$users = get_post_meta( get_the_ID(), 'ulz_user_id' );

$conversation = new Conversation( get_the_ID() );
$messages = $conversation->get_messages('desc');

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">
        <div class="ulz-form">
            <table class="ulz-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'General details', 'utillz-core' ); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if( $listing->id ): ?>
                        <tr>
                            <td><?php esc_html_e( 'Listing', 'utillz-core' ); ?></td>
                            <td><a href="<?php echo get_edit_post_link( $listing->id ); ?>"><?php echo get_the_title( $listing_id ); ?></a></td>
                        </tr>
                    <?php endif; ?>
                    <?php if( is_array( $users ) ): ?>
                        <tr>
                            <td><?php esc_html_e( 'Users', 'utillz-core' ); ?></td>
                            <td>
                                <?php foreach( $users as $key => $user_id ): ?>
                                    <?php $userdata = get_userdata( $user_id ); ?>
                                    <?php if( $userdata instanceof \Wp_User ): ?>
                                        <a href="<?php echo esc_url( get_edit_user_link( $user_id ) ); ?>"><?php echo esc_html( $userdata->display_name ); ?></a><?php if( $key == 0 ): ?>, <?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <?php if( ! empty( $messages ) && is_array( $messages ) ): ?>
                <table class="ulz-table ulz-mt-4">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Conversation', 'utillz-core' ); ?></th>
                            <th>&nbsp;</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $last_date = null; ?>
                        <?php foreach( $messages as $message ): ?>
                            <?php $usr = get_userdata( $message->sender_id ); ?>
                            <tr>
                                <td>
                                    <?php $offset = get_option('gmt_offset') * HOUR_IN_SECONDS; ?>
                                    <?php echo '<strong>' . esc_html( $usr->display_name ) . '</strong> — ' . date_i18n( sprintf('%s %s', get_option('date_format'), get_option('time_format') ), strtotime( $message->created_utc ) + $offset ); ?>
                                </td>
                                <td>
                                    <?php
                                        echo wp_kses( wpautop( stripslashes( $message->text ) ), [
                                            'a' => [
                                                'href' => [],
                                                'title' => []
                                            ],
                                            'br' => [],
                                            'em' => [],
                                            'p' => [],
                                            'strong' => []
                                        ]);
                                    ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <tr>
                    <td><?php esc_html_e( 'No messages', 'utillz-core' ); ?></td>
                    <td>&nbsp;</td>
                </tr>
            <?php endif; ?>

        </div>
    </div>
</div>
