<?php

namespace UtillzCore\Templates\Admin\Metabox;

use \UtillzCore\Templates\Admin\Metabox\Field_Column_Sizes;

class Application_Fields {

    static public function get() {
        return [
            'type' => 'repeater',
            'name' => esc_html__('Application form fields', 'utillz-core'),
            'description' => esc_html__('Create your application form. Specify all the fields that you need to display on the front-end.', 'utillz-core'),
            'button' => [
                'label' => esc_html__('Add form field', 'utillz-core')
            ],
            'templates' => [

                // text
                'text' => [
                    'name' => esc_html__('Text', 'utillz-core'),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'value' => esc_html__( 'Field name', 'utillz-core' ),
                        ],
                        'key' => [
                            'type' => 'auto-key',
                        ],
                        'placeholder' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'required' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Required field', 'utillz-core' ),
                        ],
                        'show_if_guest' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Show only when the user is not logged in', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                // textarea
                'textarea' => [
                    'name' => esc_html__('Textarea', 'utillz-core'),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'value' => esc_html__( 'Field name', 'utillz-core' ),
                        ],
                        'key' => [
                            'type' => 'auto-key',
                        ],
                        'placeholder' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'required' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Required field', 'utillz-core' ),
                        ],
                        'show_if_guest' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Show only when the user is not logged in', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                // checkbox
                'checkbox' => [
                    'name' => esc_html__( 'Checkbox', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'value' => esc_html__( 'Field name', 'utillz-core' ),
                        ],
                        'key' => [
                            'type' => 'auto-key',
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                        ],
                        'required' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Required field', 'utillz-core' ),
                        ],
                        'show_if_guest' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Show only when the user is not logged in', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                            'col' => 6
                        ]
                    ]
                ],

                // selection
                'choice' => [
                    'name' => esc_html__( 'Selection', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'value' => esc_html__( 'Field name', 'utillz-core' ),
                        ],
                        'key' => [
                            'type' => 'auto-key',
                        ],
                        'choice' => [
                            'type' => 'hidden',
                            'value' => 'select'
                        ],
                        'options' => [
                            'type' => 'options',
                            'name' => esc_html__( 'Options', 'utillz-core' ),
                        ],
                        'required' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Required field', 'utillz-core' ),
                        ],
                        'show_if_guest' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Show only when the user is not logged in', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                            'col' => 6
                        ]
                    ]
                ],

                // upload
                'upload' => [
                    'name' => esc_html__( 'Upload', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'value' => esc_html__( 'Field name', 'utillz-core' ),
                        ],
                        'key' => [
                            'type' => 'auto-key',
                        ],
                        'multiple_upload' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Allow multiple uploads?', 'utillz-core' ),
                        ],
                        'upload_type' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Upload type', 'utillz-core' ),
                            'value' => 'image',
                            'options' => [
                                'image' => esc_html__( 'Image', 'utillz-core' ),
                                'file' => esc_html__( 'File', 'utillz-core' ),
                            ],
                            'allow_empty' => false,
                        ],
                        'required' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Required field', 'utillz-core' ),
                        ],
                        'show_if_guest' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Show only when the user is not logged in', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                            'col' => 6
                        ]
                    ]
                ],

            ],
        ];
    }
}
