<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Wallet;
use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Form\Component as Form;

$request = Request::instance();
$form = new Form( Form::Storage_Request );

$page = $request->has('onpage') ? $request->get('onpage') : 1;

$user = null;
if( ! $request->is_empty('user_email') ) {
    $user = get_user_by( 'email', $request->get('user_email') );
}


?>

<div class="ulz-meta-container ulz-container-left">
    <h1><?php esc_html_e( 'Earnings', 'utillz-core' ); ?></h1>
</div>

<div class="ulz-outer ulz-panel" style="max-width: 50%;">
    <div class="ulz-section" style="padding: 1.5rem .75rem;">
        <div class="ulz-grid ulz-no-gutter">
            <div class="ulz-col-6">

                <form method="get">
                    <div class="ulz-form">

                        <?php

                            $form->render([
                                'type' => 'hidden',
                                'id' => 'page',
                                'value' => 'ulz_earnings',
                            ]);

                            $form->render([
                                'type' => 'tab',
                                'id' => 'tab_user',
                                'name' => esc_html__('User', 'utillz-core'),
                            ]);

                            $form->render([
                                'type' => 'text',
                                'id' => 'user_email',
                                'name' => esc_html__('Search by user email', 'utillz-core'),
                                'placeholder' => esc_html__('Email', 'utillz-core'),
                            ]);

                        ?>

                        <div class="ulz-form-group ulz-col-12 ulz-mb-0">
                            <button type="submit" class="ulz-button ulz--large">
                                <span><?php esc_html_e( 'Search', 'utillz-core' ); ?></span>
                            </button>
                        </div>

                    </div>
                </form>

            </div>
            <?php if( isset( $user->ID ) ): ?>
                <div class="ulz-col-6">

                    <form method="post">
                        <div class="ulz-form">

                                <?php

                                    $form->render([
                                        'type' => 'tab',
                                        'id' => 'tab_transaction',
                                        'name' => esc_html__('Add new transaction', 'utillz-core'),
                                    ]);

                                    $form->render([
                                        'type' => 'hidden',
                                        'id' => 'user_email',
                                    ]);

                                    $form->render([
                                        'type' => 'select',
                                        'id' => 'type',
                                        'name' => esc_html__('Transaction type', 'utillz-core'),
                                        'options' => [
                                            'credit' => esc_html__('Credit (+)', 'utillz-core'),
                                            'debit' => esc_html__('Debit (-)', 'utillz-core'),
                                        ],
                                    ]);

                                    $form->render([
                                        'type' => 'number',
                                        'id' => 'amount',
                                        'name' => esc_html__('Transaction amount', 'utillz-core'),
                                        'placeholder' => esc_html__('0.00', 'utillz-core'),
                                        'min' => 0,
                                        'step' => 0.01,
                                    ]);

                                ?>

                                <?php if( $request->get('success') == 'no' && $request->get('msg') ): ?>
                                    <div class="ulz-form-group ulz-col-12 ulz-mt-3 ulz-mb-0">
                                        <strong style="color:red;"><?php echo esc_html( $request->get('msg') ); ?></strong>
                                    </div>
                                <?php endif; ?>

                                <?php if( $request->get('success') == 'yes' && $request->get('msg') ): ?>
                                    <div class="ulz-form-group ulz-col-12 ulz-mt-3 ulz-mb-0">
                                        <strong style="color:green;"><?php echo esc_html( $request->get('msg') ); ?></strong>
                                    </div>
                                <?php endif; ?>

                                <div class="ulz-form-group ulz-col-12 ulz-mt-3 ulz-mb-0">
                                    <button type="submit" class="ulz-button ulz--large">
                                        <span><?php esc_html_e( 'Add transaction', 'utillz-core' ); ?></span>
                                    </button>
                                </div>

                        </div>
                    </form>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if( ! $request->is_empty('user_email') && ! isset( $user->ID ) ): ?>
    <h3 class="ulz-mt-3"><strong><?php esc_html_e('This user was not found.', 'utillz-core'); ?></strong></h3>
<?php endif; ?>

<?php if( isset( $user->ID ) ): ?>

    <?php

    $wallet = new Wallet( $user->ID );
    $transactions = $wallet->get_translations();
    $userdata = get_userdata( $user->ID );

    ?>

    <div class="ulz-outer ulz-panel ulz-mt-4 ulz-mb-4" style="max-width: 50%;">
        <aside class="ulz-section">
            <table class="ulz-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('User details', 'utillz-core'); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php esc_html_e('Display name', 'utillz-core'); ?></td>
                        <td><?php echo esc_html( $userdata->display_name ); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Current balance', 'utillz-core'); ?></td>
                        <td><?php echo Ucore()->format_price( floor( $wallet->get_balance() * 100 ) / 100 ); ?></td>
                    </tr>
                </tbody>
            </table>
        </aside>
    </div>

    <?php if( $transactions->max_num_pages > 1 ): ?>
        <div class="ulz-outer ulz-mt-4 ulz-mb-4">
            <div class="ulz-paging">
                <?php

                    echo Ucore()->pagination([
                        'base' => add_query_arg([ 'onpage' => '%#%' ], "users.php?page=ulz_earnings&user_email={$request->get('user_email')}"),
                        'format' => '?onpage=%#%',
                        'current' => $page,
                        'total' => $transactions->max_num_pages,
                    ]);

                ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="wrap">
        <table class="wp-list-table widefat striped">
            <thead>
                <tr>
                    <th><strong><?php esc_html_e( 'ID', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Type', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Order ID', 'utillz-core' ); ?></strong></th>
    			    <th><strong><?php esc_html_e( 'Source', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Amount', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Date', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Actions', 'utillz-core' ); ?></strong></th>
                </tr>
            </thead>
            <tbody>

                <?php if( $transactions->results ): ?>

                    <?php foreach( $transactions->results as $transaction ): ?>

                        <?php

                        // dd( $transaction );

                        $id = (int) $transaction->id;
                        $type = $transaction->type;
                        $order_id = $transaction->order_id;
                        $source = $transaction->source;
    					$date = $transaction->created_at;

                        $actions = [];

                        if( current_user_can( 'manage_options' ) ) {
                            $actions['delete'] = [
                                'action' => 'delete',
                                'name' => esc_html__( 'Delete', 'utillz-core' ),
                                'url' => wp_nonce_url( add_query_arg([ 'action' => 'delete', 'id' => $id ] ), "utillz_transaction{$id}" ),
                                'icon' => 'fas fa-times',
                                'conformation_msg' => esc_html__( 'Are you sure you want to delete this item?', 'utillz-core' ),
                            ];
                        }

                    ?>

                    <tr>
                        <td>#<?php echo $id; ?></td>
                        <td><?php echo esc_html( $type ); ?></td>
                        <td><?php echo isset( $order_id ) ? esc_html( $order_id ) : '-'; ?></td>
                        <td><?php echo esc_html( $source ); ?></td>
                        <td><?php echo Ucore()->format_price( $transaction->amount ); ?></td>
                        <td><?php echo esc_html( $date ); ?></td>
    					<td>
                            <div class="ulz-actions">
                                <?php
                                    if( $actions ) {
                                        foreach( $actions as $action ) {
                                            if ( is_array( $action ) ) {
                                                printf(
                                                    '<a class="button button-icon tips icon-%1$s" href="%2$s" data-action="action-confirmation" data-confirmation-msg="%5$s" data-tip="%3$s"><i class="%4$s"></i></a>',
                                                    esc_attr( $action['action'] ),
                                                    esc_url( $action['url'] ),
                                                    esc_attr( $action['name'] ),
                                                    esc_html( $action['icon'] ),
                                                    esc_html( $action['conformation_msg'] )
                                                );
                                            }else{
                                                echo wp_kses_post( str_replace( 'class="', 'class="button ', $action ) );
                                            }
                                        }
                                    }else{
                                        echo '&dash;';
                                    }
                                ?>
                            </div>
                        </td>
                    </tr>

                <?php endforeach; ?>

                <?php else: ?>

                    <tr>
                        <td class="center" colspan="7"><?php esc_html_e( 'There are no transactions', 'utillz-core' ); ?></td>
                    </tr>

                <?php endif; ?>

            </tbody>
            <tfoot>
                <tr>
                    <th><strong><?php esc_html_e( 'ID', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Type', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Order ID', 'utillz-core' ); ?></strong></th>
    			    <th><strong><?php esc_html_e( 'Source', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Amount', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Date', 'utillz-core' ); ?></strong></th>
                    <th><strong><?php esc_html_e( 'Actions', 'utillz-core' ); ?></strong></th>
                </tr>
            </tfoot>
        </table>
    </div>

<?php endif; ?>
