<?php

use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Notification\Base as Notification;

$form = new Form( Form::Storage_Field );
$current_user_id = get_current_user_id();
$notif_count = 0;

do_action('utillz/account/notifications/update');

?>

<p><?php esc_html_e( 'Disable or enable the notifications that you want to receive', 'utillz-core' ); ?></p>

<form method="post" autocomplete="off">
    <div class="ulz-form">
        <div class="ulz-grid">
            <?php foreach( Notification::get_notifications() as $base => $namespace ): ?>

                <?php

                    $notification = new $namespace;

                    // site disabled
                    if( ! $notification->is_site_enabled() ) {
                        continue;
                    }

                    // notification is not managable by the users
                    if( ! $notification->user_can_manage ) {
                        continue;
                    }

                    $notif_count++;

                    $form->render([
                        'type' => 'checkbox',
                        'id' => sprintf( 'ulz_is_user_notification_%s', $notification->get_id() ),
                        'name' => $notification->get_name(),
                        'value' => ! get_user_meta( $current_user_id, sprintf( 'ulz_is_user_notification_%s', $notification->get_id() ), true ),
                        'html' => [
                            'text' => esc_html__( 'Enable', 'utillz-core' )
                        ],
                        'col' => 4
                    ]);

                ?>

            <?php endforeach; ?>

            <?php if( ! $notif_count ): ?>
                <div class="ulz-form-group ulz-col-12 ulz-mb-0">
                    <p><strong><?php esc_html_e( 'No notification were found.', 'utillz-core' ); ?></strong></p>
                </div>
            <?php endif; ?>

            <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                <button type="submit" class="ulz-button ulz-button-accent ulz--large">
                    <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                </button>
            </div>

        </div>
    </div>
</form>
