<?php

use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Listing\Views;

defined('ABSPATH') || exit;

global $wpdb;

$listing = new Listing();
$views = new Views( $listing->id );
$status = $listing->get_status();
$image = $listing->get_first_from_gallery( 'thumbnail' );
$promotions_enabled = $listing->type->get('ulz_enable_promotions');
$promoted_expiration = (int) Ucore()->get( 'ulz_promotion_expires' );
$promotion_packages = $listing->type->get_wc_promotions();
$expires = Ucore()->get('ulz_listing_expires');
// $rating_average = $listing->get('ulz_review_rating_average');
$comments_num = (int) $wpdb->get_var( $wpdb->prepare("
	SELECT COUNT( comment_ID )
	FROM {$wpdb->comments}
	WHERE comment_post_ID = %d
	AND comment_type = 'ulz-review'
	AND comment_parent = 0
", $listing->id ) );

$action = $listing->get_action();

?>

<div class="ulz--cell">
    <div class="ulz-box">
        <div class="ulz--heading">
            <div class="ulz--image">
                <a href="<?php the_permalink(); ?>">
                    <?php if( $image ): ?>
                        <?php echo '<img src="' . esc_url( $image ) . '" alt="">'; ?>
                    <?php else: ?>
                        <?php echo Ucore()->dummy( 'fas fa-map-marker-alt', 'font-awesome', 100 ); ?>
                    <?php endif; ?>
                </a>
            </div>
            <div class="ulz--title">
                <h4>
                    <a href="<?php the_permalink(); ?>">
                        <?php echo wp_trim_words( get_the_title(), 8 ); ?>
                    </a>
                </h4>
            </div>
        </div>
        <div class="ulz--status">
            <div class="ulz-post-status ulz-status-<?php echo $status; ?>">
                <span><?php echo Ucore()->get_status(); ?></span>
            </div>
        </div>
        <div class="ulz--content">
            <table>
                <tbody>
                    <tr>
                        <td><?php esc_html_e( 'Type', 'utillz-core' ); ?></td>
                        <td><?php echo esc_html( $listing->type->get('ulz_name') ); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e( 'Created', 'utillz-core' ); ?></td>
                        <td><?php echo get_the_date(); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e( 'Expires', 'utillz-core' ); ?></td>
                        <td><?php echo $expires ? date_i18n( get_option( 'date_format' ), strtotime( $expires ) ) : '-'; ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e( 'Rated', 'utillz-core' ); ?></td>
                        <?php if( $listing->reviews->average && $comments_num ): ?>
                            <td><?php echo sprintf( esc_html__( '%s out of %s reviews', 'utillz-core' ), $listing->reviews->average, $comments_num ); ?></td>
                        <?php else: ?>
                            <td>-</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <td><?php esc_html_e( 'Today views', 'utillz-core' ); ?></td>
                        <td><?php echo $views->get_today_views(); ?></td>
                    </tr>
                    <?php if( $promoted_expiration ): ?>
                        <tr>
                            <td><?php esc_html_e( 'Promotion expires', 'utillz-core' ); ?></td>
                            <td><?php echo date( get_option('date_format'), $promoted_expiration ); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="ulz--actions">
            <div class="ulz--primary-actions">
                <ul>
                    <li>
                        <a href="#" data-modal="listing-edit" data-params="<?php echo (int) $listing->id; ?>">
							<i class="fas fa-pen"></i>
						</a>
                    </li>
                    <?php
                        $action_url = add_query_arg([
                            'action' => 'delete_listing',
                            'id' => get_the_ID()
                        ]);
                        $action_url = wp_nonce_url( $action_url, 'utillz_account_listing_action' );
                    ?>
                    <li>
                        <a href="<?php echo esc_url( $action_url ); ?>" data-action="account-listing-delete" data-confirmation="<?php esc_html_e('Are you sure you want to delete this item?', 'utillz-core'); ?>">
							<i class="fas fa-trash-alt"></i>
						</a>
                    </li>
                </ul>
            </div>
            <div class="ulz--more-actions">
                <?php if( $promotions_enabled ): ?>
                    <?php if( $promotion_packages && $listing->post->post_status == 'publish' ): ?>
                        <?php if( $promoted_expiration ): ?>
                            <a href="#" class="ulz-button ulz--mutted">
                                <i class="fas fa-fire-alt ulz-mr-1"></i>
                                <?php esc_html_e( 'Promoted', 'utillz-core' ) ?>
                            </a>
                        <?php else: ?>
                            <a href="#" class="ulz-button" data-modal="promote" data-params="<?php the_ID(); ?>">
                                <i class="fas fa-fire-alt ulz-mr-1"></i>
                                <?php esc_html_e( 'Promote', 'utillz-core' ) ?>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
