<?php

use \UtillzCore\Inc\Src\Request\Request;

defined('ABSPATH') || exit;

$listings = \UtillzCore\Inc\Src\Woocommerce\Account\Account::get_listings();
$request = Request::instance();
$page = $request->has('onpage') ? $request->get('onpage') : 1;

?>

<?php if( $listings->have_posts() ): ?>
    <div class="ulz-boxes">
        <?php while( $listings->have_posts() ) : $listings->the_post(); ?>
            <?php Ucore()->the_template('account/listings/row'); ?>
        <?php endwhile; wp_reset_postdata(); ?>
    </div>
<?php else: ?>
    <p><?php esc_html_e( 'No listings were found', 'utillz-core' ); ?></p>
<?php endif; ?>

<div class="ulz-paging">
    <?php

        echo Ucore()->pagination([
            'base' => add_query_arg( [ 'onpage' => '%#%' ], wc_get_account_endpoint_url( 'listings' ) ),
            'format' => '?onpage=%#%',
            'current' => $page,
            'total' => $listings->max_num_pages,
        ]);

    ?>
</div>

<?php Ucore()->the_template('modals/listing-edit/content'); ?>
<?php Ucore()->the_template('modals/promote/content'); ?>
