<?php

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Listing\Conversation;

defined('ABSPATH') || exit;

$request = Request::instance();
$listing = new Listing( Ucore()->get('ulz_listing') );

$status = get_post_status( get_the_ID() );
$entry_type = Ucore()->get( 'ulz_entry_type' );
$image = $listing->get_first_from_gallery( 'thumbnail' );
$request_user_id = Ucore()->get( 'ulz_request_user_id' );
$current_user_id = get_current_user_id();
$conversation_id = null;
$userdata = get_userdata( $request_user_id );

if( $listing->id ) {
    $reciever_id = ( $request_user_id == $current_user_id ) ? $listing->post->post_author : $current_user_id;
    $conversation_id = Conversation::get_or_create_by_user_id( $listing->id, $request_user_id, $reciever_id );
}

if( $listing->type ) {
    $review_submission = $listing->type->get('ulz_review_submission');
    if( empty( $review_submission ) ) {
        $review_submission = 'everyone';
    }
}

?>

<div class="ulz--cell">
    <div class="ulz-box">
        <?php if( $listing->post ): ?>
            <div class="ulz--heading">
                <div class="ulz--image">
                    <?php $tag = $listing->post->post_status == 'publish' ? 'a' : 'span'; ?>
                    <<?php echo esc_attr( $tag ); ?> href="<?php the_permalink( $listing->id ); ?>">
                        <?php if( $image ): ?>
                            <?php echo '<img src="' . esc_url( $image ) . '" alt="">'; ?>
                        <?php else: ?>
                            <?php echo Ucore()->dummy( 'fas fa-map-marker-alt', 'font-awesome', 100 ); ?>
                        <?php endif; ?>
                    </<?php echo esc_attr( $tag ); ?>>
                </div>
                <div class="ulz--title">
                    <h4>
                        <<?php echo esc_attr( $tag ); ?> href="<?php the_permalink( $listing->id ); ?>">
                            <?php echo wp_trim_words( get_the_title( $listing->id ), 8 ); ?>
                        </<?php echo esc_attr( $tag ); ?>>
                    </h4>
                </div>
            </div>
        <?php endif; ?>
        <div class="ulz--status">
            <div class="ulz-post-status ulz-status-<?php echo $status; ?>">
                <span><?php echo Ucore()->get_status(); ?></span>
            </div>
        </div>
        <div class="ulz--content">
            <table>
                <tbody>
                    <tr>
                        <td><?php esc_html_e( 'Type', 'utillz-core' ); ?></td>
                        <td><?php echo esc_html( Ucore()->get_entry_type( Ucore()->get( 'ulz_entry_type' ) ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e( 'Date', 'utillz-core' ); ?></td>
                        <td><?php echo get_the_date( sprintf('%s %s', get_option('date_format'), get_option('time_format') ) ); ?></td>
                    </tr>
                    <?php if( $request->get('type') == 'sent' ): ?>
                        <?php $owner = get_userdata( $listing->post->post_author ); ?>
                        <?php if( isset( $owner->display_name ) ): ?>
                            <tr>
                                <td><?php esc_html_e( 'Sent to', 'utillz-core' ); ?></td>
                                <td><?php echo esc_html( $owner->display_name ); ?></td>
                            </tr>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if( isset( $userdata->display_name ) ): ?>
                            <tr>
                                <td><?php esc_html_e( 'User', 'utillz-core' ); ?></td>
                                <td><?php echo esc_html( $userdata->display_name ); ?></td>
                            </tr>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if( $entry_type == 'purchase' ): ?>
                        <?php $pricing = Ucore()->json_decode( Ucore()->get('ulz_pricing') ); ?>
                        <?php if( $pricing ): ?>
                            <?php if( isset( $pricing->total ) ): ?>
                                <tr>
                                    <td><?php esc_html_e( 'Total', 'utillz-core' ); ?></td>
                                    <td><?php echo Ucore()->format_price( $pricing->total ); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if( isset( $pricing->processing ) ): ?>
                                <tr>
                                    <td><?php esc_html_e( 'Total payed', 'utillz-core' ); ?></td>
                                    <td><?php echo Ucore()->format_price( $pricing->processing ); ?></td>
                                </tr>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if( $listing->id ): ?>
            <div class="ulz--actions">
                <div class="ulz--primary-actions">
                    <ul>
                        <?php if( (int) $conversation_id > 0 ): ?>
                            <li>
                                <a href="#" class="ulz--toggle-active" data-modal="conversation" data-params='{"id":<?php echo (int) $conversation_id; ?>}'>
                                    <i class="fas fa-comment"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if( $entry_type == 'purchase' ): ?>
                            <li>
                                <a href="#" data-modal="entry-edit" data-params='{"id":<?php the_ID(); ?>}'>
                                    <i class="fas fa-pen"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if( $status == 'publish' && ( $review_submission == 'engaged' || $review_submission == 'everyone' ) && $request_user_id == get_current_user_id() ): ?>
                            <li>
                                <a href="#" data-modal="review-submit" data-params='<?php echo (int) $listing->id; ?>'>
                                    <i class="fas fa-star"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <?php if( $entry_type == 'application' ): ?>
                    <div class="ulz--more-actions">
                        <a href="#" class="ulz-button" data-modal="entry-edit" data-params='{"id":<?php the_ID(); ?>}'>
                            <i class="fas fa-eye ulz-mr-1"></i>
                            <?php esc_html_e( 'View', 'utillz-core' ) ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
