<?php

class Widget_Listings extends WP_Widget {

    function __construct() {

        parent::__construct(
            'utillz-widget-listings',
            'Utillz Listings'
        );

        add_action( 'widgets_init', function() {
            register_widget( 'Widget_Listings' );
        });

    }

    public $args = [
        'before_title'  => '<h4 class="ulz--title">',
        'after_title'   => '</h4>',
        'before_widget' => '<div class="ulz-widget-wrap">',
        'after_widget'  => '</div>'
    ];

    public function widget( $args, $instance ) {

        echo $args['before_widget'];

        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

        global $wpdb, $ulz_widget_listing_post_ids;

        if( ! is_array( $ulz_widget_listing_post_ids ) ) {
            $ulz_widget_listing_post_ids = [];
        }

        /*
         * get listing posts
         *
         */

        if( $instance['ulz_sorting'] == 'top-rated' ) {

            $listings = $wpdb->get_results(
                $wpdb->prepare("
                    SELECT *
                    FROM {$wpdb->posts}, {$wpdb->options} as o
                    WHERE {$wpdb->posts}.post_type = 'ulz_listing'
                    AND {$wpdb->posts}.post_status = 'publish'
                    AND o.option_name LIKE CONCAT( '_transient_ulz_reviews_average_%', {$wpdb->posts}.ID )
                    GROUP BY {$wpdb->posts}.ID
                    ORDER BY option_value DESC
                    LIMIT %d
                ", (int) $instance['ulz_num_listings'] )
            );

        }elseif( $instance['ulz_sorting'] == 'favorites' ) {

            $listings = $wpdb->get_results(
                $wpdb->prepare("
                    SELECT *, SUM( count ) as total_views
                    FROM {$wpdb->posts}
                        LEFT JOIN {$wpdb->prefix}utillz_views
                        ON {$wpdb->posts}.ID = {$wpdb->prefix}utillz_views.listing_id
                    WHERE {$wpdb->posts}.post_type = 'ulz_listing'
                    AND {$wpdb->prefix}utillz_views.datetime > DATE_SUB( NOW(), INTERVAL 7 DAY )
                    GROUP BY {$wpdb->posts}.ID
                    ORDER BY total_views DESC
                    LIMIT %d
                ", (int) $instance['ulz_num_listings'] )
            );

        }else{

            $meta_query = [];
            if( $instance['ulz_listing_type'] ) {
                $meta_query = [
                    'relation' => 'AND',
                    [
                        'key' => 'ulz_listing_type',
                        'value' => (int) $instance['ulz_listing_type'],
                        'compare' => '=',
                    ]
                ];
            }

            $query_args = [
                'post_type' => 'ulz_listing',
                'post_status' => 'publish',
                'posts_per_page' => (int) $instance['ulz_num_listings'],
                'meta_query' => $meta_query,
                'post__not_in' => $ulz_widget_listing_post_ids
            ];

            $query_args['meta_query'] = $meta_query;
            $listings = get_posts( $query_args );

        }

        ?>

        <div class="ulz-widget-listings">
            <?php if( $listings ): ?>
                <ul>
                    <?php foreach( $listings as $post ): ?>
                        <?php $ulz_widget_listing_post_ids[] = $post->ID; ?>
                        <?php $listing = new \UtillzCore\Inc\Src\Listing\Listing( $post->ID ); ?>
                        <li>
                            <a href="<?php echo get_permalink( $post->ID ); ?>">
                                <?php $image = $listing->get_first_from_gallery( 'thumbnail' ); ?>
                                <?php if( $image ): ?>
                                    <div class="ulz--image">
                                        <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_html( get_the_title( $post->ID ) ); ?>">
                                    </div>
                                <?php endif; ?>
                                <div class="ulz--content">

                                    <p class="ulz--name"><?php echo get_the_title( $post->ID ); ?></p>

                                    <?php
                                        if( $instance['ulz_sorting'] == 'top-rated' ) {

                                            if( $listing->reviews->average ): ?>
                                                <div class="ulz--review">
                                                    <i class="fas fa-star"></i>
                                                    <span><?php echo number_format( $listing->reviews->average, 2 ); ?></span>
                                                </div>
                                            <?php endif;

                                        }else{

                                            $geo_city = $listing->get('ulz_location__geo_city');

                                            if( empty( $geo_city ) ) {
                                                $geo_city = $listing->get('ulz_location__geo_city_alt');
                                            }

                                            if( $geo_city ): ?>
                                                <div class="ulz--geo">
                                                    <?php echo esc_html( $geo_city ); ?>
                                                </div>
                                            <?php endif;

                                        }
                                    ?>
                                </div>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p><?php esc_html_e( 'No results were found.', 'utillz-core' ) ?></p>
            <?php endif; ?>
        </div>

        <?php

        echo $args['after_widget'];

    }

    public function form( $instance ) {

        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $listing_type = ! empty( $instance['ulz_listing_type'] ) ? $instance['ulz_listing_type'] : 0;
        $sorting = ! empty( $instance['ulz_sorting'] ) ? $instance['ulz_sorting'] : 'latest';
        $num_listings = ! empty( $instance['ulz_num_listings'] ) ? $instance['ulz_num_listings'] : 3;

        $types = get_posts([
            'post_type' => 'ulz_listing_type',
            'post_status' => 'publish',
            'numberposts' => -1,
        ]);

        ?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo esc_html__( 'Title:', 'utillz-core' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'ulz_listing_type' ) ); ?>"><?php echo esc_html__( 'Select listing type (optional):', 'utillz-core' ); ?></label>
                <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'ulz_listing_type' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'ulz_listing_type' ) ); ?>">
                    <option value=""><?php esc_html_e('Select', 'utillz-core'); ?></option>
                    <?php if( $types ): ?>
                        <?php foreach( $types as $type ): ?>
                            <option value="<?php echo (int) $type->ID; ?>" <?php if( $type->ID == $listing_type ) { echo 'selected="selected"'; } ?>>
                                <?php echo esc_html( Ucore()->get('ulz_name_plural', $type->ID) ); ?>
                            </option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'ulz_sorting' ) ); ?>"><?php echo esc_html__( 'Sort by:', 'utillz-core' ); ?></label>
                <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'ulz_sorting' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'ulz_sorting' ) ); ?>">
                    <option value="latest" <?php if( $sorting == 'latest' ) { echo 'selected="selected"'; } ?>><?php esc_html_e('Latest', 'utillz-core'); ?></option>
                    <option value="top-rated" <?php if( $sorting == 'top-rated' ) { echo 'selected="selected"'; } ?>><?php esc_html_e('Top rated', 'utillz-core'); ?></option>
                    <option value="favorites" <?php if( $sorting == 'favorites' ) { echo 'selected="selected"'; } ?>><?php esc_html_e('Favorites', 'utillz-core'); ?></option>
                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'ulz_num_listings' ) ); ?>"><?php echo esc_html__( 'Number of listings:', 'utillz-core' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'ulz_num_listings' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'ulz_num_listings' ) ); ?>" type="number" min="1" max="10" value="<?php echo (int) $num_listings; ?>">
            </p>
        <?php

    }

    public function update( $new_instance, $old_instance ) {

        $instance = [];

        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['ulz_listing_type'] = ( ! empty( $new_instance['ulz_listing_type'] ) ) ? $new_instance['ulz_listing_type'] : '';
        $instance['ulz_sorting'] = ( ! empty( $new_instance['ulz_sorting'] ) ) ? $new_instance['ulz_sorting'] : 'latest';
        $instance['ulz_num_listings'] = ( ! empty( $new_instance['ulz_num_listings'] ) ) ? strip_tags( $new_instance['ulz_num_listings'] ) : '';

        return $instance;

    }

}

new Widget_Listings();
