<div class="ulz-submission-heading">
    <h4 class="ulz--title">{{ $strings->select_plan }}</h4>
</div>

<form>
    <div class="ulz-select-plan">
        <div class="ulz-plans ulz-grid ulz-no-select">

            @if( $products )
                @foreach( $products as $product )
                    @php
                        $plan = new \UtillzCore\Inc\Src\Woocommerce\Packages\Plan( $product->get_id() );
                        $type = $product->get_type();
                        $availability = $plan->availability();
                        $short_desc = $product->get_short_description();
                    @endphp
                    <div class="ulz-col-6 ulz-col-md-12 ulz-mb-3 ulz-flex">
                        <label>
                            <input type="radio" name="ulz_plan" value="{{ $product->get_id() }}">
                            <span class="ulz-plan ulz--plan-type-{{ $type }} @if( $product->get_featured() ) ulz-highlight @endif @if( $availability && $plan->is_purchasable() ) ulz-has-available @endif ">
                                @if( $product->get_featured() )
                                    <span class="ulz--badge">{{ $strings->most_popular }}</span>
                                @endif
                                @if( $availability && $plan->is_purchasable() )
                                    <div class="ulz-available">
                                        <span><i class="fas fa-certificate ulz-mr-1"></i>{{ $strings->owned }}:</span>
                                        @if( $availability == 'unlimited' )
                                            <span>{{ $strings->unlimited }}</span>
                                        @else
                                            <span><?php echo sprintf( _n( $strings->available_submission, $strings->available_submissions, $availability, 'utillz-core' ), $availability ); ?></span>
                                        @endif
                                    </div>
                                @endif
                                <span class="ulz-heading">
                                    @if( $product->get_price_html() )
                                        <span class="ulz-price">
                                            <p>{!! $product->get_price_html() !!}</p>
                                        </span>
                                    @endif
                                    <span class="ulz--name">{{ $product->get_name() }}</span>
                                    @if( $short_desc )
                                        <span class="ulz--desc">{{ $short_desc }}</span>
                                    @endif
                                </span>
                                <span class="ulz-content">
                                    {!! do_shortcode( $product->get_description() ) !!}
                                </span>
                                <span class="ulz-action">
                                    <span class="ulz-button {{ $product->get_featured() ? 'ulz-button-accent' : 'ulz-white-gray' }}">
                                        <i>{{ $strings->select_plan }}</i>
                                    </span>
                                </span>
                            </span>
                        </label>
                    </div>
                @endforeach
            @else
                <div class="ulz-col-12">
                    <div class="ulz-notice ulz-notice-alert">
                        <p>
                            {{ $strings->no_packages }}
                        </p>
                    </div>
                </div>
            @endif

        </div>
        <p class="ulz-select-plan-error ulz-text-center">
            <span class="ulz-error"></span>
        </p>
    </div>
</form>
