<?php

namespace UtillzCore\Inc\Src\Submission\Modules\Publish;

use \UtillzCore\Inc\Src\Submission\Submission;
use \UtillzCore\Inc\Src\Submission\Modules\Module;
use \UtillzCore\Inc\Src\Request\Custom_Request;
use \UtillzCore\Inc\Src\Request\Raw_Request;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Validation;
use \UtillzCore\Inc\Src\Woocommerce\Packages\Plan;
use \UtillzCore\Inc\Src\Listing\Listing;

class Publish extends Module {

    public function controller() {
        return [
            'strings' => (object) [
                'about_publish' => esc_html__('You are about to publish', 'utillz-core'),
                'confirm' => esc_html__('Are you sure you you want to publish this listing?', 'utillz-core'),
            ]
        ];
    }

    public function validation() {

        $request = new Custom_Request('input');
        $raw_request = new Raw_Request('input');
        $form = new Form( Form::Storage_Field );
        $submission = new Submission( $request->get('type') );

        // check the listing type
        if( ! $submission->listing_type->id ) {
            return;
        }

        $terms = [];

        foreach( $submission->tabs as $tab ) {
            if( isset( $tab['content'] ) && is_array( $tab['content'] ) ) {
                foreach( $tab['content'] as $item ) {
                    if( $item->fields->is_submit_form && isset( $item->fields->required ) && $item->fields->required == true ) {

                        $field = $form->create(
                            Ucore()->prefix_item( $item )
                        );

                        $terms[ $field->props->id ] = 'required';

                    }
                }
            }
        }

        $validation = new Validation();
		$response = $validation->validate( $request->params, $terms );

        if( $response->success ) {

            $listing_id = wp_insert_post([
                'post_title' => wp_kses_post( $raw_request->get('post_title') ),
                'post_content' => wp_kses_post( $raw_request->get('post_content') ),
                'post_type' => 'ulz_listing',
                'post_status' => $submission->listing_type->get('ulz_requires_admin_approval') ? 'pending' : 'publish',
                'post_author' => get_current_user_id(),
            ]);

            if( ! is_wp_error( $listing_id ) ) {

                $listing = new Listing( $listing_id );

                // set listing type
                add_post_meta( $listing->id, 'ulz_listing_type', $submission->listing_type->id );
                $listing->type = $submission->listing_type;

                /*
                 * save meta data
                 *
                 */
                foreach( $submission->tabs as $tab ) {
                    foreach( $tab['content'] as $item ) {
                        if( $item->fields->is_submit_form ) {

                            $item->fields->key = Ucore()->prefix( $item->fields->key );

                            // set item value from request
                            // $item->fields->value = $request->get( $item->fields->key );
                            if( is_string( $raw_request->get( $item->fields->key ) ) ) {
                                $item->fields->value = wp_kses_post( $raw_request->get( $item->fields->key ) );
                            }else{
                                $item->fields->value = $raw_request->get( $item->fields->key );
                            }

                            $field = $form->create(
                                Ucore()->prefix_item( $item )
                            );

                            $id = $field->props->id;

                            if( $id == 'post_title' || $id == 'post_content' ) {
                                continue;
                            }

                            if( $request->has( $id ) ) {

                                $value = $field->props->value;
                                $value = $field->before_save( $listing->id, $value );

                                // array
                                if( is_array( $value ) ) {
                                    foreach( $value as $val ) {
                                        add_post_meta( $listing->id, $id, $val );
                                    }
                                }
                                // single
                                else{
                                    update_post_meta( $listing->id, $id, $value );
                                }

                                $field->after_save( $listing->id, $value );

                            }
                        }
                    }
                }

                // trigger post update to handle important actions,
                // like setting featured image using the first gallery image
                do_action( 'save_post', $listing->id, get_post( $listing->id ), true );

                /*
                 * static fields
                 *
                 */
                $static_fields = [
        			'ulz_price',
        			'ulz_extra_pricing',
        			'ulz_addons',
                ];

                foreach( $static_fields as $static_field ) {
                    if( $request->has( $static_field ) ) {
                        update_post_meta( $listing->id, $static_field, $request->get( $static_field ) );
                    }
                }

                // required admin approval
                if( $listing->type->get('ulz_requires_admin_approval') ) {

                    $response->listing = [
                        'id' => $listing->id,
                        'button_url' => esc_url( Ucore()->get_submission_page_url() ),
                        'button_text' => esc_html__( 'Add new', 'utillz-core' )
                    ];

                }
                // no admin approval
                else{

                    $response->listing = [
                        'id' => $listing->id,
                        'button_url' => get_permalink( $listing->id ),
                        'button_text' => esc_html__( 'View submission', 'utillz-core' )
                    ];

                }

                /*
                 * notify
                 *
                 */
                utillz_core()->notify->distribute( 'new-listing', [
					'user_id' => get_current_user_id(),
					'meta' => [
                        'listing_id' => $listing->id,
                    ],
				]);

                /*
                 * plan
                 *
                 */
                if( ! $request->is_empty('ulz_plan') ) {

                    $plan = new Plan( $request->get('ulz_plan') );

                    if( $plan->id ) {

                        $availability = $plan->availability();

                        // plan not owned
                        if( $availability === 0 ) {

                            // premium package
                            if( $plan->is_purchasable() ) {

                                // add to cart
                                $listing->awaits_payment();
                                $cart_response = $plan->add_to_cart( $listing->id );

                                $response->listing = $cart_response;
                                return $response;

                            }
                            // free package
                            else{

                                $user_plan_id = $plan->create( null, get_current_user_id() );
                                $listing->pack_away( $user_plan_id );

                            }
                        }
                        // use available plan
                        else{

                            $user_plan_id = $plan->get_first_available_id();
                            $listing->pack_away( $user_plan_id );

                        }

                    }

                }

            }

        }

        return $response;

    }

}
