<?php

namespace UtillzCore\Inc\Src;

class Shortcodes {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        add_action( 'init', [ $this, 'register_shortcodes' ] );

    }

    public function register_shortcodes() {

        // simple search form
        add_shortcode( 'ulz-search-form', [ $this, 'shortcode_search_form' ] );

        // notifications
        add_shortcode( 'ulz-notifications', [ $this, 'shortcode_notifications' ] );

        // favorites
        add_shortcode( 'ulz-favorites', [ $this, 'shortcode_favorites' ] );

        // user action
        add_shortcode( 'ulz-user-action', [ $this, 'shortcode_user_action' ] );

        // user action
        add_shortcode( 'ulz-wallet-balance', [ $this, 'shortcode_wallet_balance' ] );

    }

    public function shortcode_search_form( $atts ) {

        global $ulz_atts;
        $ulz_atts = $atts;

        return Ucore()->get_template('search/form');

    }

    public function shortcode_notifications() {
        return Ucore()->get_template('globals/notifications/toggle');
    }

    public function shortcode_favorites() {
        return Ucore()->get_template('globals/favorites');
    }

    public function shortcode_user_action() {
        return Ucore()->get_template('globals/user_action');
    }

    public function shortcode_wallet_balance() {
        return Ucore()->get_template('globals/wallet_balance');
    }

}
