<?php

namespace UtillzCore\Inc\Src;

use \UtillzCore\Inc\Src;

class Setup {

    use Src\Traits\Singleton;

    function __construct() {

        // content
        add_action('the_content', [ $this, 'content' ]);

        // render modal
        add_action('wp_footer', [ $this, 'modal' ]);

        // return an anonymized IPv4 or IPv6 address
        add_action('utillz/ip/anonymize', function( $ip ) {
            return wp_privacy_anonymize_ip( $ip );
        });

        // listing json-ld
        add_action( 'wp_head', [ $this, 'json_ld' ] );

    }

    public function modal() {

        global $post, $ulz_explore;

        echo '<span class="ulz-overlay" data-action="modal-close"></span>';

        if( ! is_user_logged_in() ) {
            Ucore()->the_template('modals/account/content');
        }

        Ucore()->the_template('modals/conversation/content');
        Ucore()->the_template('modals/favorites/content');

        if( is_object( $post ) && $post->post_type == 'ulz_listing' ) {
            Ucore()->the_template('modals/action-application/content');
        }

    }

    public function content( $content ) {

        // bail on gutenberg update
        if( defined( 'REST_REQUEST' ) && REST_REQUEST ) {
            return;
        }

        if( ! is_admin() && is_main_query() ) {

            switch( get_post_type() ) {

                case 'page':
                    $page_id = get_the_ID();

                    switch( $page_id ) {

                        case get_option('ulz_page_explore'):
                            $content = Ucore()->get_template('explore/explore'); break;
                            break;
                        case get_option('ulz_page_collections'):
                            $content = Ucore()->get_template('collections/collections'); break;
                            break;

                    }

                    break;

                case 'ulz_listing_type':
                    $content = Ucore()->get_template('listing-type/single'); break;
                case 'ulz_listing':
                    $content = Ucore()->get_template('single/single'); break;

            }

        }

        return $content;

    }

    public function json_ld() {

        if( is_single() && get_post_type() == 'ulz_listing' ) {

            $listing = new Src\Listing\Listing( get_the_ID() );

            if( $json_ld = $listing->get_json_ld() ) {
                echo sprintf( '<script type="application/ld+json">%s</script>', wp_json_encode( $json_ld ) );
            }

        }

    }

}
