<?php

namespace UtillzCore\Inc\Src;

use \UtillzCore\Inc\Src\Traits\Singleton;

class Schedule {

    use Singleton;

    function __construct() {

        add_action( 'utillz_check_for_expired_listings', [ $this, 'check_for_expired_listings' ] );
        add_action( 'utillz_check_for_expired_promotions', [ $this, 'check_for_expired_promotions' ] );
        add_action( 'utillz_reset_visits', [ $this, 'reset_visits' ] );

    }

    public function check_for_expired_listings() {

        $listing_ids = get_posts([
			'post_type' => 'ulz_listing',
			'post_status' => 'publish',
			'fields' => 'ids',
			'posts_per_page' => -1,
			'meta_query' => [
				'relation' => 'AND',
				[
					'key' => 'ulz_listing_expires',
					'value' => 0,
					'compare' => '>',
				],
				[
					'key' => 'ulz_listing_expires',
					'value' => date( 'Y-m-d H:i', current_time( 'timestamp' ) ),
					'compare' => '<',
				],
			],
		]);

		if( $listing_ids ) {
			foreach( $listing_ids as $listing_id ) {

                wp_update_post([
                    'ID' => $listing_id,
                    'post_status' => 'expired',
                ]);

                delete_post_meta( $listing_id, 'ulz_listing_expires' );

                /*
                 * send notification
                 *
                 */
                utillz_core()->notify->distribute( 'listing-expired', [
                    'user_id' => get_post_field( 'post_author', $listing_id ),
                    'meta' => [
                        'listing_id' => $listing_id
                    ],
                ]);

			}
		}

	}

	public function check_for_expired_promotions() {

        $listing_ids = get_posts([
			'post_type' => 'ulz_listing',
			'post_status' => 'publish',
			'fields' => 'ids',
			'posts_per_page' => -1,
			'meta_query' => [
				'relation' => 'AND',
				[
					'key' => 'ulz_promotion_expires',
					'value' => 0,
					'compare' => '>',
				],
				[
					'key' => 'ulz_promotion_expires',
					'value' => current_time( 'timestamp' ),
					'compare' => '<',
				],
			],
		]);

		if( $listing_ids ) {
			foreach( $listing_ids as $listing_id ) {

                $old_priority = (int) get_post_meta( $listing_id, 'ulz_old_priority', true );

                delete_post_meta( $listing_id, 'ulz_promotion_expires' );
                delete_post_meta( $listing_id, 'ulz_old_priority' );
                delete_post_meta( $listing_id, 'ulz_priority_custom' );

                update_post_meta( $listing_id, 'ulz_priority', $old_priority );
                switch( $old_priority ) {
                    case 0: update_post_meta( $listing_id, 'ulz_priority_selection', 'normal' ); break;
                    case 1: update_post_meta( $listing_id, 'ulz_priority_selection', 'featured' ); break;
                    case 2: update_post_meta( $listing_id, 'ulz_priority_selection', 'promoted' ); break;
                    default:
                        update_post_meta( $listing_id, 'ulz_priority_selection', 'custom' );
                        update_post_meta( $listing_id, 'ulz_priority_custom', $old_priority );
                }

                /*
                 * send notification
                 *
                 */
                utillz_core()->notify->distribute( 'promotion-expired', [
                    'user_id' => get_post_field( 'post_author', $listing_id ),
                    'meta' => [
                        'listing_id' => $listing_id
                    ],
                ]);

			}
		}
	}

    public function reset_visits() {

        global $wpdb;

        $table = $wpdb->prefix . 'utillz_visits';
        $delete = $wpdb->query("TRUNCATE TABLE $table");

    }

}
