<?php

namespace UtillzCore\Inc\Src\Notification\Notifications;

class Listing_Approved extends \UtillzCore\Inc\Src\Notification\Base {

    public $user_can_manage = true;

    /*
     * general
     *
     */
    public function get_id() {
        return 'listing-approved';
    }

    public function get_name() {
        return esc_html__('Your listing has been approved', 'utillz-core');
    }

    /*
     * email
     *
     */
    public function get_email_subject() {
        return esc_html__( 'Your listing has been approved', 'utillz-core' );
    }

    public function get_email_template() {
        return esc_html__( "Hello {user_display_name},\r\n\r\nYour listing has been approved.", 'utillz-core' );
    }

    /*
     * email admin
     *
     */
    public function get_email_admin_subject() {
        return esc_html__( 'Listing approved', 'utillz-core' );
    }

    public function get_email_admin_template() {
        return esc_html__( "Hello,\r\n\r\nYour listing has been approved", 'utillz-core' );
    }

    /*
     * site
     *
     */
    public function get_site_icon() {
        return [
            'set' => 'material-icons',
            'icon' => 'thumb_up_alt',
        ];
    }

    public function get_site_message() {
        return esc_html__( 'Your listing has been approved', 'utillz-core' );
    }

    public function get_site_url() {
        if( isset( $this->meta['listing_id'] ) ) {
            return get_permalink( $this->meta['listing_id'] );
        }
        return null;
    }

}
