<?php

namespace UtillzCore\Inc\Src\Listing\Modules\Taxonomy;

use \UtillzCore\Inc\Src\Listing\Modules\Module;

class Taxonomy extends Module {

    public function controller() {

        $taxonomy = get_taxonomy( $this->props->id );

        if( ! $taxonomy ) {
            return [];
        }

        $terms = [];
        $include = Ucore()->get( $this->props->id, get_the_ID(), false );

        if( is_array( $include ) && array_sum( $include ) > 0 ) {
            $terms = get_terms( $this->props->id, [
                'hide_empty' => false,
                'include' => $include
            ]);
        }

        if( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
            foreach( $terms as $term ) {
                $term->icon = get_term_meta( $term->term_id, 'ulz_icon', true );
            }
        }else{
            $terms = [];
        }

        return array_merge( (array) $this->props, [
            'id' => $this->props->id,
            'taxonomy' => $taxonomy,
            'terms' => $terms,
            'public' => boolval( $taxonomy->public ),
        ]);

    }

}
