@if( ! empty( $terms ) )
    <div class="ulz-mod-listing ulz-mod-listing-taxonomy" data-type="taxonomy">
        @if( ! empty( $name ) )
            <h4>{{ $name }}</h4>
        @endif
        @if( $style == 'tags' )
            <div class="ulz-listing-tags">
                <ul>
                    @foreach( $terms as $term )
                        @php
                            $term_obj = get_term( $term );
                        @endphp
                        <li>
                            @if( $public )
                                <a href="{{ get_term_link( $term_obj->term_id ) }}">
                                    {{ $term_obj->name }}
                                </a>
                            @else
                                <span>
                                    {{ $term_obj->name }}
                                </span>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>
        @else
            @if( is_array( $terms ) )
                <ul class="ulz-tax-list ulz--style-{{ ( isset( $style ) && ! empty( $style ) ) ? $style : '' }}">
                    @foreach( $terms as $term )
                        <li>
                            @if( ! empty( $term->icon ) )
                                <div class="ulz--icon">
                                    <i class="{{ $term->icon }}"></i>
                                </div>
                            @endif
                            <div class="ulz--label">
                                <p class="ulz-mb-0"><strong>{{ $term->name }}</strong></p>
                                @if( $term->description )
                                    <p class="ulz-mb-1 ulz-mt-1">
                                        {{ $term->description }}
                                    </p>
                                @endif
                            </div>
                        </li>
                    @endforeach
                </ul>
            @endif
        @endif
    </div>
@endif
