<?php

namespace UtillzCore\Inc\Src\Listing\Modules\Gallery;

use \UtillzCore\Inc\Src\Listing\Modules\Module;

class Gallery extends Module {

    public function controller() {

        global $ulz_listing;

        $gallery = $ulz_listing->get_gallery([
            'ulz_gallery_large',
            'ulz_gallery_preview'
        ], $this->props->id );

        return array_merge( (array) $this->props, [
            'name' => $this->props->name,
            'gallery' => $gallery,
            'gallery_num' => count( $gallery ),
            'strings' => (object) [
                'more_images' => esc_html__( '+%s', 'heilz' )
            ]
        ]);

    }

}
