<div class="ulz-mod-action ulz-mod-action-{{ $type }}" data-type="{{ $type }}">

    @php
        global $ulz_listing;
    @endphp

    <div class="ulz-action-button">

        @if( ! empty( $title ) )
            <h5 class="ulz--title">{{ $title }}</h5>
        @endif

        @if( $description )
            <p class="ulz--description">{!! nl2br( wp_kses_post( html_entity_decode( $description ) ) ) !!}</p>
        @endif

        @if( ! empty( $items ) )
            <div class="ulz-mod-content">
                @if( ! empty( $name ) )
                    <h4>{{ $name }}</h4>
                @endif
                <div class="ulz-bullets ulz--columns ulz--x1 @if( $disc ) ulz--disc @endif">
                    <ul>

                        @foreach( $items as $item )

                            @php

                                $field_item = $ulz_listing->get_field_item( $item->fields->key );
                                $type = isset( $item->fields->type ) ? $item->fields->type : '';

                                // custom field
                                if( $field_item ) {

                                    // multiple
                                    if( $field_item->template->id == 'taxonomy' ) {
                                        $meta_value = Ucore()->get( $item->fields->key, $ulz_listing->id, false );

                                        $values = [];
                                        if( is_array( $meta_value ) ) {
                                            foreach( $meta_value as $value ) {
                                                $term = get_term_by( 'id', $value, Ucore()->prefix( $field_item->fields->key ) );
                                                if( ! $term ) {
                                                    continue;
                                                }
                                                $values[] = (object) [
                                                    'name' => $term->name,
                                                    'icon' => get_term_meta( $term->term_id, 'ulz_icon', true ),
                                                ];
                                            }
                                        }

                                        $meta_value = $values;

                                    }
                                    // single
                                    else{
                                        $meta_value = $ulz_listing->get( $item->fields->key );
                                    }

                                    if( ! $meta_value ) {
                                        continue;
                                    }

                                }
                                // built-in field
                                else{
                                    $meta_value = $ulz_listing->get( $item->fields->key );
                                }

                            @endphp

                            {{-- single --}}
                            @if( ! is_array( $meta_value ) )

                                @if( $meta_value )

                                    <li>

                                        @if( isset( $item->fields->icon[0] ) )
                                            {!! utillz_core()->icon->get( $item->fields->icon[0]->icon, $item->fields->icon[0]->set ) !!}
                                        @endif

                                        @switch( $type )

                                            @case('address')
                                                <a href="{{ add_query_arg( [ 'api' => 1, 'query' => urlencode( esc_html( $meta_value ) ) ], 'https://www.google.com/maps/search/' ) }}" target="_blank">
                                                    {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                                </a>
                                                @break

                                            @case('url')
                                                <a href="{{ esc_url( str_replace( '{field}', $meta_value, $item->fields->format ) ) }}" target="_blank">
                                                    @if( isset( $item->fields->type_url_label ) && ! empty( $item->fields->type_url_label ) )
                                                        {{ $item->fields->type_url_label }}
                                                    @else
                                                        {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                                    @endif
                                                </a>
                                                @break

                                            @case('phone')
                                                <a href="tel:{{ $meta_value }}" target="_blank">
                                                    {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                                </a>
                                                @break

                                            @case('email')
                                                <a href="mailto:{{ $meta_value }}" target="_blank">
                                                    {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                                </a>
                                                @break

                                            @case('price')
                                                <span>
                                                    {!! str_replace( '{field}', Ucore()->format_price( $meta_value ), $item->fields->format ) !!}
                                                </span>
                                                @break

                                            @default

                                                <span>
                                                    {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                                </span>

                                        @endswitch

                                    </li>

                                @endif

                            {{-- multiple --}}
                            @else

                                @foreach( $meta_value as $value )
                                    @if( ! is_object( $value ) )
                                        @continue;
                                    @endif
                                    <li>
                                        @if( $value->icon )
                                            <i class="{{ $value->icon }}"></i>
                                        @endif
                                        <span>
                                            {{ str_replace( '{field}', $value->name, $item->fields->format ) }}
                                        </span>
                                    </li>
                                @endforeach

                            @endif

                        @endforeach

                    </ul>
                </div>
            </div>
        @endif

    </div>
</div>
