@include('label.index')

<div class="ulz-upload">

    @if( ! $disabled )

        <!-- input -->
        <textarea class="ulz-upload-input ulz-none" type="text" name="{{ $id }}" placeholder="{{ $placeholder }}" {{ $v_model ? "v-model={$v_model}" : '' }}>{{ is_array( $value ) ? json_encode( $value ) : $value }}</textarea>

        <!-- button -->
        <label for="ulz-upload-{{ $id }}" class="ulz-button ulz-light ulz-upload-button">
            <span>{{ $button['label'] }}</span>
            {{ Ucore()->preloader() }}
        </label>

        <!-- file -->
        @if( ! $is_admin )
            <div class="ulz-none">
                <input class="ulz-upload-file" type="file" id="ulz-upload-{{ $id }}" @php echo $multiple_upload ? 'multiple="true"' : ''; @endphp>
            </div>
        @endif

        <!-- field info -->
        @if( $display_info )
            <div class="ulz-field-info">
                <span>{{ sprintf( $strings->max_file_size, number_format( wp_max_upload_size() / 1048576 ) ) }}</span>
                @if( $multiple_upload )
                    <span>{{ $strings->drag_reorder }}</span>
                @endif
            </div>
        @endif

    @endif

    <!-- image preview -->
    <div class="ulz-image-preview ulz-no-select">
        @if( $preview && is_array( $preview ) )
            @foreach( $preview as $prv )
                <div class="ulz-image-prv-wrapper" data-id="{{ $prv->id }}" data-thumb="{{ $prv->thumb }}">
                    <div class="ulz-image-prv">
                        <div class="ulz-image-prv-outer">
                            <div class="ulz-image-prv-inner">
                                @if( $upload_type == 'image' )
                                    <img src="{{ $prv->thumb }}" alt="">
                                @else
                                    <i class="fas fa-file-alt"></i>
                                @endif
                                @if( ! $disabled )
                                    <span class='ulz-image-remove ulz-transition'><i class='fas fa-times'></i></span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <p class="ulz-file-name">
                        <a class="ulz-ellipsis" href="{{ $prv->url }}" target="_blank">{{ $prv->name }}</a>
                    </p>
                </div>
            @endforeach
        @endif
    </div>

    <!-- error output -->
    <div class="ulz-error-output"></div>

</div>
