<?php

namespace UtillzCore\Inc\Src\Form\Modules\Preview_Marker;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Preview_Marker extends Module {

    public function controller() {

        $image = Ucore()->get_first_array_image( Ucore()->json_decode( Ucore()->get('ulz_marker_image') ) );

        return array_merge( (array) $this->props, [
            'component' => $this->component,
            'props' => [
                'type'                  => Ucore()->get('ulz_marker_type', null, true, 'icon'),
                'icon'                  => Ucore()->get('ulz_icon__icon'),
                'icon_set'              => Ucore()->get('ulz_icon__set'),
                'image'                 => Ucore()->get_first_array_image( Ucore()->json_decode( Ucore()->get('ulz_marker_image') ) ),
                'image_width'           => Ucore()->get('ulz_marker_image_size', null, true, 80),
                'field'                 => Ucore()->get('ulz_marker_field'),
                'field_format'          => Ucore()->get('ulz_marker_field_format', null, true, '%s'),
            ],
            'strings' => (object) [
                'save_changes'          => esc_html__( 'Save changes', 'utillz-core' ),
                'marker_preview'        => esc_html__( 'Marker preview', 'utillz-core' ),
                'upload_marker_image'   => esc_html__( 'Upload marker image', 'utillz-core' ),
                'select_field'          => esc_html__( 'Select field', 'utillz-core' ),
            ]
        ]);

    }

}
