@php

$field_marker_fields = $component->create([
    'type' => 'use_field',
    'id' => 'marker_field',
    'name' => esc_html__('Select marker field', 'utillz-core'),
    'include' => [
        'ulz_price' => esc_html__('Price', 'utillz-core'),
    ],
    'v_model' => 'field',
    'col' => 6,
    'dependency' => [
        'id' => 'marker_type',
        'value' => 'field',
        'compare' => '=',
    ],
]);

$props = array_merge( $props, [
    'fields' => array_map( function( $value ) {
        return htmlentities( $value );
    }, $field_marker_fields->props->options )
]);

@endphp

<ulz-preview-marker :props='{{ json_encode( $props ) }}' inline-template>

    <div class="ulz-form">
        <div class="ulz-grid">
            <div class="ulz-col-6 ulz-col-lg-12">
                <div class="ulz-grid">
                    @php

                        $component->render([
                            'type' => 'select',
                            'id' => 'marker_type',
                            'name' => esc_html__('Type', 'utillz-core'),
                            'v_model' => 'type',
                            'value' => 'icon',
                            'options' => [
                                'icon' => 'Icon',
                                'field' => 'Field',
                                'image' => 'Image',
                            ],
                            'allow_empty' => false
                        ]);

                        $component->render([
                            'type' => 'number',
                            'input_type' => 'range',
                            'id' => 'marker_image_size',
                            'name' => esc_html__('Marker image size', 'utillz-core'),
                            'min' => 0,
                            'max' => 200,
                            'format' => '<strong>%s</strong> px',
                            'v_model' => 'image_width',
                            'dependency' => [
                                'id' => 'marker_type',
                                'value' => 'image',
                                'compare' => '=',
                            ],
                        ]);

                        $component->render([
                            'type' => 'upload',
                            'id' => 'marker_image',
                            'name' => esc_html__('Marker image', 'utillz-core'),
                            'multiple' => false,
                            'v_model' => 'image',
                            'dependency' => [
                                'id' => 'marker_type',
                                'value' => 'image',
                                'compare' => '=',
                            ],
                        ]);

                        echo $field_marker_fields->get();

                        $component->render([
                            'type' => 'text',
                            'id' => 'marker_field_format',
                            'name' => esc_html__('Marker field format', 'utillz-core'),
                            'v_model' => 'field_format',
                            'value' => '%s',
                            'col' => 6,
                            'dependency' => [
                                'id' => 'marker_type',
                                'value' => 'field',
                                'compare' => '=',
                            ],
                        ]);

                    @endphp

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span>{{ $strings->save_changes }}</span>
                        </button>
                    </div>

                </div>
            </div>
            <div class="ulz-col-6 ulz-col-lg-12">

                <div class="ulz-heading">
                    <label class="ulz-ellipsis ">
                        {{ $strings->marker_preview }}
                    </label>
                </div>

                <div class="ulz-prv ulz-flex ulz-flex-column ulz-justify-center ulz-no-select">

                    <div v-if="type == 'icon'" class="ulz-prv-marker ulz-prv-marker-icon">
                        {!! utillz_core()->icon->get( $props['icon'], $props['icon_set'] ) !!}
                    </div>

                    <div v-if="type == 'image'" class="ulz-prv-marker ulz-prv-marker-image">
                        <template v-if="get_image_thumb()">
                            <img v-if="image" :src="get_image_thumb()" v-bind:style="{ width: parseFloat( image_width ) + 'px' }" alt="">
                        </template>
                        <template v-else>
                            <p class="ulz-prv-marker-warning ulz-mb-0">{{ $strings->upload_marker_image }}</p>
                        </template>
                    </div>

                    <div v-if="type == 'field'" class="ulz-prv-marker ulz-prv-marker-field" :class="{ 'ulz-field-empty': ! field }">
                        <template v-if="field">
                            <span v-html="format_heading( field_format, props.fields[ field ] )"></span>
                        </template>
                        <template v-else>
                            {{ $strings->select_field }}
                        </template>
                    </div>

                </div>

            </div>
        </div>
    </div>
</ulz-preview-listing>
