<?php

namespace UtillzCore\Inc\Src\Form\Modules\Map;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Map extends Module {

    public $map_defaults = [
        'Melbourne, Australia',
        '-37.8142176',
        '144.9631608',
    ];

    public function after_build() {
        $this->props->single = false;
    }

    public function finish() {

        // set default
        if( isset( $this->props->default ) && is_array( $this->props->default ) && ! $this->props->value ) {
            $this->props->value = [
                $this->props->default[0],
                $this->props->default[1],
                $this->props->default[2]
            ];
        }

        // set default
        if( empty( $this->props->value ) ) {
            $this->props->value = $this->map_defaults;
        }
    }

    public function before_save( $post_id, $value ) {

        if(
            isset( $value[0] ) &&
            isset( $value[1] ) &&
            isset( $value[2] )
        ) {

            update_post_meta(
                $post_id,
                sprintf( '%s__address', $this->props->id ) ,
                Ucore()->sanitize( $value[0] )
            );

            update_post_meta(
                $post_id,
                sprintf( '%s__lat', $this->props->id ) ,
                Ucore()->sanitize( $value[1] )
            );

            update_post_meta(
                $post_id,
                sprintf( '%s__lng', $this->props->id ),
                Ucore()->sanitize( $value[2] )
            );

        }

        if( isset( $value[3] ) ) {
            update_post_meta(
                $post_id,
                sprintf( '%s__geo_country', $this->props->id ) ,
                Ucore()->sanitize( $value[3] )
            );
        }

        if( isset( $value[4] ) ) {
            update_post_meta(
                $post_id,
                sprintf( '%s__geo_city', $this->props->id ) ,
                Ucore()->sanitize( $value[4] )
            );
        }

        if( isset( $value[5] ) ) {
            update_post_meta(
                $post_id,
                sprintf( '%s__geo_city_alt', $this->props->id ) ,
                Ucore()->sanitize( $value[5] )
            );
        }

        return $value;

    }

    public function controller() {

        return array_merge( (array) $this->props, [
            'api_key' => ! empty( get_option('ulz_google_api_key') ),
            'strings' => (object) [
                'address' => esc_html__('Address', 'utillz-core'),
                'e_g_city' => esc_html__('e.g. Melbourne, Australia', 'utillz-core'),
                'no_api' => esc_html__('The map can\'t be loaded. Please add Google map API key', 'utillz-core'),
                'latitude' => esc_html__('Latitude', 'utillz-core'),
                'longitude' => esc_html__('Longitude', 'utillz-core'),
            ]
        ]);

    }

}
