<?php

namespace UtillzCore\Inc\Src\Form\Modules\Key;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Key extends Module {

    public $pre_defined = [];

    public function before_construct() {

        $this->defaults += [
            'defined'       => true,
        ];

        $this->pre_defined = apply_filters('utillz/form/field/key/pre-defined', [
            'post_title'    => esc_html__('Title', 'utillz-core'),
            'post_content'  => esc_html__('Content', 'utillz-core'),
            'ulz_gallery'   => esc_html__('Gallery', 'utillz-core'),
            'ulz_location'  => esc_html__('Location', 'utillz-core'),
            'ulz_price'     => esc_html__('Price', 'utillz-core'),
        ]);

    }

    public function finish() {

        $this->props->is_defined = array_key_exists( $this->props->value, $this->pre_defined );

        if( $this->props->is_defined ) {
            $this->class[] = 'ulz-is-defined';
        }

    }

    public function controller() {

        return array_merge( (array) $this->props, [
            'pre_defined' => $this->pre_defined,
            'strings' => (object) [
                'defined' => esc_html__('Defined', 'utillz-core'),
                'select' => esc_html__('Select', 'utillz-core'),
                'custom' => esc_html__('Custom', 'utillz-core'),
            ]
        ]);

    }

}
