@include('label.index')

<div class="{{ $defined ? 'ulz-input-group ulz-input-group-custom' : '' }}">
    <div class="ulz-flex">
        <input type="text" value="{{ $value }}" placeholder="{{ $placeholder }}" {{ $v_model ? "v-model={$v_model}" : '' }}>
        @if( $defined )
            <a class="ulz-button ulz--secondary" href="#">
                <span>{{ $strings->defined }}</span>
            </a>
        @endif
    </div>
</div>

@if( $defined )
    <div class="ulz-input-group ulz-input-group-defined">
        <div class="ulz-flex">
            <div class="ulz-select">
                <select>
                    <option value="">{{ $strings->select }}</option>
                    @foreach ( $pre_defined as $pre_key => $pre_value )
                        <option value="{{ $pre_key }}" {{ $pre_key == $value ? 'selected' : '' }}>{{ $pre_value }}</option>
                    @endforeach
                </select>
            </div>
            <a class="ulz-button ulz--secondary" href="#">
                <span>{{ $strings->custom }}</span>
            </a>
        </div>
    </div>
@endif

<input type="hidden" name="{{ $id }}" value="{{ $value }}" {{ $v_model ? "v-model={$v_model}" : '' }} {{ $readonly ? 'form="fake-form-readonly"' : '' }}>
