<?php

namespace UtillzCore\Inc\Src\Form\Modules\Autosuggest;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Autosuggest extends Module {

    public function finish() {

        global $ulz_search_form_id;

        $this->attrs['data-search-form'] = $ulz_search_form_id;
        $this->attrs['data-criteria'] = wp_json_encode( $this->props->criteria );

        if( is_array( $this->props->value ) ) {
            $this->props->value = '';
        }

    }

    public function controller() {

        $term_name = '';
        if( $this->props->id && $this->props->value ) {
            if( $term = get_term_by('slug', $this->props->value, $this->props->id ) ) {
                $term_name = $term->name;
            }
        }

        return array_merge( (array) $this->props, [
            'term_name' => $term_name
        ]);
    }

}
