@php
    global $ulz_explore;
    $args = [];
    if( $ulz_explore->type ) {
        $args['type'] = $ulz_explore->type->get('ulz_slug');
    }
@endphp

<div class="ulz-form-group ulz-col-12">

    @if( $name )
        <div class="ulz-heading">
            <label class="ulz-ellipsis">
                {!! $name !!}
            </label>
        </div>
    @endif

    <div class="ulz-filter-tab @if( ! empty( $labels ) ) ulz-active @endif">
        <div class="ulz-tab-title ulz-no-select" data-label="{{ $label }}">
            @if( ! empty( $labels ) )
                {!! $labels !!}
            @else
                <span>{{ $label }}</span>
            @endif
        </div>
        <div class="ulz-tab-flyout">
            <div class="ulz-tab-content ulz-scrollbar">
                @if( ! empty( $content ) )
                    <div class="ulz-grid">
                        @foreach( $content as $filter )
                            {{ $component->render( array_merge( (array) $filter->fields, [
                                'type' => $filter->template->id,
                            ])) }}
                        @endforeach
                    </div>
                @else
                    {{ $strings->tab_empty }}
                @endif
            </div>
            <div class="ulz-tab-footer">
                <div>
                    <a href="#" class="ulz-button ulz-small">
                        <span>{{ $strings->close }}</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

</div>
