<?php

namespace UtillzCore\Inc\Src\Explore\Filter\Modules\Autosuggest;

use \UtillzCore\Inc\Src\Explore\Filter\Modules\Module;
use \UtillzCore\Inc\Src\Explore\Filter\Comparison;

class Autosuggest extends Module {

    public function after_construct() {

        $this->props->real_id = Ucore()->unprefix( $this->props->id );

        if( is_array( $this->props->criteria ) ) {
            foreach( $this->props->criteria as $criteria ) {
                if( $criteria->template->id == 'field' ) {
                    continue;
                }
                if( ! $this->component->request->is_empty( Ucore()->unprefix( $criteria->fields->id ) ) ) {
                    $this->id = Ucore()->unprefix( $criteria->fields->id );
                    $this->props->id = Ucore()->prefix( $criteria->fields->id );
                }
            }
        }

        $this->props->value = $this->get_value();

    }

    public function before_get() {

        $this->props->format = 'slug>>>name';

    }

    public function get_value() {

        if( isset( $this->id ) ) {
            return $this->component->request->get( $this->id );
        }

    }

    public function is_requested() {

        // search
        if( ! $this->component->request->is_empty( $this->props->real_id ) ) {
            $this->search_type = 'field';
            return true;
        }

        // term
        if( isset( $this->id ) && ! $this->component->request->is_empty( $this->id ) ) {
            $this->search_type = 'term';
            return true;
        }

    }

    public function query() {

        // field
        if( $this->search_type == 'field' ) {

            $query = [
                'relation' => 'OR'
            ];

            if( is_array( $this->props->criteria ) && ! empty( $this->props->criteria ) ) {
    			foreach( $this->props->criteria as $criteria ) {

                    $comparison = new Comparison( $this->props );

                    // field only, taxonomy will be handled elsewhere
    				if( $criteria->template->id == 'field' ) {

                        // post_title and post_content will be handled in post_where filter
                        if( $criteria->fields->id == 'post_title' || $criteria->fields->id == 'post_content' ) {
                            continue;
                        }

                        $query[] = [
                            'key' => $criteria->fields->id,
                            'value' => $this->component->request->get( $this->props->real_id ),
                            'compare' => 'LIKE',
                        ];

                    }
                }

                add_filter( 'posts_where', [ $this, 'posts_where' ], 10, 2 );

                return $query;

            }

        }
        // term
        elseif( $this->search_type == 'term' ) {

            $comparison = new Comparison( $this->props );
            $compare = $comparison->tax_ids()->in()->get();

            return $compare;

        }

    }

    public function get_label() {

        $this->before_get();

        $field = $this->component->form->create( (array) $this->props );

        if( is_array( $field->props->options ) ) {
            if( is_array( $this->props->value ) ) {
                $label = [];
                foreach( $this->props->value as $value ) {
                    if( array_key_exists( $value, $field->props->options ) ) {
                        $label[] = $field->props->options[ $value ];
                    }
                }
                return $label;
            }else{
                return $field->props->options[ $this->props->value ];
            }
        }

    }

    public function get() {

        $this->before_get();

        $field = $this->component->form->create( array_merge( (array) $this->props, [
            'type' => 'autosuggest',
        ]));

        if( ! $field instanceof \UtillzCore\Inc\Src\Error ) {
            return sprintf( $this->wrapper(), $this->props->type, $field->get() );
        }

    }

    function posts_where( $where, $wp_query ) {

        global $wpdb;

        $where_search = "";

        if( $this->search_type == 'field' && $search_term = $this->component->request->get( $this->props->real_id ) ) {

            if( is_array( $this->props->criteria ) && ! empty( $this->props->criteria ) ) {
    			foreach( $this->props->criteria as $criteria ) {

                    // field only, taxonomy will be handled elsewhere
    				if( $criteria->template->id == 'field' ) {

                        // post_title
                        if( $criteria->fields->id == 'post_title' ) {
                            $where_search .= "{$wpdb->posts}.post_title LIKE '%" . stripslashes( $wpdb->esc_like( $search_term ) ) . "%'";
                        }
                        // post_content
                        elseif( $criteria->fields->id == 'post_content' ) {
                            if( ! empty( $where_search ) ) {
                                $where_search .= " OR ";
                            }
                            $where_search .= "{$wpdb->posts}.post_content LIKE '%" . stripslashes( $wpdb->esc_like( $search_term ) ) . "%'";
                        }
                    }
                }
                $where .= " AND ( " . $where_search . " )";
            }
        }

        return $where;

    }

}
