<?php

namespace UtillzCore\Inc\Src\Explore;

use \UtillzCore\Inc\Src\Traits\Singleton;
use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing_Type\Listing_Type;
use \UtillzCore\Inc\Src\User;

class Explore {

    use Singleton;

    public $request;
    public $type;
    public $query = null;
    public $user;
    public $is_explore = false;

    public $total_types = 0;

    function __construct() {

        Init::instance();
        \UtillzCore\Inc\Src\Form\Init::instance();

        $this->request = Request::instance();
        $this->component = Filter\Component::instance();
        $this->user = new User();
        $this->is_explore = Ucore()->is_explore();

        $this->build();

    }

    public function __call( $function, $args ) {

        if( $function == 'query' ) {

            if( $this->query === null ) {
                $this->query = Query::instance();
                $this->query->add_query( $this->get_query() );
                $this->query
                    ->add_meta_query( 'filters', $this->get_meta_query() )
                    ->fetch();

            }

            return $this->query;

        }
    }

    protected function set_types() {

        global $wpdb;

        // get total listing types
        $type_ids = $wpdb->get_results("
            SELECT ID FROM $wpdb->posts p
            RIGHT JOIN $wpdb->postmeta pm ON (
                pm.post_id = p.ID
                AND pm.meta_key = 'ulz_disable_user_submission'
                AND pm.meta_value = ''
            )
            WHERE p.post_status = 'publish'
            AND p.post_type = 'ulz_listing_type'
        ");

        $this->type_ids = $type_ids;
        $this->total_types = count( $type_ids );

    }

    protected function set_current_type() {

        // no types
        if( $this->total_types == 0 ) {
            // ..
        }
        // default type
        elseif( $this->total_types == 1 ) {

            $this->type = new Listing_Type( $this->type_ids[0]->ID );
            $this->main_type = $this->type_ids[0]->ID;

        }
        // multiple types
        else{

            // type in request
            if( ! $this->request->is_empty('type') ) {
                $query = new \WP_Query([
                    'post_status' => 'publish',
                    'post_type' => 'ulz_listing_type',
                    'meta_query' => [
                        [
                            'key' => 'ulz_slug',
                            'value' => $this->request->get('type'),
                            'compare' => '=',
                        ]
                    ]
                ]);

                if( $query->found_posts ) {
                    $this->type = new Listing_Type( $this->request->get('type') );
                }
            }
            // multiple types
            else{

                $this->type = apply_filters('utillz/explore/type', null);

            }

        }

    }

    public function build() {

        $this->set_types();
        $this->set_current_type();

    }

    public function get_pagination_type() {

        if( $this->type ) {
            return esc_attr( $this->type->get('ulz_pagination_type') );
        }

        if( $global_pagination_type = get_option('ulz_global_pagination_type') ) {
            return esc_attr( $global_pagination_type );
        }

    }

    public function get_listing_cover_style() {

        global $ulz_listing_style;

        if( $filters = apply_filters('utillz/explore/layout/cover_style', '') ) {
            return $filters;
        }

        if( ! empty( $ulz_listing_style ) ) {
            return $ulz_listing_style;
        }

        // collection
        if( get_post_type() == 'ulz_collection' ) {
            $ulz_listing_style = Ucore()->get('ulz_collection_cover_style');
            return $ulz_listing_style;
        }

        if( $this->type ) {
            return esc_attr( $this->type->get('ulz_listing_cover_style') );
        }

        if( $global_display_style = get_option('ulz_global_listing_cover_style') ) {
            return esc_attr( $global_display_style );
        }

    }

    public function get_explore_type() {

        if( $filters = apply_filters('utillz/explore/layout/type', '') ) {
            return $filters;
        }

        // collection
        if( get_post_type() == 'ulz_collection' ) {
            return esc_attr( Ucore()->get('ulz_collection_explore_type') );
        }

        // global
        if( ! $this->type ) {
            return esc_attr( get_option('ulz_global_explore_type') );
        }
        // type
        else{
            return esc_attr( $this->type->get('ulz_explore_type') );
        }

    }

    public function get_explore_columns() {

        if( $filters = apply_filters('utillz/explore/layout/columns', '') ) {
            return $filters;
        }

        // collection
        if( get_post_type() == 'ulz_collection' ) {
            return esc_attr( Ucore()->get('ulz_collection_explore_columns') );
        }

        // global
        if( ! $this->type ) {
            $global_explore_columns = get_option('ulz_global_explore_columns');
            return $global_explore_columns ? $global_explore_columns : 3;
        }

        $explore_columns = (int) $this->type->get('ulz_explore_columns');

        if( empty( $explore_columns ) ) {
            $explore_columns = 3;
        }

        return (int) $explore_columns;

    }

    public function get_meta_query() {

        $meta_query = [];

        // type
        if( $this->type ) {
            $meta_query[] = [
                'key' => 'ulz_listing_type',
                'value' => $this->type->id,
            ];
        }
        // global
        else{

            $is_main_explore_page = boolval( get_the_ID() == get_option('ulz_page_explore') );

            if( $is_main_explore_page || is_author() ) {
                $global_listing_types = new \WP_Query([
                    'post_status' => 'publish',
                    'post_type' => 'ulz_listing_type',
                    'posts_per_page' => -1,
                    'fields' => 'ids',
                    'meta_query' => [
                        'relation' => 'OR',
                        [
                            'key' => 'ulz_hide_global',
                            'value' => '1',
                            'compare' => '!=',
                        ],
                        [
                            'key' => 'ulz_hide_global',
                            'value' => '1',
                            'compare' => 'NOT EXISTS',
                        ]
                    ]
                ]);

                if( $global_listing_types ) {
                    $meta_query[] = [
                        'key' => 'ulz_listing_type',
                        'value' => $global_listing_types->posts,
                    ];
                }
            }
        }

        $filters = [];

        /*
         * inline listing filters
         *
         */
        $search_form = $this->type ? Ucore()->get( 'ulz_search_form', $this->type->id ) : get_option('ulz_global_search_form');
        $search_form_more = $this->type ? Ucore()->get( 'ulz_search_form_more', $this->type->id ) : get_option('ulz_global_search_form_more');
        $primary_search_form = get_option( 'ulz_primary_search_form' );

        if( $search_form || $search_form_more || $primary_search_form ) {

            // search form
            $search_filters = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $search_form ) );
            if( empty( $search_filters ) || ! is_array( $search_filters ) ) {
                $search_filters = [];
            }

            // search form more
            $search_filters_more = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $search_form_more ) );
            if( empty( $search_filters_more ) || ! is_array( $search_filters_more ) ) {
                $search_filters_more = [];
            }

            // primary search
            $search_filters_primary = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $primary_search_form ) );
            if( empty( $search_filters_primary ) || ! is_array( $search_filters_primary ) ) {
                $search_filters_primary = [];
            }

            $search_filters_all = array_merge( $search_filters, $search_filters_more, $search_filters_primary );

            foreach( $search_filters_all as $filter ) {

                if( ! isset( $filter->fields->id ) ) {
                    continue;
                }

                // ulz_type will be handled as ulz_listing_type
                if( $filter->fields->id == 'ulz_type' ) {
                    continue;
                }

                if( in_array( $filter->fields->id, [
                    'post_title',
                    'post_content',
                ])) {
                    continue;
                }

                $filter->fields->id = Ucore()->prefix( $filter->fields->id );

                if( in_array( $filter->fields->id, $filters ) ) {
                    continue;
                }

                $filters[] = $filter->fields->id;

                $filter = $this->component->create( array_merge( (array) $filter->fields, [
                    'type' => $filter->template->id
                ]));

                if( ! Ucore()->is_error( $filter ) ) {

                    if( $filter->is_requested() ) {
                        $query = $filter->query();
                        if( ! empty( $query ) ) {
                            $meta_query[] = $query;
                        }
                    }
                }
            }
        }

        return $meta_query;

    }

    public function get_query() {

        $meta_query = [];
        $filters = [];

        /*
         * inline listing filters
         *
         */
        $search_form = $this->type ? Ucore()->get( 'ulz_search_form', $this->type->id ) : get_option('ulz_global_search_form');

        if( $search_form ) {

            $search_filters = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $search_form ) );
            if( empty( $search_filters ) || ! is_array( $search_filters ) ) {
                $search_filters = [];
            }

            $search_filters_more = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields_more', $search_form ) );
            if( empty( $search_filters_more ) || ! is_array( $search_filters_more ) ) {
                $search_filters_more = [];
            }

            $search_filters_all = array_merge( $search_filters, $search_filters_more );

            foreach( $search_filters_all as $filter ) {

                if( ! isset( $filter->fields->id ) ) {
                    continue;
                }

                // ulz_type will be handled as ulz_listing_type
                if( $filter->fields->id == 'ulz_type' ) {
                    continue;
                }

                if( in_array( $filter->fields->id, [
                    'post_title',
                    'post_content',
                ])) {
                    continue;
                }

                $filter->fields->id = Ucore()->prefix( $filter->fields->id );

                if( in_array( $filter->fields->id, $filters ) ) {
                    continue;
                }

                $filters[] = $filter->fields->id;

                $filter = $this->component->create( array_merge( (array) $filter->fields, [
                    'type' => $filter->template->id
                ]));

                if( ! Ucore()->is_error( $filter ) ) {

                    if( $filter->is_requested() ) {
                        $query = $filter->main_query();
                        if( ! empty( $query ) ) {
                            $meta_query = array_merge( $meta_query, $query );
                        }
                    }
                }
            }
        }

        return $meta_query;

    }

}
