<?php

namespace UtillzCore\Inc\Src\Entry\Modules\Application;

use \UtillzCore\Inc\Src\Entry\Modules\Module;
use \UtillzCore\Inc\Src\Listing\Listing;

class Application extends Module {

    protected function get_data() {

        $listing = new Listing( Ucore()->get('ulz_listing') );

        return [
            'form' => $this->component->form,
            'action_application' => $listing->type->get_action_type('application'),
        ];

    }

    protected function get_strings() {
        return [
            'action_type_not_found' => esc_html__('Action type was not found.', 'utillz-core'),
        ];
    }

    public function admin() {
        return array_merge( (array) $this->props, $this->get_data(), [
            'strings' => (object) array_merge( $this->get_strings(), [])
        ]);
    }

    public function controller() {
        return array_merge( (array) $this->props, $this->get_data(), [
            'strings' => (object) array_merge( $this->get_strings(), [])
        ]);
    }

}
