<?php

namespace UtillzCore\Inc\Src\Admin;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Form\Component as Form;

class Term_Metabox {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        add_action( 'admin_init', [ $this, 'init' ] );

    }

    public function init() {

        global $pagenow;

        $taxonomies = [
            'ulz_listing_category',
            'ulz_listing_region',
            'ulz_listing_tag',
        ];

        // add custom taxonomies
        $custom_taxonomies = Ucore()->get_custom_taxonomies();
        foreach( $custom_taxonomies as $custom_taxonomy ) {
            $taxonomies[] = Ucore()->prefix( $custom_taxonomy->slug );
        }

        // init panel
        if( in_array( $pagenow, [ 'edit-tags.php', 'term.php' ] ) ) {
            $request = Request::instance();
            if( $request->has('taxonomy') && in_array( $request->get('taxonomy'), $taxonomies ) ) {
                Panel::instance();
            }
        }

        foreach( $taxonomies as $taxonomy ) {

            // meta
            add_action( sprintf( '%s_add_form_fields', $taxonomy ), [ $this, 'taxonomy_add_custom_field' ], 10, 1 );
            add_action( sprintf( '%s_edit_form_fields', $taxonomy ), [ $this, 'taxonomy_edit_custom_field' ], 10, 1 );

            // save
            add_action( sprintf( 'edited_%s', $taxonomy ), [ $this, 'save_taxonomy_custom_meta_field' ], 10, 1 );
            add_action( sprintf( 'create_%s', $taxonomy ), [ $this, 'save_taxonomy_custom_meta_field' ], 10, 1 );

        }

    }

    function taxonomy_add_custom_field( $taxonomy ) {
        Ucore()->the_template('admin/term-metabox/terms-add');
    }

    function taxonomy_edit_custom_field( $tag ) {
        echo '<tr>
            <th scope="row" valign="top">' . esc_html__('Term Options', 'utillz-core') . '</th>
            <td>' . Ucore()->get_template('admin/term-metabox/terms-edit') . '</td>
        </tr>';
    }

    function save_taxonomy_custom_meta_field( $term_id ) {

        $request = Request::instance();
        $form = new Form( Form::Storage_Request );

        $fields = [];
        $fields[] = $form->create([
            'type' => 'icon',
            'id' => 'ulz_icon',
        ]);
        $fields[] = $form->create([
            'type' => 'icon',
            'id' => 'ulz_image',
        ]);

        foreach( $fields as $field ) {
            if( $request->has( $field->props->id ) ) {
                $this->save(
                    $term_id,
                    $field->props->id,
                    $field->props->value
                );
            }
        }

    }

    public function save( $term_id, $term_meta_name, $term_meta_value ) {

        if( is_array( $term_meta_value ) ) {
            delete_term_meta(
                $term_id,
                $term_meta_name
            );
            foreach( $term_meta_value as $tm_value ) {
                add_term_meta(
                    $term_id,
                    $term_meta_name,
                    $tm_value
                );
            }
        }else{
            delete_term_meta(
                $term_id,
                $term_meta_name
            );
            update_term_meta(
                $term_id,
                $term_meta_name,
                $term_meta_value
            );
        }

    }
}
