<?php

namespace UtillzCore\Inc\Src\Admin\Http;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Xhr {

	use \UtillzCore\Inc\Src\Traits\Singleton;

    public function __construct() {

		if( wp_doing_ajax() && isset( $_REQUEST['action'] ) ) {

			$this->display_errors();
			$this->init_endpoints();

	        add_action( 'init', [ $this, 'forgery' ] );

        }
	}

    function init_endpoints() {

		foreach( glob( UTILLZ_CORE_PATH . 'inc/src/admin/http/endpoints/*.php') as $file ) {
			$endpoint_classname = sprintf( '\UtillzCore\Inc\Src\Admin\Http\Endpoints\%s', basename( str_replace( '-', '_', $file ), '.php' ) );
			new $endpoint_classname;
		}

	}

    function display_errors() {

		if( defined( 'WP_DEBUG' ) && WP_DEBUG === true ) {
			@ini_set( 'display_errors', 1 );
		}

    }

	public function forgery() {

		global $ulz_explore;
		$ulz_explore = \UtillzCore\Inc\Src\Explore\Explore::instance();

	}
}
