<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Field_Upload extends Endpoint {

	public $action = 'utillz-field-upload';

	public $image_mime_types = [
		'image/jpeg',
		'image/png'
	];

    public function action() {

		add_action( 'ulz_upload_action', [ $this, sanitize_text_field( $_POST['ulz_action'] ) ] );
		die( do_action( 'ulz_upload_action' ) );

	}

	public function upload() {

		$request = Request::instance();

		if( $request->is_empty('upload_type') || ! in_array( $request->get('upload_type'), [ 'image', 'file' ] ) ) {
			wp_send_json([
				'success' => false,
				'error' => esc_html__( 'Something went wrong', 'utillz-core' )
			]);
		}

		$data = isset( $_FILES ) ? $_FILES : [];

		$response['success'] = false;

		$wordpress_upload_dir = wp_upload_dir();
		// $wordpress_upload_dir['path'] is the full server path to wp-content/uploads/2017/05, for multisite works good as well
		// $wordpress_upload_dir['url'] the absolute URL to the same folder, actually we do not need it, just to show the link to file
		$i = 1; // number of tries when the file with the same name is already exists

		$upload = $data['ulz_file_upload'];

		$filetype = wp_check_filetype_and_ext( $upload['tmp_name'], $upload['name'] );
		$filename = sprintf('%s.%s', Ucore()->random(), $filetype['ext']);

		$new_file_path = $wordpress_upload_dir['path'] . '/' . $filename;
		$new_file_mime = wp_check_filetype_and_ext( $new_file_path, $filename );

		$upload_type = $request->get('upload_type');
		if( $upload_type == 'image' ) {
			if( ! in_array( $new_file_mime['type'], $this->image_mime_types ) ) {
				wp_send_json([
					'success' => false,
					'error' => esc_html__( 'File type is not allowed', 'utillz-core' )
				]);
			}
		}

		if( empty( $upload ) ) {
			wp_send_json([
				'success' => false,
				'error' => esc_html__( 'File is not selected', 'utillz-core' )
			]);
		}

		if( $upload['error'] ) {
			wp_send_json([
				'success' => false,
				'error' => $upload['error']
			]);
		}

		if( $upload['size'] > wp_max_upload_size() ) {
			wp_send_json([
				'success' => false,
				'error' => esc_html__( 'It is too large than expected', 'utillz-core' )
			]);
		}

		if( ! in_array( $new_file_mime['type'], get_allowed_mime_types() ) ) {
			wp_send_json([
				'success' => false,
				'error' => esc_html__( 'File type is not allowed', 'utillz-core' )
			]);
		}

		while( file_exists( $new_file_path ) ) {
			$i++;
			$new_file_path = $wordpress_upload_dir['path'] . '/' . $i . '_' . $filename;
		}

		// looks like everything is OK
		if( move_uploaded_file( $upload['tmp_name'], $new_file_path ) ) {

			$attachment_id = wp_insert_attachment([
				'guid'           => $new_file_path,
				'post_mime_type' => $new_file_mime['type'],
				'post_title'     => preg_replace( '/\.[^.]+$/', '', $filename ),
				'post_content'   => '',
				'post_status'    => 'inherit'
			], $new_file_path );

			// generate and save the attachment meta data
			wp_update_attachment_metadata( $attachment_id, wp_generate_attachment_metadata( $attachment_id, $new_file_path ) );

			$image_attributes = wp_get_attachment_image_src( $attachment_id, 'ulz_thumbnail' );

			do_action('utillz/upload', $attachment_id);

			$response = [
				'success' => true,
				'id' => $attachment_id,
				'thumb' => ( $upload_type == 'image' && isset( $image_attributes[0] ) ) ? $image_attributes[0] : null,
				'url' => wp_get_attachment_url( $attachment_id ),
				'name' => basename( get_attached_file( $attachment_id ) ),
			];

		}

		wp_send_json( $response );

	}

	public function delete() {

		// TODO ..

	}

}
