<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Field_Autosuggest extends Endpoint {

	public $action = 'utillz-field-autosuggest';

    public function action() {

		global $wpdb;

		$request = Src\Request\Request::instance();

		if( ! $search_form_id = $request->get('search_form') ) {
			return;
		}

		if( ! $criteria_data = $request->get('criteria') ) {
			return;
		}

		$limit = 10;
		$content = '';

		// user listing type from search form
		$meta_query_listing_type = [
			'relation' => 'AND',
		];

		if( $listing_type_slug = Ucore()->get( 'ulz_listing_type', $search_form_id ) ) {
			$listing_type = new Src\Listing_Type\Listing_Type( $listing_type_slug );
			if( $listing_type->id ) {
				$meta_query_listing_type[] = [
					'key' => 'ulz_listing_type',
					'value' => $listing_type->id
				];
			}
		}

		$criterias = Ucore()->json_decode( $criteria_data );
		$items = [];

		if( is_array( $criterias ) ) {
			foreach( $criterias as $criteria ) {

				// field
				if( $criteria->template->id == 'field' ) {

					$meta_query_fields = [
						'relation' => 'OR',
					];

					$args = [
			            'post_type' => [
							'ulz_listing',
						],
			            'post_status' => 'publish',
			            'posts_per_page' => $limit
			        ];

					// title
					if( $criteria->fields->id == 'post_title' ) {
						add_filter( 'posts_where', [ $this, 'where_title' ], 10, 2 );
					}
					// content
					elseif( $criteria->fields->id == 'post_content' ) {
						add_filter( 'posts_where', [ $this, 'where_content' ], 10, 2 );
					}
					// meta
					else{
						$meta_query_fields[] = [
		                    'key' => Ucore()->prefix( $criteria->fields->id ),
		                    'value' => $request->get('s'),
		                ];
					}

					$args['meta_query'] = $meta_query_listing_type;
					$args['meta_query'][] = $meta_query_fields;

					// dd( $args );

					$query = new \WP_Query( $args );

					if( $query->have_posts() ) {
						while( $query->have_posts() ) { $query->the_post();
							$items[ 'field_' . get_the_id() ] = (object) [
								'type' => 'field',
								'id' => get_the_id(),
								'name' => get_the_title(),
							];
						}
						wp_reset_postdata();
					}

					$args['post_type'] = 'ulz_collection';
					$args['meta_query'] = $meta_query_fields;

					// dd( $args );

					$query = new \WP_Query( $args );

					if( $query->have_posts() ) {
						while( $query->have_posts() ) { $query->the_post();
							$items[ 'field_' . get_the_id() ] = (object) [
								'type' => 'field',
								'id' => get_the_id(),
								'name' => get_the_title(),
							];
						}
						wp_reset_postdata();
					}

					$this->clear_filters();

				}

				// term
				else{

					if( empty( $criteria->fields->id ) ) {
						continue;
					}

					$terms = get_terms([
						'taxonomy' => Ucore()->prefix( $criteria->fields->id ),
						'hide_empty' => false,
						'fields' => 'all',
						'name__like' => $request->get('s'),
						'number' => $limit,
					]);

					foreach( $terms as $term ) {
						$taxonomy = get_taxonomy( $term->taxonomy );
						$items[ 'term_' . $term->term_id ] = (object) [
							'type' => 'term',
							'id' => $term->slug,
							'name' => $term->name,
							'taxonomy' => Ucore()->prefix( $criteria->fields->id ),
							'taxonomy_name' => $taxonomy->labels->singular_name,
							'icon_set' => $criteria->fields->icon__set,
							'icon_icon' => $criteria->fields->icon__icon,
						];
					}
				}
			}
		}

		$items = array_slice( $items , 0, $limit );

		global $ulz_item;

		foreach( $items as $item ) {

			$ulz_item = $item;

			ob_start();
			include UTILLZ_CORE_PATH . 'inc/src/form/modules/autosuggest/row.php';
			$content .= ob_get_clean();

		}

        $return = [
            'success' => true,
            'content' => $content,
            'found' => count( $items ),
        ];

        wp_send_json( $return );

	}

	function where_title( $where, $wp_query ) {

        global $wpdb;

		$request = Src\Request\Request::instance();

        if( $s = $request->get('s') ) {
            $where .= " AND {$wpdb->posts}.post_title LIKE '%" . stripslashes( $wpdb->esc_like( $s ) ) . "%'";
        }

        return $where;

    }

	function where_content( $where, $wp_query ) {

        global $wpdb;

		$request = Src\Request\Request::instance();

        if( $s = $request->get('s') ) {
            $where .= " AND {$wpdb->posts}.post_content LIKE '%" . stripslashes( $wpdb->esc_like( $s ) ) . "%'";
        }

        return $where;

    }

	public function clear_filters() {

        remove_filter( 'posts_where', [ $this, 'where_title' ], 10 );
        remove_filter( 'posts_where', [ $this, 'where_content' ], 10 );

    }

}
