<?php

namespace UtillzCore\Inc\Src;

// use \UtillzCore\Inc\Src\Form\Modules;

class Admin {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        if( is_admin() ) {

            Admin\Http\Xhr::instance();
            Admin\Settings::instance();
            Admin\Metabox::instance();
            Admin\Term_Metabox::instance();
            Admin\Comments::instance();
            Admin\Import::instance();

            $this->columns();

            add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

            add_action( 'image_size_names_choose', [ $this, 'default_image_sizes' ] );

            add_action( 'display_post_states', [ $this, 'page_states' ], 10, 2 );

            add_action( 'admin_head-post.php', [ $this, 'duplicate' ] );

        }

    }

    protected function columns() {

        Admin\Columns\Listing_Type::instance();
        Admin\Columns\Listing::instance();
        Admin\Columns\Search_Form::instance();
        Admin\Columns\Entry::instance();
        Admin\Columns\Collection::instance();
        Admin\Columns\Report::instance();
        Admin\Columns\Conversation::instance();
        Admin\Columns\Plan::instance();
        Admin\Columns\Promotion::instance();
        Admin\Columns\Icon_Set::instance();

    }

    public function default_image_sizes( $sizes ) {
        return array_merge( $sizes, [
            'ulz_thumbnail' => esc_html__( 'Utillz Thumbnail', 'utillz-core' ),
        ]);
    }

    public function get_admin_vars() {

        $vars = [
            'post_id' => null,
            'debug' => Ucore()->debug,
            'is_admin' => true,
            'admin_ajax' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax-nonce'),
            'site_url' => site_url('/'),
            'uri' => UTILLZ_CORE_URI,
            'localize' => [
                'select_module' => esc_html__('Please select a module', 'utillz-core')
            ],
            'map' => [
                'style' => get_option('ulz_google_map_style', 'default'),
                'geolocation_restrictions' => Ucore()->get_geolocation_restrictions()
            ],
        ];

        global $post;
        if( isset( $post->ID ) ) {
            $vars['post_id'] = $post->ID;
        }

        return $vars;

    }

    public function enqueue_scripts( $hook ) {

        // media
        wp_enqueue_media();

        /*
         * google fonts
         *
         */
        wp_enqueue_style( 'google-fonts', '//fonts.googleapis.com/css2?display=swap&family=Open+Sans:wght@400;600;700&family=Poppins:wght@400;700;800', [], null );

        /*
         * icons
         *
         */
        wp_enqueue_style( 'font-awesome', UTILLZ_CORE_URI . 'assets/dist/fonts/font-awesome/css/all.min.css', [], UTILLZ_CORE_VERSION );
        wp_enqueue_style( 'material-icons', UTILLZ_CORE_URI . 'assets/dist/fonts/material-icons/material-icons.css' );

        // enqueue custom icon sets
		foreach( utillz_core()->icon->custom_sets as $set_id => $set ) {
			if( isset( $set['css_url'] ) && $set['css_url'] !== '' ) {
				wp_enqueue_style( 'utillz-custom-icons-' . $set_id, $set['css_url'], [], UTILLZ_CORE_VERSION, 'all' );
			}
		}

        /*
         * main
         *
         */

        // layouts
        wp_register_style( 'utillz-layouts', UTILLZ_CORE_URI . 'assets/dist/css/layouts.css', [], UTILLZ_CORE_VERSION );

        // css
        wp_enqueue_style( 'utillz-core-admin-style', UTILLZ_CORE_URI . 'assets/dist/css/admin/admin.css', ['utillz-layouts'], UTILLZ_CORE_VERSION );

        // js
        wp_register_script( 'utillz-core-admin-script', UTILLZ_CORE_URI . 'assets/dist/js/admin/admin.js', ['jquery'], UTILLZ_CORE_VERSION, true );
        wp_localize_script( 'utillz-core-admin-script', 'utillz_core_vars', $this->get_admin_vars() );
        wp_enqueue_script( 'utillz-core-admin-script' );

        /*
         * google maps api
         *
         */
        if( $google_api_key = get_option( 'ulz_google_api_key' ) ) {
            wp_register_script( 'googleapis', sprintf( '%s://maps.googleapis.com/maps/api/js?&key=%s&libraries=places', 'https', esc_attr( $google_api_key ) ), [], UTILLZ_CORE_VERSION, true );
        }

        /*
         * form
         *
         */
        $args = ['jquery', 'jquery-ui-sortable', 'select2'];
        if( $google_api_key ) {
            $args[] = 'googleapis';
        }
        wp_register_script( 'utillz-form', UTILLZ_CORE_URI . 'assets/dist/js/form.js', $args, UTILLZ_CORE_VERSION, true );
        wp_register_style( 'utillz-form', UTILLZ_CORE_URI . 'assets/dist/css/form.css', ['select2'], UTILLZ_CORE_VERSION );

        /*
         * panel
         *
         */
        wp_register_script( 'utillz-panel', UTILLZ_CORE_URI . 'assets/dist/js/admin/panel.js', ['utillz-form', 'vuejs'], UTILLZ_CORE_VERSION, true );
        wp_register_style( 'utillz-panel', UTILLZ_CORE_URI . 'assets/dist/css/admin/panel.css', ['utillz-form'], UTILLZ_CORE_VERSION );

        /*
         * vuejs
         *
         */
        wp_register_script( 'vuejs', UTILLZ_CORE_URI . 'assets/dist/lib/vuejs/vue' . Ucore()->assets_min . '.js', [], UTILLZ_CORE_VERSION, true );

        /*
         * select2
         *
         */
        wp_register_script( 'select2', UTILLZ_CORE_URI . 'assets/dist/lib/select2/js/select2' . Ucore()->assets_min . '.js', [], UTILLZ_CORE_VERSION, true );
        wp_register_style( 'select2', UTILLZ_CORE_URI . 'assets/dist/lib/select2/css/select2' . Ucore()->assets_min . '.css' );

    }

    public function duplicate() {

        global $post;

        if( current_user_can( 'edit_post', $post->ID ) ) {
            if( ( $post->post_type == 'ulz_listing' || $post->post_type == 'ulz_listing_type' ) && isset( $_GET['duplicate'] ) ) {

                $title = get_the_title( $post->ID );

                $duplicate_args = [
                    'post_title' => sprintf( '%s (copy)', $title ),
                    'post_content' => $post->post_content,
                    'post_status' => $post->post_status,
                    'post_type' => $post->post_type,
                    'post_author' => get_current_user_id()
                ];

                $duplicate_post_id = wp_insert_post( $duplicate_args );

                // meta
                $data = get_post_custom( $post->ID );

                foreach( $data as $key => $values ) {
                    foreach( $values as $value ) {
                        add_post_meta( $duplicate_post_id, $key, $value );
                    }
                }

                if( $post->post_type == 'ulz_listing_type' ) {
                    update_post_meta( $duplicate_post_id, 'ulz_name', sprintf( '%s (copy)', esc_html( Ucore()->get( 'ulz_name', $post->ID ) ) ) );
                    update_post_meta( $duplicate_post_id, 'ulz_name_plural', sprintf( '%s (copy)', esc_html( Ucore()->get( 'ulz_name_plural', $post->ID ) ) ) );
                    update_post_meta( $duplicate_post_id, 'ulz_slug', sprintf( '%s-copy', esc_html( Ucore()->get( 'ulz_slug', $post->ID ) ) ) );
                }

                wp_redirect( admin_url( sprintf( 'edit.php?post_type=%s', $post->post_type ) ) );
                exit;

            }
        }

    }

    static function page_states( $post_states, $post ) {

    	if( $post->post_type == 'page' ) {
            switch( $post->ID ) {
                case get_option('ulz_page_explore'):
                    $post_states[] = esc_html__( 'Explore Page', 'utillz-core' );
                        break;
                case get_option('ulz_page_submission'):
                    $post_states[] = esc_html__( 'Submission Page', 'utillz-core' );
                        break;
            }
    	}

    	return $post_states;

    }

}
