<?php

namespace UtillzCore\Inc\Extensions\Component;

use \UtillzCore\Inc\Extensions\Blade\Blade;

abstract class Init {

    function __construct() {

        // component level enqueue scripts
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

    }

    public function enqueue_scripts() {}

    public function engine() {

        $reflector = new \ReflectionClass( $this );
        $path = dirname( $reflector->getFileName() );

        return Blade::engine(
            $path . '/modules',
            UTILLZ_CORE_PATH . 'inc/extensions/blade/cache/' . basename( $path )
        );

    }

}
