'use strict'

import bows from 'bows'

localStorage.debug = true

const object = {
    default: bows('Default'),
    site: bows('Site'),
    admin: bows('Admin'),
    panel: bows('Panel'),
    form: bows('Form'),
    fields: bows('Fields'),
    submission: bows('Submission'),
    explore: bows('Explore'),
    map: bows('Map'),
    dynamic: bows('Dynamic'),
    listing: bows('Listing'),
    account: bows('Account'),
}

export default {
    log( name, message ) {
        if( ! window.utillz_core_vars.debug ) {
            return;
        }
        if( object[ name ] ) {
            object[ name ].log( message )
        }
    }
}
